/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.appcenter.crashes.utils;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.microsoft.appcenter.Constants;
import com.microsoft.appcenter.crashes.ingestion.models.Exception;
import com.microsoft.appcenter.crashes.ingestion.models.ManagedErrorLog;
import com.microsoft.appcenter.crashes.ingestion.models.StackFrame;
import com.microsoft.appcenter.crashes.ingestion.models.Thread;
import com.microsoft.appcenter.crashes.model.ErrorReport;
import com.microsoft.appcenter.ingestion.models.Device;
import com.microsoft.appcenter.utils.AppCenterLog;
import com.microsoft.appcenter.utils.DeviceInfoHelper;
import com.microsoft.appcenter.utils.context.UserIdContext;
import com.microsoft.appcenter.utils.storage.FileManager;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class ErrorLogHelper {
    public static final String DEVICE_INFO_FILE = "deviceInfo";
    public static final String ERROR_LOG_FILE_EXTENSION = ".json";
    public static final String THROWABLE_FILE_EXTENSION = ".throwable";
    private static final String MINIDUMP_DIRECTORY = "minidump";
    private static final String NEW_MINIDUMP_DIRECTORY = "new";
    private static final String PENDING_MINIDUMP_DIRECTORY = "pending";
    @VisibleForTesting
    public static final int FRAME_LIMIT = 256;
    private static final int FRAME_LIMIT_HALF = 128;
    @VisibleForTesting
    static final int CAUSE_LIMIT = 16;
    private static final int CAUSE_LIMIT_HALF = 8;
    @VisibleForTesting
    static final String ERROR_DIRECTORY = "error";
    private static File sErrorLogDirectory;
    private static final int MAX_PROPERTY_COUNT = 20;
    public static final int MAX_PROPERTY_ITEM_LENGTH = 125;
    public static final String MINIDUMP_FILE_EXTENSION = ".dmp";
    private static File sNewMinidumpDirectory;
    private static File sPendingMinidumpDirectory;
    @VisibleForTesting
    static String DEVICE_INFO_KEY;
    @VisibleForTesting
    static String USER_ID_KEY;

    @NonNull
    public static ManagedErrorLog createErrorLog(@NonNull Context context, @NonNull java.lang.Thread thread, @NonNull Throwable throwable, @NonNull Map<java.lang.Thread, StackTraceElement[]> allStackTraces, long initializeTimestamp) {
        return ErrorLogHelper.createErrorLog(context, thread, ErrorLogHelper.getModelExceptionFromThrowable(throwable), allStackTraces, initializeTimestamp, true);
    }

    @NonNull
    public static ManagedErrorLog createErrorLog(@NonNull Context context, @NonNull java.lang.Thread thread, @NonNull Exception exception, @NonNull Map<java.lang.Thread, StackTraceElement[]> allStackTraces, long initializeTimestamp, boolean fatal) {
        List runningAppProcesses;
        ManagedErrorLog errorLog = new ManagedErrorLog();
        errorLog.setId(UUID.randomUUID());
        errorLog.setTimestamp(new Date());
        errorLog.setUserId(UserIdContext.getInstance().getUserId());
        try {
            errorLog.setDevice(DeviceInfoHelper.getDeviceInfo((Context)context));
        }
        catch (DeviceInfoHelper.DeviceInfoException e) {
            AppCenterLog.error((String)"AppCenterCrashes", (String)"Could not attach device properties snapshot to error log, will attach at sending time", (Throwable)e);
        }
        errorLog.setProcessId(Process.myPid());
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager != null && (runningAppProcesses = activityManager.getRunningAppProcesses()) != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : runningAppProcesses) {
                if (runningAppProcessInfo.pid != Process.myPid()) continue;
                errorLog.setProcessName(runningAppProcessInfo.processName);
            }
        }
        if (errorLog.getProcessName() == null) {
            errorLog.setProcessName("");
        }
        errorLog.setArchitecture(ErrorLogHelper.getArchitecture());
        errorLog.setErrorThreadId(thread.getId());
        errorLog.setErrorThreadName(thread.getName());
        errorLog.setFatal(fatal);
        errorLog.setAppLaunchTimestamp(new Date(initializeTimestamp));
        errorLog.setException(exception);
        ArrayList<Thread> threads = new ArrayList<Thread>(allStackTraces.size());
        for (Map.Entry entry : allStackTraces.entrySet()) {
            Thread javaThread = new Thread();
            javaThread.setId(((java.lang.Thread)entry.getKey()).getId());
            javaThread.setName(((java.lang.Thread)entry.getKey()).getName());
            javaThread.setFrames(ErrorLogHelper.getModelFramesFromStackTrace((StackTraceElement[])entry.getValue()));
            threads.add(javaThread);
        }
        errorLog.setThreads(threads);
        return errorLog;
    }

    @TargetApi(value=21)
    private static String getArchitecture() {
        if (Build.VERSION.SDK_INT >= 21) {
            return Build.SUPPORTED_ABIS[0];
        }
        return Build.CPU_ABI;
    }

    @NonNull
    public static synchronized File getErrorStorageDirectory() {
        if (sErrorLogDirectory == null) {
            sErrorLogDirectory = new File(Constants.FILES_PATH, ERROR_DIRECTORY);
            FileManager.mkdir((String)sErrorLogDirectory.getAbsolutePath());
        }
        return sErrorLogDirectory;
    }

    @NonNull
    public static synchronized File getNewMinidumpDirectory() {
        File errorStorageDirectory = ErrorLogHelper.getErrorStorageDirectory();
        File minidumpDirectory = new File(errorStorageDirectory.getAbsolutePath(), MINIDUMP_DIRECTORY);
        return new File(minidumpDirectory, NEW_MINIDUMP_DIRECTORY);
    }

    @NonNull
    public static synchronized File getNewMinidumpSubfolder() {
        if (sNewMinidumpDirectory == null) {
            File minidumpDirectory = ErrorLogHelper.getNewMinidumpDirectory();
            sNewMinidumpDirectory = new File(minidumpDirectory, UUID.randomUUID().toString());
            FileManager.mkdir((String)sNewMinidumpDirectory.getPath());
        }
        return sNewMinidumpDirectory;
    }

    @NonNull
    public static synchronized File getNewMinidumpSubfolderWithContextData(Context context) {
        File directorySubfolder = ErrorLogHelper.getNewMinidumpSubfolder();
        File deviceInfoFile = new File(directorySubfolder, DEVICE_INFO_FILE);
        try {
            Device deviceInfo = DeviceInfoHelper.getDeviceInfo((Context)context);
            String userIdContext = UserIdContext.getInstance().getUserId();
            deviceInfo.setWrapperSdkName("appcenter.ndk");
            JSONStringer writer = new JSONStringer();
            writer.object();
            deviceInfo.write(writer);
            writer.endObject();
            String deviceInfoString = writer.toString();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(DEVICE_INFO_KEY, (Object)deviceInfoString);
            jsonObject.put(USER_ID_KEY, (Object)userIdContext);
            FileManager.write((File)deviceInfoFile, (String)jsonObject.toString());
        }
        catch (DeviceInfoHelper.DeviceInfoException | IOException | JSONException e) {
            AppCenterLog.error((String)"AppCenterCrashes", (String)"Failed to store device info in a minidump folder.", (Throwable)e);
            deviceInfoFile.delete();
        }
        return directorySubfolder;
    }

    @NonNull
    public static synchronized File getPendingMinidumpDirectory() {
        if (sPendingMinidumpDirectory == null) {
            File errorStorageDirectory = ErrorLogHelper.getErrorStorageDirectory();
            File minidumpDirectory = new File(errorStorageDirectory.getAbsolutePath(), MINIDUMP_DIRECTORY);
            sPendingMinidumpDirectory = new File(minidumpDirectory, PENDING_MINIDUMP_DIRECTORY);
            FileManager.mkdir((String)sPendingMinidumpDirectory.getPath());
        }
        return sPendingMinidumpDirectory;
    }

    @NonNull
    public static File[] getStoredErrorLogFiles() {
        File[] files = ErrorLogHelper.getErrorStorageDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(ErrorLogHelper.ERROR_LOG_FILE_EXTENSION);
            }
        });
        return files != null ? files : new File[]{};
    }

    @NonNull
    public static File[] getNewMinidumpFiles() {
        File[] files = ErrorLogHelper.getNewMinidumpDirectory().listFiles();
        return files != null ? files : new File[]{};
    }

    @Nullable
    public static Device getStoredDeviceInfo(File logFolder) {
        String deviceInfoString = ErrorLogHelper.getContextInformation(logFolder);
        if (deviceInfoString == null) {
            return null;
        }
        return ErrorLogHelper.parseDevice(deviceInfoString);
    }

    public static String getStoredUserInfo(File logFolder) {
        String userInformationString = ErrorLogHelper.getContextInformation(logFolder);
        if (userInformationString == null) {
            return null;
        }
        return ErrorLogHelper.parseUserId(userInformationString);
    }

    static String getContextInformation(File logFolder) {
        File[] files = logFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.equals(ErrorLogHelper.DEVICE_INFO_FILE);
            }
        });
        if (files == null || files.length == 0) {
            AppCenterLog.warn((String)"AppCenterCrashes", (String)"No stored deviceinfo file found in a minidump folder.");
            return null;
        }
        File deviceInfoFile = files[0];
        String contextInfoString = FileManager.read((File)deviceInfoFile);
        if (contextInfoString == null) {
            AppCenterLog.error((String)"AppCenterCrashes", (String)"Failed to read stored device info.");
            return null;
        }
        return contextInfoString;
    }

    @VisibleForTesting
    static String parseUserId(String contextInformation) {
        try {
            JSONObject jsonObject = new JSONObject(contextInformation);
            if (jsonObject.has(USER_ID_KEY)) {
                return jsonObject.getString(USER_ID_KEY);
            }
        }
        catch (JSONException e) {
            AppCenterLog.error((String)"AppCenterCrashes", (String)"Failed to deserialize user info.", (Throwable)e);
        }
        return null;
    }

    @VisibleForTesting
    static Device parseDevice(String contextInformation) {
        try {
            Device device = new Device();
            JSONObject jsonObject = new JSONObject(contextInformation);
            JSONObject deviceJson = jsonObject.has(DEVICE_INFO_KEY) ? new JSONObject(jsonObject.getString(DEVICE_INFO_KEY)) : jsonObject;
            device.read(deviceJson);
            return device;
        }
        catch (JSONException e) {
            AppCenterLog.error((String)"AppCenterCrashes", (String)"Failed to deserialize device info.", (Throwable)e);
            return null;
        }
    }

    public static void removeStaleMinidumpSubfolders() {
        File[] previousSubFolders = ErrorLogHelper.getNewMinidumpDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (sNewMinidumpDirectory != null) {
                    return !name.equals(sNewMinidumpDirectory.getName());
                }
                return true;
            }
        });
        if (previousSubFolders == null || previousSubFolders.length == 0) {
            AppCenterLog.debug((String)"AppCenterCrashes", (String)"No previous minidump sub-folders.");
            return;
        }
        for (File file : previousSubFolders) {
            FileManager.deleteDirectory((File)file);
        }
    }

    public static void removeMinidumpFolder() {
        File errorStorageDirectory = ErrorLogHelper.getErrorStorageDirectory();
        File minidumpDirectory = new File(errorStorageDirectory.getAbsolutePath(), MINIDUMP_DIRECTORY);
        FileManager.deleteDirectory((File)minidumpDirectory);
    }

    @Nullable
    public static File getLastErrorLogFile() {
        return FileManager.lastModifiedFile((File)ErrorLogHelper.getErrorStorageDirectory(), (FilenameFilter)new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(ErrorLogHelper.ERROR_LOG_FILE_EXTENSION);
            }
        });
    }

    @Nullable
    public static File getStoredThrowableFile(@NonNull UUID id) {
        return ErrorLogHelper.getStoredFile(id, THROWABLE_FILE_EXTENSION);
    }

    public static void removeStoredThrowableFile(@NonNull UUID id) {
        File file = ErrorLogHelper.getStoredThrowableFile(id);
        if (file != null) {
            AppCenterLog.info((String)"AppCenterCrashes", (String)("Deleting throwable file " + file.getName()));
            FileManager.delete((File)file);
        }
    }

    @Nullable
    static File getStoredErrorLogFile(@NonNull UUID id) {
        return ErrorLogHelper.getStoredFile(id, ERROR_LOG_FILE_EXTENSION);
    }

    public static void removeStoredErrorLogFile(@NonNull UUID id) {
        File file = ErrorLogHelper.getStoredErrorLogFile(id);
        if (file != null) {
            AppCenterLog.info((String)"AppCenterCrashes", (String)("Deleting error log file " + file.getName()));
            FileManager.delete((File)file);
        }
    }

    public static void removeLostThrowableFiles() {
        File[] throwableFiles = ErrorLogHelper.getErrorStorageDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(ErrorLogHelper.THROWABLE_FILE_EXTENSION);
            }
        });
        if (throwableFiles != null && throwableFiles.length > 0) {
            for (File file : throwableFiles) {
                ErrorLogHelper.removeStoredThrowableFile(UUID.fromString(file.getName().replaceFirst("\\.[^.]+$", "")));
            }
        }
    }

    @NonNull
    public static ErrorReport getErrorReportFromErrorLog(@NonNull ManagedErrorLog log, String stackTrace) {
        ErrorReport report = new ErrorReport();
        report.setId(log.getId().toString());
        report.setThreadName(log.getErrorThreadName());
        report.setStackTrace(stackTrace);
        report.setAppStartTime(log.getAppLaunchTimestamp());
        report.setAppErrorTime(log.getTimestamp());
        report.setDevice(log.getDevice());
        return report;
    }

    public static void setErrorLogDirectory(File file) {
        sErrorLogDirectory = file;
    }

    @Nullable
    private static File getStoredFile(final @NonNull UUID id, final @NonNull String extension) {
        File[] files = ErrorLogHelper.getErrorStorageDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.startsWith(id.toString()) && filename.endsWith(extension);
            }
        });
        return files != null && files.length > 0 ? files[0] : null;
    }

    @NonNull
    public static Exception getModelExceptionFromThrowable(@NonNull Throwable t) {
        Exception topException = null;
        Exception parentException = null;
        LinkedList<Throwable> causeChain = new LinkedList<Throwable>();
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            causeChain.add(cause);
        }
        if (causeChain.size() > 16) {
            AppCenterLog.warn((String)"AppCenterCrashes", (String)("Crash causes truncated from " + causeChain.size() + " to " + 16 + " causes."));
            causeChain.subList(8, causeChain.size() - 8).clear();
        }
        for (Throwable cause : causeChain) {
            Exception exception = new Exception();
            exception.setType(cause.getClass().getName());
            exception.setMessage(cause.getMessage());
            exception.setFrames(ErrorLogHelper.getModelFramesFromStackTrace(cause));
            if (topException == null) {
                topException = exception;
            } else {
                parentException.setInnerExceptions(Collections.singletonList(exception));
            }
            parentException = exception;
        }
        return topException;
    }

    @NonNull
    private static List<StackFrame> getModelFramesFromStackTrace(@NonNull Throwable throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace.length > 256) {
            StackTraceElement[] stackTraceTruncated = new StackTraceElement[256];
            System.arraycopy(stackTrace, 0, stackTraceTruncated, 0, 128);
            System.arraycopy(stackTrace, stackTrace.length - 128, stackTraceTruncated, 128, 128);
            throwable.setStackTrace(stackTraceTruncated);
            AppCenterLog.warn((String)"AppCenterCrashes", (String)("Crash frames truncated from " + stackTrace.length + " to " + stackTraceTruncated.length + " frames."));
            stackTrace = stackTraceTruncated;
        }
        return ErrorLogHelper.getModelFramesFromStackTrace(stackTrace);
    }

    @NonNull
    private static List<StackFrame> getModelFramesFromStackTrace(@NonNull StackTraceElement[] stackTrace) {
        ArrayList<StackFrame> stackFrames = new ArrayList<StackFrame>();
        for (StackTraceElement stackTraceElement : stackTrace) {
            stackFrames.add(ErrorLogHelper.getModelStackFrame(stackTraceElement));
        }
        return stackFrames;
    }

    @NonNull
    private static StackFrame getModelStackFrame(StackTraceElement stackTraceElement) {
        StackFrame stackFrame = new StackFrame();
        stackFrame.setClassName(stackTraceElement.getClassName());
        stackFrame.setMethodName(stackTraceElement.getMethodName());
        stackFrame.setLineNumber(stackTraceElement.getLineNumber());
        stackFrame.setFileName(stackTraceElement.getFileName());
        return stackFrame;
    }

    public static Map<String, String> validateProperties(Map<String, String> properties, String logType) {
        if (properties == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String message;
            String key = property.getKey();
            String value = property.getValue();
            if (result.size() >= 20) {
                message = String.format("%s : properties cannot contain more than %s items. Skipping other properties.", logType, 20);
                AppCenterLog.warn((String)"AppCenterCrashes", (String)message);
                break;
            }
            if (key == null || key.isEmpty()) {
                message = String.format("%s : a property key cannot be null or empty. Property will be skipped.", logType);
                AppCenterLog.warn((String)"AppCenterCrashes", (String)message);
                continue;
            }
            if (value == null) {
                message = String.format("%s : property '%s' : property value cannot be null. Property '%s' will be skipped.", logType, key, key);
                AppCenterLog.warn((String)"AppCenterCrashes", (String)message);
                continue;
            }
            if (key.length() > 125) {
                message = String.format("%s : property '%s' : property key length cannot be longer than %s characters. Property key will be truncated.", logType, key, 125);
                AppCenterLog.warn((String)"AppCenterCrashes", (String)message);
                key = key.substring(0, 125);
            }
            if (value.length() > 125) {
                message = String.format("%s : property '%s' : property value cannot be longer than %s characters. Property value will be truncated.", logType, key, 125);
                AppCenterLog.warn((String)"AppCenterCrashes", (String)message);
                value = value.substring(0, 125);
            }
            result.put(key, value);
        }
        return result;
    }

    public static void cleanPendingMinidumps() {
        FileManager.cleanDirectory((File)ErrorLogHelper.getPendingMinidumpDirectory());
    }

    @NonNull
    public static UUID parseLogFolderUuid(File logFolder) {
        UUID uuid = null;
        if (logFolder.isDirectory()) {
            try {
                uuid = UUID.fromString(logFolder.getName());
            }
            catch (IllegalArgumentException e) {
                AppCenterLog.warn((String)"AppCenterCrashes", (String)"Cannot parse minidump folder name to UUID.", (Throwable)e);
            }
        }
        return uuid == null ? UUID.randomUUID() : uuid;
    }

    @VisibleForTesting
    public static void clearStaticState() {
        sNewMinidumpDirectory = null;
        sErrorLogDirectory = null;
        sPendingMinidumpDirectory = null;
    }

    static {
        DEVICE_INFO_KEY = "DEVICE_INFO";
        USER_ID_KEY = "USER_ID";
    }
}

