/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.HttpHelper;
import com.microsoft.aad.adal4j.StringHelper;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AdalOAuthRequest
extends HTTPRequest {
    private final Map<String, String> extraHeaderParams;
    private final Logger log = LoggerFactory.getLogger(AdalOAuthRequest.class);
    private final Logger piiLog = LoggerFactory.getLogger((String)("adal4jPii." + ((Object)((Object)this)).getClass()));
    private final Proxy proxy;
    private final SSLSocketFactory sslSocketFactory;

    AdalOAuthRequest(HTTPRequest.Method method, URL url, Map<String, String> extraHeaderParams, Proxy proxy, SSLSocketFactory sslSocketFactory) {
        super(method, url);
        this.extraHeaderParams = extraHeaderParams;
        this.proxy = proxy;
        this.sslSocketFactory = sslSocketFactory;
    }

    Map<String, String> getReadOnlyExtraHeaderParameters() {
        return Collections.unmodifiableMap(this.extraHeaderParams);
    }

    public HTTPResponse send() throws IOException {
        HttpsURLConnection conn = HttpHelper.openConnection(this.getURL(), this.proxy, this.sslSocketFactory);
        this.configureHeaderAndExecuteOAuthCall(conn);
        String out = this.processAndReadResponse(conn);
        HttpHelper.verifyReturnedCorrelationId(this.log, this.piiLog, conn, this.extraHeaderParams.get("client-request-id"));
        return this.createResponse(conn, out);
    }

    HTTPResponse createResponse(HttpURLConnection conn, String out) throws IOException {
        HTTPResponse response = new HTTPResponse(conn.getResponseCode());
        String location = conn.getHeaderField("Location");
        if (!StringHelper.isBlank(location)) {
            try {
                response.setLocation(new URI(location));
            }
            catch (URISyntaxException e) {
                throw new IOException("Invalid location URI " + location, e);
            }
        }
        try {
            response.setContentType(conn.getContentType());
        }
        catch (ParseException e) {
            throw new IOException("Couldn't parse Content-Type header: " + e.getMessage(), e);
        }
        response.setCacheControl(conn.getHeaderField("Cache-Control"));
        response.setPragma(conn.getHeaderField("Pragma"));
        response.setWWWAuthenticate(conn.getHeaderField("WWW-Authenticate"));
        if (!StringHelper.isBlank(out)) {
            response.setContent(out);
        }
        return response;
    }

    void configureHeaderAndExecuteOAuthCall(HttpsURLConnection conn) throws IOException {
        if (this.getAuthorization() != null) {
            conn.setRequestProperty("Authorization", this.getAuthorization());
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.extraHeaderParams != null && !this.extraHeaderParams.isEmpty()) {
            for (Map.Entry<String, String> entry : this.extraHeaderParams.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                params.put(entry.getKey(), entry.getValue());
            }
        }
        HttpHelper.configureAdditionalHeaders(conn, params);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", CommonContentTypes.APPLICATION_URLENCODED.toString());
        if (this.getQuery() != null) {
            try (OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());){
                writer.write(this.getQuery());
                writer.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String processAndReadResponse(HttpURLConnection conn) throws IOException {
        InputStreamReader inReader = null;
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            inReader = new InputStreamReader(conn.getInputStream());
        } else {
            InputStream stream = conn.getErrorStream();
            if (stream == null && responseCode == 404) {
                stream = conn.getInputStream();
            }
            if (stream == null) {
                stream = conn.getInputStream();
            }
            inReader = new InputStreamReader(stream);
        }
        BufferedReader reader = new BufferedReader(inReader);
        char[] buffer = new char[256];
        StringBuilder out = new StringBuilder();
        try {
            int rsz;
            while ((rsz = reader.read(buffer, 0, buffer.length)) >= 0) {
                out.append(buffer, 0, rsz);
            }
        }
        finally {
            reader.close();
        }
        return out.toString();
    }
}

