/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal.config.builder;

import com.microsoft.applicationinsights.agent.internal.config.BuiltInInstrumentation;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;

public class BuiltInInstrumentationBuilder {
    private static final Logger logger = LoggerFactory.getLogger(BuiltInInstrumentationBuilder.class);
    private boolean enabled;
    private boolean httpEnabled;
    private boolean w3cEnabled = true;
    private boolean w3cBackCompatEnabled = true;
    private boolean jdbcEnabled;
    private boolean loggingEnabled;
    private String loggingThreshold;
    private boolean jedisEnabled;
    private long queryPlanThresholdInMS = 10000L;

    public BuiltInInstrumentation create() {
        logger.trace("Outbound W3C tracing is enabled: {}", (Object)this.w3cEnabled);
        logger.trace("Outbound W3C backport mode is enabled: {}", (Object)this.w3cBackCompatEnabled);
        return new BuiltInInstrumentation(this.enabled, this.httpEnabled && this.enabled, this.w3cEnabled && this.enabled, this.w3cBackCompatEnabled && this.enabled, this.jdbcEnabled && this.enabled, this.loggingEnabled && this.enabled, this.loggingThreshold, this.jedisEnabled && this.enabled, this.queryPlanThresholdInMS);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setHttpEnabled(boolean httpEnabled, boolean w3cEnabled, boolean w3cBackCompatEnabled) {
        this.httpEnabled = httpEnabled;
        this.w3cEnabled = w3cEnabled;
        this.w3cBackCompatEnabled = w3cBackCompatEnabled;
    }

    public void setJdbcEnabled(boolean jdbcEnabled) {
        this.jdbcEnabled = jdbcEnabled;
    }

    public void setLoggingEnabled(boolean loggingEnabled, String loggingThreshold) {
        this.loggingEnabled = loggingEnabled;
        this.loggingThreshold = loggingThreshold;
    }

    public void setJedisEnabled(boolean jedisEnabled) {
        this.jedisEnabled = jedisEnabled;
    }

    public void setQueryPlanThresholdInMS(Long queryPlanThresholdInMS) {
        this.queryPlanThresholdInMS = queryPlanThresholdInMS == null ? 10000L : queryPlanThresholdInMS;
    }
}

