/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal.model;

import com.microsoft.applicationinsights.agent.internal.sdk.SdkBridge;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.annotations.VisibleForTesting;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import org.glowroot.instrumentation.api.Getter;
import org.glowroot.instrumentation.api.MessageSupplier;
import org.glowroot.instrumentation.api.Setter;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.engine.impl.NopTransactionService;

public class LocalSpanImpl
implements Span {
    static final String PREFIX = "__custom,";
    private static final Logger logger = LoggerFactory.getLogger(LocalSpanImpl.class);
    private final SdkBridge sdkBridge;
    private final String text;
    private final long startTimeMillis;
    private final MessageSupplier messageSupplier;
    @MonotonicNonNull
    private volatile Throwable exception;

    LocalSpanImpl(SdkBridge sdkBridge, String text, long startTimeMillis, MessageSupplier messageSupplier) {
        this.sdkBridge = sdkBridge;
        this.text = text;
        this.startTimeMillis = startTimeMillis;
        this.messageSupplier = messageSupplier;
    }

    @Override
    public void end() {
        this.endInternal();
    }

    @Override
    public void endWithLocationStackTrace(long thresholdNanos) {
        this.endInternal();
    }

    @Override
    public void endWithError(Throwable t) {
        this.exception = t;
        this.endInternal();
    }

    @Override
    public Timer extend() {
        return NopTransactionService.TIMER;
    }

    @Override
    public Object getMessageSupplier() {
        return this.messageSupplier;
    }

    @Override
    @Deprecated
    public <R> void propagateToResponse(R response, Setter<R> setter) {
    }

    @Override
    @Deprecated
    public <R> void extractFromResponse(R response, Getter<R> getter) {
    }

    private void endInternal() {
        SdkBridge.RemoteDependencyTelemetry telemetry = LocalSpanImpl.createRemoteDependencyTelemetry(this.text, this.startTimeMillis, this.exception);
        if (telemetry == null) {
            return;
        }
        this.sdkBridge.track(telemetry);
        if (this.exception != null) {
            this.sdkBridge.track(new SdkBridge.ExceptionTelemetry(this.exception));
        }
    }

    @VisibleForTesting
    @Nullable
    static SdkBridge.RemoteDependencyTelemetry createRemoteDependencyTelemetry(String text, long startTimeMillis, @Nullable Throwable exception) {
        long thresholdInMS;
        int startIndex = PREFIX.length();
        int index = text.indexOf(44, startIndex);
        if (index == -1) {
            logger.warn("unexpected local span message: {}", (Object)text);
            return null;
        }
        String className = text.substring(startIndex, index);
        startIndex = index + 1;
        if ((index = text.indexOf(44, startIndex)) == -1) {
            logger.warn("unexpected local span message: {}", (Object)text);
            return null;
        }
        String methodName = text.substring(startIndex, index);
        startIndex = index + 1;
        if ((index = text.indexOf(44, startIndex)) == -1) {
            logger.warn("unexpected local span message: {}", (Object)text);
            return null;
        }
        try {
            thresholdInMS = Long.parseLong(text.substring(startIndex, index));
        }
        catch (NumberFormatException e) {
            logger.error("unexpected local span message: {}", (Object)text);
            return null;
        }
        String classType = text.substring(index + 1);
        long durationMillis = System.currentTimeMillis() - startTimeMillis;
        if (durationMillis < thresholdInMS) {
            return null;
        }
        SdkBridge.RemoteDependencyTelemetry telemetry = new SdkBridge.RemoteDependencyTelemetry(startTimeMillis, durationMillis, classType, exception == null);
        telemetry.setName(className.replace('.', '/') + '.' + methodName);
        return telemetry;
    }
}

