/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal.model;

import com.microsoft.applicationinsights.agent.internal.sdk.SdkBridge;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.glowroot.instrumentation.api.MessageSupplier;
import org.glowroot.instrumentation.api.internal.ReadableMessage;

class LoggerSpans {
    LoggerSpans() {
    }

    static void track(SdkBridge sdkBridge, MessageSupplier messageSupplier, @Nullable Throwable throwable, long timeMillis) {
        ReadableMessage message = (ReadableMessage)((Object)messageSupplier.get());
        String formattedMessage = message.getText();
        Map<String, ?> detail = message.getDetail();
        String level = (String)detail.get("Level");
        String loggerName = (String)detail.get("Logger name");
        if (throwable == null) {
            SdkBridge.TraceTelemetry telemetry = new SdkBridge.TraceTelemetry(formattedMessage, level);
            LoggerSpans.setProperties(telemetry.getProperties(), timeMillis, level, loggerName, null, formattedMessage);
            sdkBridge.track(telemetry);
        } else {
            SdkBridge.ExceptionTelemetry telemetry = new SdkBridge.ExceptionTelemetry(throwable, level);
            LoggerSpans.setProperties(telemetry.getProperties(), timeMillis, level, loggerName, throwable, formattedMessage);
            sdkBridge.track(telemetry);
        }
    }

    private static void setProperties(Map<String, String> properties, long timeMillis, String level, String loggerName, @Nullable Throwable throwable, String formattedMessage) {
        properties.put("SourceType", "Logger");
        properties.put("TimeStamp", LoggerSpans.getFormattedDate(timeMillis));
        if (level != null) {
            properties.put("LoggingLevel", level);
        }
        if (loggerName != null) {
            properties.put("LoggerName", loggerName);
        }
        if (throwable != null) {
            properties.put("Logger Message", formattedMessage);
        }
    }

    private static String getFormattedDate(long dateInMilliseconds) {
        return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US).format(new Date(dateInMilliseconds));
    }
}

