/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal.model;

import com.microsoft.applicationinsights.agent.internal.model.Global;
import com.microsoft.applicationinsights.agent.internal.sdk.SdkBridge;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Strings;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.glowroot.instrumentation.api.Getter;
import org.glowroot.instrumentation.api.MessageSupplier;
import org.glowroot.instrumentation.api.Setter;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.api.internal.ReadableMessage;
import org.glowroot.instrumentation.engine.impl.NopTransactionService;

public class OutgoingSpanImpl
implements Span {
    private static final Logger logger = LoggerFactory.getLogger(OutgoingSpanImpl.class);
    private final SdkBridge sdkBridge;
    private final String type;
    private final String text;
    private final long startTimeMillis;
    private final String outgoingSpanId;
    private final MessageSupplier messageSupplier;
    @MonotonicNonNull
    private volatile String requestContext;
    @MonotonicNonNull
    private volatile Throwable exception;

    public OutgoingSpanImpl(SdkBridge sdkBridge, String type, String text, long startTimeMillis, String outgoingSpanId, MessageSupplier messageSupplier) {
        this.sdkBridge = sdkBridge;
        this.type = type;
        this.text = text;
        this.startTimeMillis = startTimeMillis;
        this.outgoingSpanId = outgoingSpanId;
        this.messageSupplier = messageSupplier;
    }

    @Override
    public void end() {
        this.endInternal();
    }

    @Override
    public void endWithLocationStackTrace(long thresholdNanos) {
        this.endInternal();
    }

    @Override
    public void endWithError(Throwable t) {
        this.exception = t;
        this.endInternal();
    }

    @Override
    public Timer extend() {
        return NopTransactionService.TIMER;
    }

    @Override
    public Object getMessageSupplier() {
        return this.messageSupplier;
    }

    @Override
    @Deprecated
    public <R> void propagateToResponse(R response, Setter<R> setter) {
    }

    @Override
    @Deprecated
    public <R> void extractFromResponse(R response, Getter<R> getter) {
        this.requestContext = getter.get(response, "Request-Context");
    }

    private void endInternal() {
        SdkBridge.RemoteDependencyTelemetry telemetry = null;
        if (this.type.equals("HTTP")) {
            telemetry = this.toHttpTelemetry();
        } else if (this.type.equals("Redis")) {
            telemetry = new SdkBridge.RemoteDependencyTelemetry(this.startTimeMillis, System.currentTimeMillis() - this.startTimeMillis, this.type, this.exception == null);
            telemetry.setName(this.text);
        }
        if (telemetry != null) {
            this.sdkBridge.track(telemetry);
            if (this.exception != null) {
                this.sdkBridge.track(new SdkBridge.ExceptionTelemetry(this.exception));
            }
        }
    }

    @Nullable
    private SdkBridge.RemoteDependencyTelemetry toHttpTelemetry() {
        ReadableMessage message = (ReadableMessage)((Object)this.messageSupplier.get());
        Map<String, ?> detail = message.getDetail();
        String uri = (String)detail.get("URI");
        if (uri != null && (uri.startsWith("https://dc.services.visualstudio.com") || uri.startsWith("https://rt.services.visualstudio.com"))) {
            return null;
        }
        String method = (String)detail.get("Method");
        Integer result = (Integer)detail.get("Result");
        SdkBridge.RemoteDependencyTelemetry telemetry = new SdkBridge.RemoteDependencyTelemetry(this.startTimeMillis, System.currentTimeMillis() - this.startTimeMillis, "Http (tracked component)", result == null || result < 400);
        telemetry.setId(this.outgoingSpanId);
        if (method != null) {
            telemetry.getProperties().put("Method", method);
        }
        if (uri != null) {
            String host = (String)detail.get("Host");
            if (host != null) {
                uri = host + uri;
            }
            try {
                String incomingTarget;
                URI uriObject = new URI(uri);
                String target = OutgoingSpanImpl.createTarget(uriObject);
                if (this.requestContext != null && (incomingTarget = this.sdkBridge.generateChildDependencyTarget(this.requestContext, Global.isOutboundW3CEnabled())) != null && !incomingTarget.isEmpty()) {
                    target = target + " | " + incomingTarget;
                }
                telemetry.setTarget(target);
                String path = uriObject.getPath();
                if (Strings.isNullOrEmpty(path)) {
                    telemetry.setName(method + " /");
                } else {
                    telemetry.setName(method + " " + path);
                }
            }
            catch (URISyntaxException e) {
                logger.error(e.getMessage());
                logger.debug(e.getMessage(), e);
            }
            telemetry.setCommandName(uri);
            telemetry.getProperties().put("URI", uri);
        }
        if (result != null) {
            telemetry.setResultCode(Integer.toString(result));
        }
        return telemetry;
    }

    private static String createTarget(URI uriObject) {
        String target = uriObject.getHost();
        if (uriObject.getPort() != 80 && uriObject.getPort() != 443 && uriObject.getPort() != -1) {
            target = target + ":" + uriObject.getPort();
        }
        return target;
    }
}

