/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.agent.internal.sdk;

import com.microsoft.applicationinsights.agent.internal.model.Global;
import com.microsoft.applicationinsights.agent.internal.model.ThreadContextImpl;
import com.microsoft.applicationinsights.agent.internal.sdk.BindingResult;
import com.microsoft.applicationinsights.agent.internal.sdk.SdkBinding;
import com.microsoft.applicationinsights.agent.internal.sdk.SdkBridge;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.engine.bytecode.api.ThreadContextPlus;
import org.glowroot.instrumentation.engine.bytecode.api.ThreadContextThreadLocal;

public class AgentBridgeInternal {
    private static final BindingResult NOP_BINDING_RESULT = new NopBindingResult();

    private AgentBridgeInternal() {
    }

    public static <T> BindingResult bindToThread(SdkBridge<T> sdkBridge, T requestTelemetryContext, @Nullable ThreadContext.ServletRequestInfo servletRequestInfo) {
        ThreadContextThreadLocal.Holder threadContextHolder = Global.getThreadContextHolder();
        ThreadContextPlus threadContext = threadContextHolder.get();
        if (threadContext == null) {
            SdkBinding<T> sdkBinding = new SdkBinding<T>(sdkBridge, requestTelemetryContext);
            threadContextHolder.set(new ThreadContextImpl<T>(sdkBinding, servletRequestInfo, 0, 0));
            return sdkBinding;
        }
        return NOP_BINDING_RESULT;
    }

    private static class NopBindingResult
    implements BindingResult {
        private NopBindingResult() {
        }

        @Override
        public void unbindFromMainThread() {
        }

        @Override
        public void unbindFromRunawayChildThreads() {
        }
    }
}

