/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.apachehttpclient.boot;

import org.glowroot.instrumentation.apachehttpclient.boot.HttpRequestMessageSupplier;
import org.glowroot.instrumentation.api.Setter;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;

public class Util {
    private Util() {
    }

    public static <C> Span startOutgoingSpan(ThreadContext context, @Nullable String httpMethod, @Nullable String host, @Nullable String uri, Setter<C> setter, C carrier, TimerName timerName) {
        int maxLength = 0;
        if (httpMethod != null) {
            maxLength += httpMethod.length();
        }
        if (host != null) {
            maxLength += host.length() + 1;
        }
        if (uri != null) {
            maxLength += uri.length() + 1;
        }
        StringBuilder sb = new StringBuilder(maxLength);
        if (httpMethod != null) {
            sb.append(httpMethod);
        }
        if (host != null) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(host);
        }
        if (uri != null) {
            if (sb.length() != 0 && host == null) {
                sb.append(' ');
            }
            sb.append(Util.stripQueryString(uri));
        }
        HttpRequestMessageSupplier messageSupplier = new HttpRequestMessageSupplier(httpMethod, host, uri);
        return context.startOutgoingSpan("HTTP", sb.toString(), setter, carrier, messageSupplier, timerName);
    }

    private static String stripQueryString(String uri) {
        int index = uri.indexOf(63);
        return index == -1 ? uri : uri.substring(0, index);
    }
}

