/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.api;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.glowroot.instrumentation.api.OptionalThreadContext;
import org.glowroot.instrumentation.api.weaving.Advice;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Descriptor {
    public String id();

    public String name();

    public Property[] properties() default {};

    public Advice[] advice() default {};

    public Class<?>[] classes() default {};

    public boolean collocate() default false;

    public static enum CaptureKind {
        TRANSACTION,
        LOCAL_SPAN,
        TIMER,
        OTHER;

    }

    public static enum PropertyType {
        STRING,
        BOOLEAN,
        DOUBLE,
        LIST;

    }

    @Target(value={ElementType.ANNOTATION_TYPE})
    public static @interface DefaultValue {
        public String stringValue() default "";

        public boolean booleanValue() default false;

        public boolean nonNullDoubleValue() default false;

        public double doubleValue() default 0.0;

        public String[] listValue() default {};
    }

    @Target(value={ElementType.ANNOTATION_TYPE})
    public static @interface Advice {
        public String className() default "";

        public String classAnnotation() default "";

        public String subTypeRestriction() default "";

        public String superTypeRestriction() default "";

        public String methodName() default "";

        public String methodAnnotation() default "";

        public String[] methodParameterTypes();

        public String methodReturnType() default "";

        public Advice.MethodModifier[] methodModifiers() default {};

        public String nestingGroup() default "";

        public int order() default 0;

        public CaptureKind captureKind();

        public String transactionType() default "";

        public String transactionNameTemplate() default "";

        public String transactionUserTemplate() default "";

        public int transactionSlowThresholdMillis() default -1;

        public OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehavior() default OptionalThreadContext.AlreadyInTransactionBehavior.CAPTURE_LOCAL_SPAN;

        public String spanMessageTemplate() default "";

        public int spanStackThresholdMillis() default -1;

        public boolean spanCaptureSelfNested() default false;

        public String timerName() default "";

        public String enabledProperty() default "";

        public String localSpanEnabledProperty() default "";
    }

    @Target(value={ElementType.ANNOTATION_TYPE})
    public static @interface Property {
        public String name();

        public PropertyType type();

        public DefaultValue[] defaultValue() default {};

        public String label();

        public String checkboxLabel() default "";

        public String description() default "";
    }
}

