/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.bytecode.api;

import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.instrumentation.engine.bytecode.api.BytecodeService;

public class BytecodeServiceHolder {
    @Nullable
    private static volatile BytecodeService service;
    private static volatile boolean engineFailedToStart;

    private BytecodeServiceHolder() {
    }

    public static BytecodeService get() {
        if (service == null) {
            ClassLoader loader = BytecodeServiceHolder.class.getClassLoader();
            if (loader == null) {
                throw new RuntimeException("Bytecode service retrieved too early");
            }
            throw new RuntimeException("Bytecode service retrieved from class loader: " + loader);
        }
        return service;
    }

    public static void set(BytecodeService service) {
        BytecodeServiceHolder.service = service;
    }

    public static void setEngineFailedToStart() {
        engineFailedToStart = true;
    }

    static boolean isEngineFailedToStart() {
        return engineFailedToStart;
    }
}

