/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.bytecode.api;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;

public class Util {
    private Util() {
    }

    public static Set<Type> stripMixinInterfaces(Set<Type> decoratedTypes) {
        boolean found = false;
        for (Type decoratedType : decoratedTypes) {
            if (!Util.isMixinInterface(decoratedType)) continue;
            found = true;
        }
        if (!found) {
            return decoratedTypes;
        }
        LinkedHashSet<Type> stripped = new LinkedHashSet<Type>();
        for (Type decoratedType : decoratedTypes) {
            if (Util.isMixinInterface(decoratedType)) continue;
            stripped.add(decoratedType);
        }
        return stripped;
    }

    private static boolean isMixinInterface(Type decoratedType) {
        return decoratedType instanceof Class && ((Class)decoratedType).getName().startsWith("org.glowroot.instrumentation.");
    }

    public static Class<?> getArrayClass(Class<?> type, int nDimensions) {
        if (nDimensions == 0) {
            return type;
        }
        return Util.getArrayClass(Array.newInstance(type, 0).getClass(), nDimensions - 1);
    }
}

