/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.config;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Joiner;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Map;
import org.glowroot.instrumentation.api.Descriptor;
import org.glowroot.instrumentation.api.OptionalThreadContext;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.immutables.value.Value;

@Value.Immutable
public abstract class AdviceConfig {
    private static final Logger logger = LoggerFactory.getLogger(AdviceConfig.class);

    @Value.Default
    public String className() {
        return "";
    }

    @Value.Default
    public String classAnnotation() {
        return "";
    }

    @Value.Default
    public String subTypeRestriction() {
        return "";
    }

    @Value.Default
    public String superTypeRestriction() {
        return "";
    }

    @Deprecated
    @Value.Default
    public String methodDeclaringClassName() {
        return "";
    }

    @Value.Default
    public String methodName() {
        return "";
    }

    @Value.Default
    public String methodAnnotation() {
        return "";
    }

    public abstract ImmutableList<String> methodParameterTypes();

    @Value.Default
    public String methodReturnType() {
        return "";
    }

    public abstract ImmutableList<Advice.MethodModifier> methodModifiers();

    @Value.Default
    public String nestingGroup() {
        return "";
    }

    @Value.Default
    public int order() {
        return 0;
    }

    public abstract Descriptor.CaptureKind captureKind();

    @Value.Default
    public String transactionType() {
        return "";
    }

    @Value.Default
    public String transactionNameTemplate() {
        return "";
    }

    @Value.Default
    public String transactionUserTemplate() {
        return "";
    }

    public abstract Map<String, String> transactionAttributeTemplates();

    @Nullable
    public abstract Integer transactionSlowThresholdMillis();

    @Nullable
    public abstract OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehavior();

    @Value.Derived
    @Nullable
    public OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehaviorCorrected() {
        if (this.captureKind() == Descriptor.CaptureKind.TRANSACTION) {
            return MoreObjects.firstNonNull(this.alreadyInTransactionBehavior(), OptionalThreadContext.AlreadyInTransactionBehavior.CAPTURE_LOCAL_SPAN);
        }
        return null;
    }

    @Value.Default
    public String spanMessageTemplate() {
        return "";
    }

    @Nullable
    public abstract Integer spanStackThresholdMillis();

    @Value.Default
    public boolean spanCaptureSelfNested() {
        return false;
    }

    @Value.Default
    public String timerName() {
        return "";
    }

    @Value.Default
    public String enabledProperty() {
        return "";
    }

    @Value.Default
    public String localSpanEnabledProperty() {
        return "";
    }

    @Value.Derived
    public boolean isTimerOrGreater() {
        return this.captureKind() == Descriptor.CaptureKind.TIMER || this.captureKind() == Descriptor.CaptureKind.LOCAL_SPAN || this.captureKind() == Descriptor.CaptureKind.TRANSACTION;
    }

    @Value.Derived
    public boolean isLocalSpanOrGreater() {
        return this.captureKind() == Descriptor.CaptureKind.LOCAL_SPAN || this.captureKind() == Descriptor.CaptureKind.TRANSACTION;
    }

    @Value.Derived
    public boolean isTransaction() {
        return this.captureKind() == Descriptor.CaptureKind.TRANSACTION;
    }

    @Value.Derived
    public ImmutableList<String> validationErrors() {
        ArrayList<String> errors = Lists.newArrayList();
        if (this.className().isEmpty() && this.classAnnotation().isEmpty()) {
            errors.add("className and classAnnotation are both empty");
        }
        if (this.methodName().isEmpty() && this.methodAnnotation().isEmpty()) {
            errors.add("methodName and methodAnnotation are both empty");
        }
        if (this.isTimerOrGreater() && this.timerName().isEmpty()) {
            errors.add("timerName is empty");
        }
        if (this.captureKind() == Descriptor.CaptureKind.LOCAL_SPAN && this.spanMessageTemplate().isEmpty()) {
            errors.add("spanMessageTemplate is empty");
        }
        if (this.isTransaction() && this.transactionType().isEmpty()) {
            errors.add("transactionType is empty");
        }
        if (this.isTransaction() && this.transactionNameTemplate().isEmpty()) {
            errors.add("transactionNameTemplate is empty");
        }
        if (!this.timerName().matches("[a-zA-Z0-9 ]*")) {
            errors.add("timerName contains invalid characters: " + this.timerName());
        }
        if (!this.methodDeclaringClassName().isEmpty()) {
            errors.add("methodDeclaringClassName is no longer supported");
        }
        return ImmutableList.copyOf(errors);
    }

    public void logValidationErrorsIfAny() {
        ImmutableList<String> errors = this.validationErrors();
        if (!errors.isEmpty()) {
            logger.error("invalid instrumentation config: {} - {}", (Object)Joiner.on(", ").join(errors), (Object)this);
        }
    }
}

