/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.config;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Objects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMap;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.primitives.Booleans;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.Map;
import org.glowroot.instrumentation.api.Descriptor;
import org.glowroot.instrumentation.api.OptionalThreadContext;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.engine.config.AdviceConfig;
import org.immutables.value.Generated;

@Generated(from="AdviceConfig", generator="Immutables")
public final class ImmutableAdviceConfig
extends AdviceConfig {
    private final String className;
    private final String classAnnotation;
    private final String subTypeRestriction;
    private final String superTypeRestriction;
    private final String methodDeclaringClassName;
    private final String methodName;
    private final String methodAnnotation;
    private final ImmutableList<String> methodParameterTypes;
    private final String methodReturnType;
    private final ImmutableList<Advice.MethodModifier> methodModifiers;
    private final String nestingGroup;
    private final int order;
    private final Descriptor.CaptureKind captureKind;
    private final String transactionType;
    private final String transactionNameTemplate;
    private final String transactionUserTemplate;
    private final ImmutableMap<String, String> transactionAttributeTemplates;
    @Nullable
    private final Integer transactionSlowThresholdMillis;
    @Nullable
    private final OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehavior;
    @Nullable
    private final transient OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehaviorCorrected;
    private final String spanMessageTemplate;
    @Nullable
    private final Integer spanStackThresholdMillis;
    private final boolean spanCaptureSelfNested;
    private final String timerName;
    private final String enabledProperty;
    private final String localSpanEnabledProperty;
    private final transient boolean isTimerOrGreater;
    private final transient boolean isLocalSpanOrGreater;
    private final transient boolean isTransaction;
    private final transient ImmutableList<String> validationErrors;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAdviceConfig(Builder builder) {
        this.methodParameterTypes = builder.methodParameterTypes.build();
        this.methodModifiers = builder.methodModifiers.build();
        this.captureKind = builder.captureKind;
        this.transactionAttributeTemplates = builder.transactionAttributeTemplates.build();
        this.transactionSlowThresholdMillis = builder.transactionSlowThresholdMillis;
        this.alreadyInTransactionBehavior = builder.alreadyInTransactionBehavior;
        this.spanStackThresholdMillis = builder.spanStackThresholdMillis;
        if (builder.className != null) {
            this.initShim.className(builder.className);
        }
        if (builder.classAnnotation != null) {
            this.initShim.classAnnotation(builder.classAnnotation);
        }
        if (builder.subTypeRestriction != null) {
            this.initShim.subTypeRestriction(builder.subTypeRestriction);
        }
        if (builder.superTypeRestriction != null) {
            this.initShim.superTypeRestriction(builder.superTypeRestriction);
        }
        if (builder.methodDeclaringClassName != null) {
            this.initShim.methodDeclaringClassName(builder.methodDeclaringClassName);
        }
        if (builder.methodName != null) {
            this.initShim.methodName(builder.methodName);
        }
        if (builder.methodAnnotation != null) {
            this.initShim.methodAnnotation(builder.methodAnnotation);
        }
        if (builder.methodReturnType != null) {
            this.initShim.methodReturnType(builder.methodReturnType);
        }
        if (builder.nestingGroup != null) {
            this.initShim.nestingGroup(builder.nestingGroup);
        }
        if (builder.orderIsSet()) {
            this.initShim.order(builder.order);
        }
        if (builder.transactionType != null) {
            this.initShim.transactionType(builder.transactionType);
        }
        if (builder.transactionNameTemplate != null) {
            this.initShim.transactionNameTemplate(builder.transactionNameTemplate);
        }
        if (builder.transactionUserTemplate != null) {
            this.initShim.transactionUserTemplate(builder.transactionUserTemplate);
        }
        if (builder.spanMessageTemplate != null) {
            this.initShim.spanMessageTemplate(builder.spanMessageTemplate);
        }
        if (builder.spanCaptureSelfNestedIsSet()) {
            this.initShim.spanCaptureSelfNested(builder.spanCaptureSelfNested);
        }
        if (builder.timerName != null) {
            this.initShim.timerName(builder.timerName);
        }
        if (builder.enabledProperty != null) {
            this.initShim.enabledProperty(builder.enabledProperty);
        }
        if (builder.localSpanEnabledProperty != null) {
            this.initShim.localSpanEnabledProperty(builder.localSpanEnabledProperty);
        }
        this.className = this.initShim.className();
        this.classAnnotation = this.initShim.classAnnotation();
        this.subTypeRestriction = this.initShim.subTypeRestriction();
        this.superTypeRestriction = this.initShim.superTypeRestriction();
        this.methodDeclaringClassName = this.initShim.methodDeclaringClassName();
        this.methodName = this.initShim.methodName();
        this.methodAnnotation = this.initShim.methodAnnotation();
        this.methodReturnType = this.initShim.methodReturnType();
        this.nestingGroup = this.initShim.nestingGroup();
        this.order = this.initShim.order();
        this.transactionType = this.initShim.transactionType();
        this.transactionNameTemplate = this.initShim.transactionNameTemplate();
        this.transactionUserTemplate = this.initShim.transactionUserTemplate();
        this.alreadyInTransactionBehaviorCorrected = this.initShim.alreadyInTransactionBehaviorCorrected();
        this.spanMessageTemplate = this.initShim.spanMessageTemplate();
        this.spanCaptureSelfNested = this.initShim.spanCaptureSelfNested();
        this.timerName = this.initShim.timerName();
        this.enabledProperty = this.initShim.enabledProperty();
        this.localSpanEnabledProperty = this.initShim.localSpanEnabledProperty();
        this.isTimerOrGreater = this.initShim.isTimerOrGreater();
        this.isLocalSpanOrGreater = this.initShim.isLocalSpanOrGreater();
        this.isTransaction = this.initShim.isTransaction();
        this.validationErrors = this.initShim.validationErrors();
        this.initShim = null;
    }

    private ImmutableAdviceConfig(String className, String classAnnotation, String subTypeRestriction, String superTypeRestriction, String methodDeclaringClassName, String methodName, String methodAnnotation, ImmutableList<String> methodParameterTypes, String methodReturnType, ImmutableList<Advice.MethodModifier> methodModifiers, String nestingGroup, int order, Descriptor.CaptureKind captureKind, String transactionType, String transactionNameTemplate, String transactionUserTemplate, ImmutableMap<String, String> transactionAttributeTemplates, @Nullable Integer transactionSlowThresholdMillis, @Nullable OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehavior, String spanMessageTemplate, @Nullable Integer spanStackThresholdMillis, boolean spanCaptureSelfNested, String timerName, String enabledProperty, String localSpanEnabledProperty) {
        this.initShim.className(className);
        this.initShim.classAnnotation(classAnnotation);
        this.initShim.subTypeRestriction(subTypeRestriction);
        this.initShim.superTypeRestriction(superTypeRestriction);
        this.initShim.methodDeclaringClassName(methodDeclaringClassName);
        this.initShim.methodName(methodName);
        this.initShim.methodAnnotation(methodAnnotation);
        this.methodParameterTypes = methodParameterTypes;
        this.initShim.methodReturnType(methodReturnType);
        this.methodModifiers = methodModifiers;
        this.initShim.nestingGroup(nestingGroup);
        this.initShim.order(order);
        this.captureKind = captureKind;
        this.initShim.transactionType(transactionType);
        this.initShim.transactionNameTemplate(transactionNameTemplate);
        this.initShim.transactionUserTemplate(transactionUserTemplate);
        this.transactionAttributeTemplates = transactionAttributeTemplates;
        this.transactionSlowThresholdMillis = transactionSlowThresholdMillis;
        this.alreadyInTransactionBehavior = alreadyInTransactionBehavior;
        this.initShim.spanMessageTemplate(spanMessageTemplate);
        this.spanStackThresholdMillis = spanStackThresholdMillis;
        this.initShim.spanCaptureSelfNested(spanCaptureSelfNested);
        this.initShim.timerName(timerName);
        this.initShim.enabledProperty(enabledProperty);
        this.initShim.localSpanEnabledProperty(localSpanEnabledProperty);
        this.className = this.initShim.className();
        this.classAnnotation = this.initShim.classAnnotation();
        this.subTypeRestriction = this.initShim.subTypeRestriction();
        this.superTypeRestriction = this.initShim.superTypeRestriction();
        this.methodDeclaringClassName = this.initShim.methodDeclaringClassName();
        this.methodName = this.initShim.methodName();
        this.methodAnnotation = this.initShim.methodAnnotation();
        this.methodReturnType = this.initShim.methodReturnType();
        this.nestingGroup = this.initShim.nestingGroup();
        this.order = this.initShim.order();
        this.transactionType = this.initShim.transactionType();
        this.transactionNameTemplate = this.initShim.transactionNameTemplate();
        this.transactionUserTemplate = this.initShim.transactionUserTemplate();
        this.alreadyInTransactionBehaviorCorrected = this.initShim.alreadyInTransactionBehaviorCorrected();
        this.spanMessageTemplate = this.initShim.spanMessageTemplate();
        this.spanCaptureSelfNested = this.initShim.spanCaptureSelfNested();
        this.timerName = this.initShim.timerName();
        this.enabledProperty = this.initShim.enabledProperty();
        this.localSpanEnabledProperty = this.initShim.localSpanEnabledProperty();
        this.isTimerOrGreater = this.initShim.isTimerOrGreater();
        this.isLocalSpanOrGreater = this.initShim.isLocalSpanOrGreater();
        this.isTransaction = this.initShim.isTransaction();
        this.validationErrors = this.initShim.validationErrors();
        this.initShim = null;
    }

    @Override
    public String className() {
        InitShim shim = this.initShim;
        return shim != null ? shim.className() : this.className;
    }

    @Override
    public String classAnnotation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.classAnnotation() : this.classAnnotation;
    }

    @Override
    public String subTypeRestriction() {
        InitShim shim = this.initShim;
        return shim != null ? shim.subTypeRestriction() : this.subTypeRestriction;
    }

    @Override
    public String superTypeRestriction() {
        InitShim shim = this.initShim;
        return shim != null ? shim.superTypeRestriction() : this.superTypeRestriction;
    }

    @Override
    @Deprecated
    public String methodDeclaringClassName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.methodDeclaringClassName() : this.methodDeclaringClassName;
    }

    @Override
    public String methodName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.methodName() : this.methodName;
    }

    @Override
    public String methodAnnotation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.methodAnnotation() : this.methodAnnotation;
    }

    @Override
    public ImmutableList<String> methodParameterTypes() {
        return this.methodParameterTypes;
    }

    @Override
    public String methodReturnType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.methodReturnType() : this.methodReturnType;
    }

    @Override
    public ImmutableList<Advice.MethodModifier> methodModifiers() {
        return this.methodModifiers;
    }

    @Override
    public String nestingGroup() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nestingGroup() : this.nestingGroup;
    }

    @Override
    public int order() {
        InitShim shim = this.initShim;
        return shim != null ? shim.order() : this.order;
    }

    @Override
    public Descriptor.CaptureKind captureKind() {
        return this.captureKind;
    }

    @Override
    public String transactionType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.transactionType() : this.transactionType;
    }

    @Override
    public String transactionNameTemplate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.transactionNameTemplate() : this.transactionNameTemplate;
    }

    @Override
    public String transactionUserTemplate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.transactionUserTemplate() : this.transactionUserTemplate;
    }

    public ImmutableMap<String, String> transactionAttributeTemplates() {
        return this.transactionAttributeTemplates;
    }

    @Override
    @Nullable
    public Integer transactionSlowThresholdMillis() {
        return this.transactionSlowThresholdMillis;
    }

    @Override
    @Nullable
    public OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehavior() {
        return this.alreadyInTransactionBehavior;
    }

    @Override
    @Nullable
    public OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehaviorCorrected() {
        InitShim shim = this.initShim;
        return shim != null ? shim.alreadyInTransactionBehaviorCorrected() : this.alreadyInTransactionBehaviorCorrected;
    }

    @Override
    public String spanMessageTemplate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.spanMessageTemplate() : this.spanMessageTemplate;
    }

    @Override
    @Nullable
    public Integer spanStackThresholdMillis() {
        return this.spanStackThresholdMillis;
    }

    @Override
    public boolean spanCaptureSelfNested() {
        InitShim shim = this.initShim;
        return shim != null ? shim.spanCaptureSelfNested() : this.spanCaptureSelfNested;
    }

    @Override
    public String timerName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.timerName() : this.timerName;
    }

    @Override
    public String enabledProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.enabledProperty() : this.enabledProperty;
    }

    @Override
    public String localSpanEnabledProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.localSpanEnabledProperty() : this.localSpanEnabledProperty;
    }

    @Override
    public boolean isTimerOrGreater() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isTimerOrGreater() : this.isTimerOrGreater;
    }

    @Override
    public boolean isLocalSpanOrGreater() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isLocalSpanOrGreater() : this.isLocalSpanOrGreater;
    }

    @Override
    public boolean isTransaction() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isTransaction() : this.isTransaction;
    }

    @Override
    public ImmutableList<String> validationErrors() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validationErrors() : this.validationErrors;
    }

    public final ImmutableAdviceConfig withClassName(String value) {
        String newValue = Preconditions.checkNotNull(value, "className");
        if (this.className.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(newValue, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withClassAnnotation(String value) {
        String newValue = Preconditions.checkNotNull(value, "classAnnotation");
        if (this.classAnnotation.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, newValue, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withSubTypeRestriction(String value) {
        String newValue = Preconditions.checkNotNull(value, "subTypeRestriction");
        if (this.subTypeRestriction.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, newValue, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withSuperTypeRestriction(String value) {
        String newValue = Preconditions.checkNotNull(value, "superTypeRestriction");
        if (this.superTypeRestriction.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, newValue, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    @Deprecated
    public final ImmutableAdviceConfig withMethodDeclaringClassName(String value) {
        String newValue = Preconditions.checkNotNull(value, "methodDeclaringClassName");
        if (this.methodDeclaringClassName.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, newValue, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withMethodName(String value) {
        String newValue = Preconditions.checkNotNull(value, "methodName");
        if (this.methodName.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, newValue, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withMethodAnnotation(String value) {
        String newValue = Preconditions.checkNotNull(value, "methodAnnotation");
        if (this.methodAnnotation.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, newValue, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withMethodParameterTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, newValue, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withMethodParameterTypes(Iterable<String> elements) {
        if (this.methodParameterTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, newValue, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withMethodReturnType(String value) {
        String newValue = Preconditions.checkNotNull(value, "methodReturnType");
        if (this.methodReturnType.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, newValue, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withMethodModifiers(Advice.MethodModifier ... elements) {
        ImmutableList<Advice.MethodModifier> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, newValue, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withMethodModifiers(Iterable<? extends Advice.MethodModifier> elements) {
        if (this.methodModifiers == elements) {
            return this;
        }
        ImmutableList<Advice.MethodModifier> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, newValue, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withNestingGroup(String value) {
        String newValue = Preconditions.checkNotNull(value, "nestingGroup");
        if (this.nestingGroup.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, newValue, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withOrder(int value) {
        if (this.order == value) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, value, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withCaptureKind(Descriptor.CaptureKind value) {
        if (this.captureKind == value) {
            return this;
        }
        Descriptor.CaptureKind newValue = Preconditions.checkNotNull(value, "captureKind");
        if (this.captureKind.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, newValue, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withTransactionType(String value) {
        String newValue = Preconditions.checkNotNull(value, "transactionType");
        if (this.transactionType.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, newValue, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withTransactionNameTemplate(String value) {
        String newValue = Preconditions.checkNotNull(value, "transactionNameTemplate");
        if (this.transactionNameTemplate.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, newValue, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withTransactionUserTemplate(String value) {
        String newValue = Preconditions.checkNotNull(value, "transactionUserTemplate");
        if (this.transactionUserTemplate.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, newValue, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withTransactionAttributeTemplates(Map<String, ? extends String> entries) {
        if (this.transactionAttributeTemplates == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, newValue, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withTransactionSlowThresholdMillis(@Nullable Integer value) {
        if (Objects.equal(this.transactionSlowThresholdMillis, value)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, value, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withAlreadyInTransactionBehavior(@Nullable OptionalThreadContext.AlreadyInTransactionBehavior value) {
        if (this.alreadyInTransactionBehavior == value) {
            return this;
        }
        if (Objects.equal((Object)this.alreadyInTransactionBehavior, (Object)value)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, value, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withSpanMessageTemplate(String value) {
        String newValue = Preconditions.checkNotNull(value, "spanMessageTemplate");
        if (this.spanMessageTemplate.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, newValue, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withSpanStackThresholdMillis(@Nullable Integer value) {
        if (Objects.equal(this.spanStackThresholdMillis, value)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, value, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withSpanCaptureSelfNested(boolean value) {
        if (this.spanCaptureSelfNested == value) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, value, this.timerName, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withTimerName(String value) {
        String newValue = Preconditions.checkNotNull(value, "timerName");
        if (this.timerName.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, newValue, this.enabledProperty, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withEnabledProperty(String value) {
        String newValue = Preconditions.checkNotNull(value, "enabledProperty");
        if (this.enabledProperty.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, newValue, this.localSpanEnabledProperty);
    }

    public final ImmutableAdviceConfig withLocalSpanEnabledProperty(String value) {
        String newValue = Preconditions.checkNotNull(value, "localSpanEnabledProperty");
        if (this.localSpanEnabledProperty.equals(newValue)) {
            return this;
        }
        return new ImmutableAdviceConfig(this.className, this.classAnnotation, this.subTypeRestriction, this.superTypeRestriction, this.methodDeclaringClassName, this.methodName, this.methodAnnotation, this.methodParameterTypes, this.methodReturnType, this.methodModifiers, this.nestingGroup, this.order, this.captureKind, this.transactionType, this.transactionNameTemplate, this.transactionUserTemplate, this.transactionAttributeTemplates, this.transactionSlowThresholdMillis, this.alreadyInTransactionBehavior, this.spanMessageTemplate, this.spanStackThresholdMillis, this.spanCaptureSelfNested, this.timerName, this.enabledProperty, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAdviceConfig && this.equalTo((ImmutableAdviceConfig)another);
    }

    private boolean equalTo(ImmutableAdviceConfig another) {
        return this.className.equals(another.className) && this.classAnnotation.equals(another.classAnnotation) && this.subTypeRestriction.equals(another.subTypeRestriction) && this.superTypeRestriction.equals(another.superTypeRestriction) && this.methodDeclaringClassName.equals(another.methodDeclaringClassName) && this.methodName.equals(another.methodName) && this.methodAnnotation.equals(another.methodAnnotation) && this.methodParameterTypes.equals(another.methodParameterTypes) && this.methodReturnType.equals(another.methodReturnType) && this.methodModifiers.equals(another.methodModifiers) && this.nestingGroup.equals(another.nestingGroup) && this.order == another.order && this.captureKind.equals((Object)another.captureKind) && this.transactionType.equals(another.transactionType) && this.transactionNameTemplate.equals(another.transactionNameTemplate) && this.transactionUserTemplate.equals(another.transactionUserTemplate) && this.transactionAttributeTemplates.equals(another.transactionAttributeTemplates) && Objects.equal(this.transactionSlowThresholdMillis, another.transactionSlowThresholdMillis) && Objects.equal((Object)this.alreadyInTransactionBehavior, (Object)another.alreadyInTransactionBehavior) && Objects.equal((Object)this.alreadyInTransactionBehaviorCorrected, (Object)another.alreadyInTransactionBehaviorCorrected) && this.spanMessageTemplate.equals(another.spanMessageTemplate) && Objects.equal(this.spanStackThresholdMillis, another.spanStackThresholdMillis) && this.spanCaptureSelfNested == another.spanCaptureSelfNested && this.timerName.equals(another.timerName) && this.enabledProperty.equals(another.enabledProperty) && this.localSpanEnabledProperty.equals(another.localSpanEnabledProperty) && this.isTimerOrGreater == another.isTimerOrGreater && this.isLocalSpanOrGreater == another.isLocalSpanOrGreater && this.isTransaction == another.isTransaction && this.validationErrors.equals(another.validationErrors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.className.hashCode();
        h += (h << 5) + this.classAnnotation.hashCode();
        h += (h << 5) + this.subTypeRestriction.hashCode();
        h += (h << 5) + this.superTypeRestriction.hashCode();
        h += (h << 5) + this.methodDeclaringClassName.hashCode();
        h += (h << 5) + this.methodName.hashCode();
        h += (h << 5) + this.methodAnnotation.hashCode();
        h += (h << 5) + this.methodParameterTypes.hashCode();
        h += (h << 5) + this.methodReturnType.hashCode();
        h += (h << 5) + this.methodModifiers.hashCode();
        h += (h << 5) + this.nestingGroup.hashCode();
        h += (h << 5) + this.order;
        h += (h << 5) + this.captureKind.hashCode();
        h += (h << 5) + this.transactionType.hashCode();
        h += (h << 5) + this.transactionNameTemplate.hashCode();
        h += (h << 5) + this.transactionUserTemplate.hashCode();
        h += (h << 5) + this.transactionAttributeTemplates.hashCode();
        h += (h << 5) + Objects.hashCode(this.transactionSlowThresholdMillis);
        h += (h << 5) + Objects.hashCode(new Object[]{this.alreadyInTransactionBehavior});
        h += (h << 5) + Objects.hashCode(new Object[]{this.alreadyInTransactionBehaviorCorrected});
        h += (h << 5) + this.spanMessageTemplate.hashCode();
        h += (h << 5) + Objects.hashCode(this.spanStackThresholdMillis);
        h += (h << 5) + Booleans.hashCode(this.spanCaptureSelfNested);
        h += (h << 5) + this.timerName.hashCode();
        h += (h << 5) + this.enabledProperty.hashCode();
        h += (h << 5) + this.localSpanEnabledProperty.hashCode();
        h += (h << 5) + Booleans.hashCode(this.isTimerOrGreater);
        h += (h << 5) + Booleans.hashCode(this.isLocalSpanOrGreater);
        h += (h << 5) + Booleans.hashCode(this.isTransaction);
        h += (h << 5) + this.validationErrors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AdviceConfig").omitNullValues().add("className", this.className).add("classAnnotation", this.classAnnotation).add("subTypeRestriction", this.subTypeRestriction).add("superTypeRestriction", this.superTypeRestriction).add("methodDeclaringClassName", this.methodDeclaringClassName).add("methodName", this.methodName).add("methodAnnotation", this.methodAnnotation).add("methodParameterTypes", this.methodParameterTypes).add("methodReturnType", this.methodReturnType).add("methodModifiers", this.methodModifiers).add("nestingGroup", this.nestingGroup).add("order", this.order).add("captureKind", (Object)this.captureKind).add("transactionType", this.transactionType).add("transactionNameTemplate", this.transactionNameTemplate).add("transactionUserTemplate", this.transactionUserTemplate).add("transactionAttributeTemplates", this.transactionAttributeTemplates).add("transactionSlowThresholdMillis", this.transactionSlowThresholdMillis).add("alreadyInTransactionBehavior", (Object)this.alreadyInTransactionBehavior).add("alreadyInTransactionBehaviorCorrected", (Object)this.alreadyInTransactionBehaviorCorrected).add("spanMessageTemplate", this.spanMessageTemplate).add("spanStackThresholdMillis", this.spanStackThresholdMillis).add("spanCaptureSelfNested", this.spanCaptureSelfNested).add("timerName", this.timerName).add("enabledProperty", this.enabledProperty).add("localSpanEnabledProperty", this.localSpanEnabledProperty).add("isTimerOrGreater", this.isTimerOrGreater).add("isLocalSpanOrGreater", this.isLocalSpanOrGreater).add("isTransaction", this.isTransaction).add("validationErrors", this.validationErrors).toString();
    }

    public static ImmutableAdviceConfig copyOf(AdviceConfig instance) {
        if (instance instanceof ImmutableAdviceConfig) {
            return (ImmutableAdviceConfig)instance;
        }
        return ImmutableAdviceConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AdviceConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CAPTURE_KIND = 1L;
        private static final long OPT_BIT_ORDER = 1L;
        private static final long OPT_BIT_SPAN_CAPTURE_SELF_NESTED = 2L;
        private long initBits = 1L;
        private long optBits;
        private String className;
        private String classAnnotation;
        private String subTypeRestriction;
        private String superTypeRestriction;
        private String methodDeclaringClassName;
        private String methodName;
        private String methodAnnotation;
        private ImmutableList.Builder<String> methodParameterTypes = ImmutableList.builder();
        private String methodReturnType;
        private ImmutableList.Builder<Advice.MethodModifier> methodModifiers = ImmutableList.builder();
        private String nestingGroup;
        private int order;
        private Descriptor.CaptureKind captureKind;
        private String transactionType;
        private String transactionNameTemplate;
        private String transactionUserTemplate;
        private ImmutableMap.Builder<String, String> transactionAttributeTemplates = ImmutableMap.builder();
        private Integer transactionSlowThresholdMillis;
        private OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehavior;
        private String spanMessageTemplate;
        private Integer spanStackThresholdMillis;
        private boolean spanCaptureSelfNested;
        private String timerName;
        private String enabledProperty;
        private String localSpanEnabledProperty;

        private Builder() {
        }

        public final Builder from(AdviceConfig instance) {
            OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehaviorValue;
            Preconditions.checkNotNull(instance, "instance");
            this.className(instance.className());
            this.classAnnotation(instance.classAnnotation());
            this.subTypeRestriction(instance.subTypeRestriction());
            this.superTypeRestriction(instance.superTypeRestriction());
            this.methodDeclaringClassName(instance.methodDeclaringClassName());
            this.methodName(instance.methodName());
            this.methodAnnotation(instance.methodAnnotation());
            this.addAllMethodParameterTypes(instance.methodParameterTypes());
            this.methodReturnType(instance.methodReturnType());
            this.addAllMethodModifiers(instance.methodModifiers());
            this.nestingGroup(instance.nestingGroup());
            this.order(instance.order());
            this.captureKind(instance.captureKind());
            this.transactionType(instance.transactionType());
            this.transactionNameTemplate(instance.transactionNameTemplate());
            this.transactionUserTemplate(instance.transactionUserTemplate());
            this.putAllTransactionAttributeTemplates(instance.transactionAttributeTemplates());
            Integer transactionSlowThresholdMillisValue = instance.transactionSlowThresholdMillis();
            if (transactionSlowThresholdMillisValue != null) {
                this.transactionSlowThresholdMillis(transactionSlowThresholdMillisValue);
            }
            if ((alreadyInTransactionBehaviorValue = instance.alreadyInTransactionBehavior()) != null) {
                this.alreadyInTransactionBehavior(alreadyInTransactionBehaviorValue);
            }
            this.spanMessageTemplate(instance.spanMessageTemplate());
            Integer spanStackThresholdMillisValue = instance.spanStackThresholdMillis();
            if (spanStackThresholdMillisValue != null) {
                this.spanStackThresholdMillis(spanStackThresholdMillisValue);
            }
            this.spanCaptureSelfNested(instance.spanCaptureSelfNested());
            this.timerName(instance.timerName());
            this.enabledProperty(instance.enabledProperty());
            this.localSpanEnabledProperty(instance.localSpanEnabledProperty());
            return this;
        }

        public final Builder className(String className) {
            this.className = Preconditions.checkNotNull(className, "className");
            return this;
        }

        public final Builder classAnnotation(String classAnnotation) {
            this.classAnnotation = Preconditions.checkNotNull(classAnnotation, "classAnnotation");
            return this;
        }

        public final Builder subTypeRestriction(String subTypeRestriction) {
            this.subTypeRestriction = Preconditions.checkNotNull(subTypeRestriction, "subTypeRestriction");
            return this;
        }

        public final Builder superTypeRestriction(String superTypeRestriction) {
            this.superTypeRestriction = Preconditions.checkNotNull(superTypeRestriction, "superTypeRestriction");
            return this;
        }

        @Deprecated
        public final Builder methodDeclaringClassName(String methodDeclaringClassName) {
            this.methodDeclaringClassName = Preconditions.checkNotNull(methodDeclaringClassName, "methodDeclaringClassName");
            return this;
        }

        public final Builder methodName(String methodName) {
            this.methodName = Preconditions.checkNotNull(methodName, "methodName");
            return this;
        }

        public final Builder methodAnnotation(String methodAnnotation) {
            this.methodAnnotation = Preconditions.checkNotNull(methodAnnotation, "methodAnnotation");
            return this;
        }

        public final Builder addMethodParameterTypes(String element) {
            this.methodParameterTypes.add((Object)element);
            return this;
        }

        public final Builder addMethodParameterTypes(String ... elements) {
            this.methodParameterTypes.add(elements);
            return this;
        }

        public final Builder methodParameterTypes(Iterable<String> elements) {
            this.methodParameterTypes = ImmutableList.builder();
            return this.addAllMethodParameterTypes(elements);
        }

        public final Builder addAllMethodParameterTypes(Iterable<String> elements) {
            this.methodParameterTypes.addAll((Iterable)elements);
            return this;
        }

        public final Builder methodReturnType(String methodReturnType) {
            this.methodReturnType = Preconditions.checkNotNull(methodReturnType, "methodReturnType");
            return this;
        }

        public final Builder addMethodModifiers(Advice.MethodModifier element) {
            this.methodModifiers.add((Object)element);
            return this;
        }

        public final Builder addMethodModifiers(Advice.MethodModifier ... elements) {
            this.methodModifiers.add((Object[])elements);
            return this;
        }

        public final Builder methodModifiers(Iterable<? extends Advice.MethodModifier> elements) {
            this.methodModifiers = ImmutableList.builder();
            return this.addAllMethodModifiers(elements);
        }

        public final Builder addAllMethodModifiers(Iterable<? extends Advice.MethodModifier> elements) {
            this.methodModifiers.addAll(elements);
            return this;
        }

        public final Builder nestingGroup(String nestingGroup) {
            this.nestingGroup = Preconditions.checkNotNull(nestingGroup, "nestingGroup");
            return this;
        }

        public final Builder order(int order) {
            this.order = order;
            this.optBits |= 1L;
            return this;
        }

        public final Builder captureKind(Descriptor.CaptureKind captureKind) {
            this.captureKind = Preconditions.checkNotNull(captureKind, "captureKind");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder transactionType(String transactionType) {
            this.transactionType = Preconditions.checkNotNull(transactionType, "transactionType");
            return this;
        }

        public final Builder transactionNameTemplate(String transactionNameTemplate) {
            this.transactionNameTemplate = Preconditions.checkNotNull(transactionNameTemplate, "transactionNameTemplate");
            return this;
        }

        public final Builder transactionUserTemplate(String transactionUserTemplate) {
            this.transactionUserTemplate = Preconditions.checkNotNull(transactionUserTemplate, "transactionUserTemplate");
            return this;
        }

        public final Builder putTransactionAttributeTemplates(String key, String value) {
            this.transactionAttributeTemplates.put(key, value);
            return this;
        }

        public final Builder putTransactionAttributeTemplates(Map.Entry<String, ? extends String> entry) {
            this.transactionAttributeTemplates.put(entry);
            return this;
        }

        public final Builder transactionAttributeTemplates(Map<String, ? extends String> entries) {
            this.transactionAttributeTemplates = ImmutableMap.builder();
            return this.putAllTransactionAttributeTemplates(entries);
        }

        public final Builder putAllTransactionAttributeTemplates(Map<String, ? extends String> entries) {
            this.transactionAttributeTemplates.putAll(entries);
            return this;
        }

        public final Builder transactionSlowThresholdMillis(@Nullable Integer transactionSlowThresholdMillis) {
            this.transactionSlowThresholdMillis = transactionSlowThresholdMillis;
            return this;
        }

        public final Builder alreadyInTransactionBehavior(@Nullable OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehavior) {
            this.alreadyInTransactionBehavior = alreadyInTransactionBehavior;
            return this;
        }

        public final Builder spanMessageTemplate(String spanMessageTemplate) {
            this.spanMessageTemplate = Preconditions.checkNotNull(spanMessageTemplate, "spanMessageTemplate");
            return this;
        }

        public final Builder spanStackThresholdMillis(@Nullable Integer spanStackThresholdMillis) {
            this.spanStackThresholdMillis = spanStackThresholdMillis;
            return this;
        }

        public final Builder spanCaptureSelfNested(boolean spanCaptureSelfNested) {
            this.spanCaptureSelfNested = spanCaptureSelfNested;
            this.optBits |= 2L;
            return this;
        }

        public final Builder timerName(String timerName) {
            this.timerName = Preconditions.checkNotNull(timerName, "timerName");
            return this;
        }

        public final Builder enabledProperty(String enabledProperty) {
            this.enabledProperty = Preconditions.checkNotNull(enabledProperty, "enabledProperty");
            return this;
        }

        public final Builder localSpanEnabledProperty(String localSpanEnabledProperty) {
            this.localSpanEnabledProperty = Preconditions.checkNotNull(localSpanEnabledProperty, "localSpanEnabledProperty");
            return this;
        }

        public ImmutableAdviceConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAdviceConfig(this);
        }

        private boolean orderIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean spanCaptureSelfNestedIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("captureKind");
            }
            return "Cannot build AdviceConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="AdviceConfig", generator="Immutables")
    private final class InitShim {
        private byte classNameBuildStage = 0;
        private String className;
        private byte classAnnotationBuildStage = 0;
        private String classAnnotation;
        private byte subTypeRestrictionBuildStage = 0;
        private String subTypeRestriction;
        private byte superTypeRestrictionBuildStage = 0;
        private String superTypeRestriction;
        private byte methodDeclaringClassNameBuildStage = 0;
        private String methodDeclaringClassName;
        private byte methodNameBuildStage = 0;
        private String methodName;
        private byte methodAnnotationBuildStage = 0;
        private String methodAnnotation;
        private byte methodReturnTypeBuildStage = 0;
        private String methodReturnType;
        private byte nestingGroupBuildStage = 0;
        private String nestingGroup;
        private byte orderBuildStage = 0;
        private int order;
        private byte transactionTypeBuildStage = 0;
        private String transactionType;
        private byte transactionNameTemplateBuildStage = 0;
        private String transactionNameTemplate;
        private byte transactionUserTemplateBuildStage = 0;
        private String transactionUserTemplate;
        private byte alreadyInTransactionBehaviorCorrectedBuildStage = 0;
        private OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehaviorCorrected;
        private byte spanMessageTemplateBuildStage = 0;
        private String spanMessageTemplate;
        private byte spanCaptureSelfNestedBuildStage = 0;
        private boolean spanCaptureSelfNested;
        private byte timerNameBuildStage = 0;
        private String timerName;
        private byte enabledPropertyBuildStage = 0;
        private String enabledProperty;
        private byte localSpanEnabledPropertyBuildStage = 0;
        private String localSpanEnabledProperty;
        private byte isTimerOrGreaterBuildStage = 0;
        private boolean isTimerOrGreater;
        private byte isLocalSpanOrGreaterBuildStage = 0;
        private boolean isLocalSpanOrGreater;
        private byte isTransactionBuildStage = 0;
        private boolean isTransaction;
        private byte validationErrorsBuildStage = 0;
        private ImmutableList<String> validationErrors;

        private InitShim() {
        }

        String className() {
            if (this.classNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.classNameBuildStage == 0) {
                this.classNameBuildStage = (byte)-1;
                this.className = Preconditions.checkNotNull(ImmutableAdviceConfig.super.className(), "className");
                this.classNameBuildStage = 1;
            }
            return this.className;
        }

        void className(String className) {
            this.className = className;
            this.classNameBuildStage = 1;
        }

        String classAnnotation() {
            if (this.classAnnotationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.classAnnotationBuildStage == 0) {
                this.classAnnotationBuildStage = (byte)-1;
                this.classAnnotation = Preconditions.checkNotNull(ImmutableAdviceConfig.super.classAnnotation(), "classAnnotation");
                this.classAnnotationBuildStage = 1;
            }
            return this.classAnnotation;
        }

        void classAnnotation(String classAnnotation) {
            this.classAnnotation = classAnnotation;
            this.classAnnotationBuildStage = 1;
        }

        String subTypeRestriction() {
            if (this.subTypeRestrictionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.subTypeRestrictionBuildStage == 0) {
                this.subTypeRestrictionBuildStage = (byte)-1;
                this.subTypeRestriction = Preconditions.checkNotNull(ImmutableAdviceConfig.super.subTypeRestriction(), "subTypeRestriction");
                this.subTypeRestrictionBuildStage = 1;
            }
            return this.subTypeRestriction;
        }

        void subTypeRestriction(String subTypeRestriction) {
            this.subTypeRestriction = subTypeRestriction;
            this.subTypeRestrictionBuildStage = 1;
        }

        String superTypeRestriction() {
            if (this.superTypeRestrictionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.superTypeRestrictionBuildStage == 0) {
                this.superTypeRestrictionBuildStage = (byte)-1;
                this.superTypeRestriction = Preconditions.checkNotNull(ImmutableAdviceConfig.super.superTypeRestriction(), "superTypeRestriction");
                this.superTypeRestrictionBuildStage = 1;
            }
            return this.superTypeRestriction;
        }

        void superTypeRestriction(String superTypeRestriction) {
            this.superTypeRestriction = superTypeRestriction;
            this.superTypeRestrictionBuildStage = 1;
        }

        String methodDeclaringClassName() {
            if (this.methodDeclaringClassNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.methodDeclaringClassNameBuildStage == 0) {
                this.methodDeclaringClassNameBuildStage = (byte)-1;
                this.methodDeclaringClassName = Preconditions.checkNotNull(ImmutableAdviceConfig.super.methodDeclaringClassName(), "methodDeclaringClassName");
                this.methodDeclaringClassNameBuildStage = 1;
            }
            return this.methodDeclaringClassName;
        }

        void methodDeclaringClassName(String methodDeclaringClassName) {
            this.methodDeclaringClassName = methodDeclaringClassName;
            this.methodDeclaringClassNameBuildStage = 1;
        }

        String methodName() {
            if (this.methodNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.methodNameBuildStage == 0) {
                this.methodNameBuildStage = (byte)-1;
                this.methodName = Preconditions.checkNotNull(ImmutableAdviceConfig.super.methodName(), "methodName");
                this.methodNameBuildStage = 1;
            }
            return this.methodName;
        }

        void methodName(String methodName) {
            this.methodName = methodName;
            this.methodNameBuildStage = 1;
        }

        String methodAnnotation() {
            if (this.methodAnnotationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.methodAnnotationBuildStage == 0) {
                this.methodAnnotationBuildStage = (byte)-1;
                this.methodAnnotation = Preconditions.checkNotNull(ImmutableAdviceConfig.super.methodAnnotation(), "methodAnnotation");
                this.methodAnnotationBuildStage = 1;
            }
            return this.methodAnnotation;
        }

        void methodAnnotation(String methodAnnotation) {
            this.methodAnnotation = methodAnnotation;
            this.methodAnnotationBuildStage = 1;
        }

        String methodReturnType() {
            if (this.methodReturnTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.methodReturnTypeBuildStage == 0) {
                this.methodReturnTypeBuildStage = (byte)-1;
                this.methodReturnType = Preconditions.checkNotNull(ImmutableAdviceConfig.super.methodReturnType(), "methodReturnType");
                this.methodReturnTypeBuildStage = 1;
            }
            return this.methodReturnType;
        }

        void methodReturnType(String methodReturnType) {
            this.methodReturnType = methodReturnType;
            this.methodReturnTypeBuildStage = 1;
        }

        String nestingGroup() {
            if (this.nestingGroupBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nestingGroupBuildStage == 0) {
                this.nestingGroupBuildStage = (byte)-1;
                this.nestingGroup = Preconditions.checkNotNull(ImmutableAdviceConfig.super.nestingGroup(), "nestingGroup");
                this.nestingGroupBuildStage = 1;
            }
            return this.nestingGroup;
        }

        void nestingGroup(String nestingGroup) {
            this.nestingGroup = nestingGroup;
            this.nestingGroupBuildStage = 1;
        }

        int order() {
            if (this.orderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.orderBuildStage == 0) {
                this.orderBuildStage = (byte)-1;
                this.order = ImmutableAdviceConfig.super.order();
                this.orderBuildStage = 1;
            }
            return this.order;
        }

        void order(int order) {
            this.order = order;
            this.orderBuildStage = 1;
        }

        String transactionType() {
            if (this.transactionTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.transactionTypeBuildStage == 0) {
                this.transactionTypeBuildStage = (byte)-1;
                this.transactionType = Preconditions.checkNotNull(ImmutableAdviceConfig.super.transactionType(), "transactionType");
                this.transactionTypeBuildStage = 1;
            }
            return this.transactionType;
        }

        void transactionType(String transactionType) {
            this.transactionType = transactionType;
            this.transactionTypeBuildStage = 1;
        }

        String transactionNameTemplate() {
            if (this.transactionNameTemplateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.transactionNameTemplateBuildStage == 0) {
                this.transactionNameTemplateBuildStage = (byte)-1;
                this.transactionNameTemplate = Preconditions.checkNotNull(ImmutableAdviceConfig.super.transactionNameTemplate(), "transactionNameTemplate");
                this.transactionNameTemplateBuildStage = 1;
            }
            return this.transactionNameTemplate;
        }

        void transactionNameTemplate(String transactionNameTemplate) {
            this.transactionNameTemplate = transactionNameTemplate;
            this.transactionNameTemplateBuildStage = 1;
        }

        String transactionUserTemplate() {
            if (this.transactionUserTemplateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.transactionUserTemplateBuildStage == 0) {
                this.transactionUserTemplateBuildStage = (byte)-1;
                this.transactionUserTemplate = Preconditions.checkNotNull(ImmutableAdviceConfig.super.transactionUserTemplate(), "transactionUserTemplate");
                this.transactionUserTemplateBuildStage = 1;
            }
            return this.transactionUserTemplate;
        }

        void transactionUserTemplate(String transactionUserTemplate) {
            this.transactionUserTemplate = transactionUserTemplate;
            this.transactionUserTemplateBuildStage = 1;
        }

        OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehaviorCorrected() {
            if (this.alreadyInTransactionBehaviorCorrectedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.alreadyInTransactionBehaviorCorrectedBuildStage == 0) {
                this.alreadyInTransactionBehaviorCorrectedBuildStage = (byte)-1;
                this.alreadyInTransactionBehaviorCorrected = ImmutableAdviceConfig.super.alreadyInTransactionBehaviorCorrected();
                this.alreadyInTransactionBehaviorCorrectedBuildStage = 1;
            }
            return this.alreadyInTransactionBehaviorCorrected;
        }

        String spanMessageTemplate() {
            if (this.spanMessageTemplateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.spanMessageTemplateBuildStage == 0) {
                this.spanMessageTemplateBuildStage = (byte)-1;
                this.spanMessageTemplate = Preconditions.checkNotNull(ImmutableAdviceConfig.super.spanMessageTemplate(), "spanMessageTemplate");
                this.spanMessageTemplateBuildStage = 1;
            }
            return this.spanMessageTemplate;
        }

        void spanMessageTemplate(String spanMessageTemplate) {
            this.spanMessageTemplate = spanMessageTemplate;
            this.spanMessageTemplateBuildStage = 1;
        }

        boolean spanCaptureSelfNested() {
            if (this.spanCaptureSelfNestedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.spanCaptureSelfNestedBuildStage == 0) {
                this.spanCaptureSelfNestedBuildStage = (byte)-1;
                this.spanCaptureSelfNested = ImmutableAdviceConfig.super.spanCaptureSelfNested();
                this.spanCaptureSelfNestedBuildStage = 1;
            }
            return this.spanCaptureSelfNested;
        }

        void spanCaptureSelfNested(boolean spanCaptureSelfNested) {
            this.spanCaptureSelfNested = spanCaptureSelfNested;
            this.spanCaptureSelfNestedBuildStage = 1;
        }

        String timerName() {
            if (this.timerNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.timerNameBuildStage == 0) {
                this.timerNameBuildStage = (byte)-1;
                this.timerName = Preconditions.checkNotNull(ImmutableAdviceConfig.super.timerName(), "timerName");
                this.timerNameBuildStage = 1;
            }
            return this.timerName;
        }

        void timerName(String timerName) {
            this.timerName = timerName;
            this.timerNameBuildStage = 1;
        }

        String enabledProperty() {
            if (this.enabledPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.enabledPropertyBuildStage == 0) {
                this.enabledPropertyBuildStage = (byte)-1;
                this.enabledProperty = Preconditions.checkNotNull(ImmutableAdviceConfig.super.enabledProperty(), "enabledProperty");
                this.enabledPropertyBuildStage = 1;
            }
            return this.enabledProperty;
        }

        void enabledProperty(String enabledProperty) {
            this.enabledProperty = enabledProperty;
            this.enabledPropertyBuildStage = 1;
        }

        String localSpanEnabledProperty() {
            if (this.localSpanEnabledPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.localSpanEnabledPropertyBuildStage == 0) {
                this.localSpanEnabledPropertyBuildStage = (byte)-1;
                this.localSpanEnabledProperty = Preconditions.checkNotNull(ImmutableAdviceConfig.super.localSpanEnabledProperty(), "localSpanEnabledProperty");
                this.localSpanEnabledPropertyBuildStage = 1;
            }
            return this.localSpanEnabledProperty;
        }

        void localSpanEnabledProperty(String localSpanEnabledProperty) {
            this.localSpanEnabledProperty = localSpanEnabledProperty;
            this.localSpanEnabledPropertyBuildStage = 1;
        }

        boolean isTimerOrGreater() {
            if (this.isTimerOrGreaterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isTimerOrGreaterBuildStage == 0) {
                this.isTimerOrGreaterBuildStage = (byte)-1;
                this.isTimerOrGreater = ImmutableAdviceConfig.super.isTimerOrGreater();
                this.isTimerOrGreaterBuildStage = 1;
            }
            return this.isTimerOrGreater;
        }

        boolean isLocalSpanOrGreater() {
            if (this.isLocalSpanOrGreaterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isLocalSpanOrGreaterBuildStage == 0) {
                this.isLocalSpanOrGreaterBuildStage = (byte)-1;
                this.isLocalSpanOrGreater = ImmutableAdviceConfig.super.isLocalSpanOrGreater();
                this.isLocalSpanOrGreaterBuildStage = 1;
            }
            return this.isLocalSpanOrGreater;
        }

        boolean isTransaction() {
            if (this.isTransactionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isTransactionBuildStage == 0) {
                this.isTransactionBuildStage = (byte)-1;
                this.isTransaction = ImmutableAdviceConfig.super.isTransaction();
                this.isTransactionBuildStage = 1;
            }
            return this.isTransaction;
        }

        ImmutableList<String> validationErrors() {
            if (this.validationErrorsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validationErrorsBuildStage == 0) {
                this.validationErrorsBuildStage = (byte)-1;
                this.validationErrors = Preconditions.checkNotNull(ImmutableAdviceConfig.super.validationErrors(), "validationErrors");
                this.validationErrorsBuildStage = 1;
            }
            return this.validationErrors;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.classNameBuildStage == -1) {
                attributes.add("className");
            }
            if (this.classAnnotationBuildStage == -1) {
                attributes.add("classAnnotation");
            }
            if (this.subTypeRestrictionBuildStage == -1) {
                attributes.add("subTypeRestriction");
            }
            if (this.superTypeRestrictionBuildStage == -1) {
                attributes.add("superTypeRestriction");
            }
            if (this.methodDeclaringClassNameBuildStage == -1) {
                attributes.add("methodDeclaringClassName");
            }
            if (this.methodNameBuildStage == -1) {
                attributes.add("methodName");
            }
            if (this.methodAnnotationBuildStage == -1) {
                attributes.add("methodAnnotation");
            }
            if (this.methodReturnTypeBuildStage == -1) {
                attributes.add("methodReturnType");
            }
            if (this.nestingGroupBuildStage == -1) {
                attributes.add("nestingGroup");
            }
            if (this.orderBuildStage == -1) {
                attributes.add("order");
            }
            if (this.transactionTypeBuildStage == -1) {
                attributes.add("transactionType");
            }
            if (this.transactionNameTemplateBuildStage == -1) {
                attributes.add("transactionNameTemplate");
            }
            if (this.transactionUserTemplateBuildStage == -1) {
                attributes.add("transactionUserTemplate");
            }
            if (this.alreadyInTransactionBehaviorCorrectedBuildStage == -1) {
                attributes.add("alreadyInTransactionBehaviorCorrected");
            }
            if (this.spanMessageTemplateBuildStage == -1) {
                attributes.add("spanMessageTemplate");
            }
            if (this.spanCaptureSelfNestedBuildStage == -1) {
                attributes.add("spanCaptureSelfNested");
            }
            if (this.timerNameBuildStage == -1) {
                attributes.add("timerName");
            }
            if (this.enabledPropertyBuildStage == -1) {
                attributes.add("enabledProperty");
            }
            if (this.localSpanEnabledPropertyBuildStage == -1) {
                attributes.add("localSpanEnabledProperty");
            }
            if (this.isTimerOrGreaterBuildStage == -1) {
                attributes.add("isTimerOrGreater");
            }
            if (this.isLocalSpanOrGreaterBuildStage == -1) {
                attributes.add("isLocalSpanOrGreater");
            }
            if (this.isTransactionBuildStage == -1) {
                attributes.add("isTransaction");
            }
            if (this.validationErrorsBuildStage == -1) {
                attributes.add("validationErrors");
            }
            return "Cannot build AdviceConfig, attribute initializers form cycle " + attributes;
        }
    }
}

