/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.config;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Objects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.primitives.Booleans;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.io.File;
import java.util.ArrayList;
import org.glowroot.instrumentation.engine.config.AdviceConfig;
import org.glowroot.instrumentation.engine.config.InstrumentationDescriptor;
import org.glowroot.instrumentation.engine.config.PropertyDescriptor;
import org.immutables.value.Generated;

@Generated(from="InstrumentationDescriptor", generator="Immutables")
public final class ImmutableInstrumentationDescriptor
extends InstrumentationDescriptor {
    private final String id;
    private final String name;
    private final ImmutableList<PropertyDescriptor> properties;
    private final ImmutableList<AdviceConfig> adviceConfigs;
    private final ImmutableList<String> classes;
    private final boolean collocate;
    @Nullable
    private final File jarFile;

    private ImmutableInstrumentationDescriptor(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.properties = builder.properties.build();
        this.adviceConfigs = builder.adviceConfigs.build();
        this.classes = builder.classes.build();
        this.jarFile = builder.jarFile;
        this.collocate = builder.collocateIsSet() ? builder.collocate : super.collocate();
    }

    private ImmutableInstrumentationDescriptor(String id, String name, ImmutableList<PropertyDescriptor> properties, ImmutableList<AdviceConfig> adviceConfigs, ImmutableList<String> classes, boolean collocate, @Nullable File jarFile) {
        this.id = id;
        this.name = name;
        this.properties = properties;
        this.adviceConfigs = adviceConfigs;
        this.classes = classes;
        this.collocate = collocate;
        this.jarFile = jarFile;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ImmutableList<PropertyDescriptor> properties() {
        return this.properties;
    }

    @Override
    public ImmutableList<AdviceConfig> adviceConfigs() {
        return this.adviceConfigs;
    }

    @Override
    public ImmutableList<String> classes() {
        return this.classes;
    }

    @Override
    public boolean collocate() {
        return this.collocate;
    }

    @Override
    @Nullable
    public File jarFile() {
        return this.jarFile;
    }

    public final ImmutableInstrumentationDescriptor withId(String value) {
        String newValue = Preconditions.checkNotNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableInstrumentationDescriptor(newValue, this.name, this.properties, this.adviceConfigs, this.classes, this.collocate, this.jarFile);
    }

    public final ImmutableInstrumentationDescriptor withName(String value) {
        String newValue = Preconditions.checkNotNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableInstrumentationDescriptor(this.id, newValue, this.properties, this.adviceConfigs, this.classes, this.collocate, this.jarFile);
    }

    public final ImmutableInstrumentationDescriptor withProperties(PropertyDescriptor ... elements) {
        ImmutableList<PropertyDescriptor> newValue = ImmutableList.copyOf(elements);
        return new ImmutableInstrumentationDescriptor(this.id, this.name, newValue, this.adviceConfigs, this.classes, this.collocate, this.jarFile);
    }

    public final ImmutableInstrumentationDescriptor withProperties(Iterable<? extends PropertyDescriptor> elements) {
        if (this.properties == elements) {
            return this;
        }
        ImmutableList<PropertyDescriptor> newValue = ImmutableList.copyOf(elements);
        return new ImmutableInstrumentationDescriptor(this.id, this.name, newValue, this.adviceConfigs, this.classes, this.collocate, this.jarFile);
    }

    public final ImmutableInstrumentationDescriptor withAdviceConfigs(AdviceConfig ... elements) {
        ImmutableList<AdviceConfig> newValue = ImmutableList.copyOf(elements);
        return new ImmutableInstrumentationDescriptor(this.id, this.name, this.properties, newValue, this.classes, this.collocate, this.jarFile);
    }

    public final ImmutableInstrumentationDescriptor withAdviceConfigs(Iterable<? extends AdviceConfig> elements) {
        if (this.adviceConfigs == elements) {
            return this;
        }
        ImmutableList<AdviceConfig> newValue = ImmutableList.copyOf(elements);
        return new ImmutableInstrumentationDescriptor(this.id, this.name, this.properties, newValue, this.classes, this.collocate, this.jarFile);
    }

    public final ImmutableInstrumentationDescriptor withClasses(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableInstrumentationDescriptor(this.id, this.name, this.properties, this.adviceConfigs, newValue, this.collocate, this.jarFile);
    }

    public final ImmutableInstrumentationDescriptor withClasses(Iterable<String> elements) {
        if (this.classes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableInstrumentationDescriptor(this.id, this.name, this.properties, this.adviceConfigs, newValue, this.collocate, this.jarFile);
    }

    public final ImmutableInstrumentationDescriptor withCollocate(boolean value) {
        if (this.collocate == value) {
            return this;
        }
        return new ImmutableInstrumentationDescriptor(this.id, this.name, this.properties, this.adviceConfigs, this.classes, value, this.jarFile);
    }

    public final ImmutableInstrumentationDescriptor withJarFile(@Nullable File value) {
        if (this.jarFile == value) {
            return this;
        }
        return new ImmutableInstrumentationDescriptor(this.id, this.name, this.properties, this.adviceConfigs, this.classes, this.collocate, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInstrumentationDescriptor && this.equalTo((ImmutableInstrumentationDescriptor)another);
    }

    private boolean equalTo(ImmutableInstrumentationDescriptor another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.properties.equals(another.properties) && this.adviceConfigs.equals(another.adviceConfigs) && this.classes.equals(another.classes) && this.collocate == another.collocate && Objects.equal(this.jarFile, another.jarFile);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.adviceConfigs.hashCode();
        h += (h << 5) + this.classes.hashCode();
        h += (h << 5) + Booleans.hashCode(this.collocate);
        h += (h << 5) + Objects.hashCode(this.jarFile);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("InstrumentationDescriptor").omitNullValues().add("id", this.id).add("name", this.name).add("properties", this.properties).add("adviceConfigs", this.adviceConfigs).add("classes", this.classes).add("collocate", this.collocate).add("jarFile", this.jarFile).toString();
    }

    public static ImmutableInstrumentationDescriptor copyOf(InstrumentationDescriptor instance) {
        if (instance instanceof ImmutableInstrumentationDescriptor) {
            return (ImmutableInstrumentationDescriptor)instance;
        }
        return ImmutableInstrumentationDescriptor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InstrumentationDescriptor", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long OPT_BIT_COLLOCATE = 1L;
        private long initBits = 3L;
        private long optBits;
        private String id;
        private String name;
        private ImmutableList.Builder<PropertyDescriptor> properties = ImmutableList.builder();
        private ImmutableList.Builder<AdviceConfig> adviceConfigs = ImmutableList.builder();
        private ImmutableList.Builder<String> classes = ImmutableList.builder();
        private boolean collocate;
        private File jarFile;

        private Builder() {
        }

        public final Builder from(InstrumentationDescriptor instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.id(instance.id());
            this.name(instance.name());
            this.addAllProperties(instance.properties());
            this.addAllAdviceConfigs(instance.adviceConfigs());
            this.addAllClasses(instance.classes());
            this.collocate(instance.collocate());
            File jarFileValue = instance.jarFile();
            if (jarFileValue != null) {
                this.jarFile(jarFileValue);
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = Preconditions.checkNotNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addProperties(PropertyDescriptor element) {
            this.properties.add((Object)element);
            return this;
        }

        public final Builder addProperties(PropertyDescriptor ... elements) {
            this.properties.add(elements);
            return this;
        }

        public final Builder properties(Iterable<? extends PropertyDescriptor> elements) {
            this.properties = ImmutableList.builder();
            return this.addAllProperties(elements);
        }

        public final Builder addAllProperties(Iterable<? extends PropertyDescriptor> elements) {
            this.properties.addAll(elements);
            return this;
        }

        public final Builder addAdviceConfigs(AdviceConfig element) {
            this.adviceConfigs.add((Object)element);
            return this;
        }

        public final Builder addAdviceConfigs(AdviceConfig ... elements) {
            this.adviceConfigs.add(elements);
            return this;
        }

        public final Builder adviceConfigs(Iterable<? extends AdviceConfig> elements) {
            this.adviceConfigs = ImmutableList.builder();
            return this.addAllAdviceConfigs(elements);
        }

        public final Builder addAllAdviceConfigs(Iterable<? extends AdviceConfig> elements) {
            this.adviceConfigs.addAll(elements);
            return this;
        }

        public final Builder addClasses(String element) {
            this.classes.add((Object)element);
            return this;
        }

        public final Builder addClasses(String ... elements) {
            this.classes.add(elements);
            return this;
        }

        public final Builder classes(Iterable<String> elements) {
            this.classes = ImmutableList.builder();
            return this.addAllClasses(elements);
        }

        public final Builder addAllClasses(Iterable<String> elements) {
            this.classes.addAll((Iterable)elements);
            return this;
        }

        public final Builder collocate(boolean collocate) {
            this.collocate = collocate;
            this.optBits |= 1L;
            return this;
        }

        public final Builder jarFile(@Nullable File jarFile) {
            this.jarFile = jarFile;
            return this;
        }

        public ImmutableInstrumentationDescriptor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInstrumentationDescriptor(this);
        }

        private boolean collocateIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build InstrumentationDescriptor, some of required attributes are not set " + attributes;
        }
    }
}

