/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.config;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Objects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import org.glowroot.instrumentation.api.Descriptor;
import org.glowroot.instrumentation.engine.config.DefaultValue;
import org.glowroot.instrumentation.engine.config.PropertyDescriptor;
import org.immutables.value.Generated;

@Generated(from="PropertyDescriptor", generator="Immutables")
public final class ImmutablePropertyDescriptor
extends PropertyDescriptor {
    private final String name;
    private final Descriptor.PropertyType type;
    @Nullable
    private final DefaultValue defaultValue;
    private final String label;
    private final String checkboxLabel;
    private final String description;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePropertyDescriptor(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.defaultValue = builder.defaultValue;
        this.label = builder.label;
        if (builder.checkboxLabel != null) {
            this.initShim.checkboxLabel(builder.checkboxLabel);
        }
        if (builder.description != null) {
            this.initShim.description(builder.description);
        }
        this.checkboxLabel = this.initShim.checkboxLabel();
        this.description = this.initShim.description();
        this.initShim = null;
    }

    private ImmutablePropertyDescriptor(String name, Descriptor.PropertyType type, @Nullable DefaultValue defaultValue, String label, String checkboxLabel, String description) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.label = label;
        this.checkboxLabel = checkboxLabel;
        this.description = description;
        this.initShim = null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Descriptor.PropertyType type() {
        return this.type;
    }

    @Override
    @Nullable
    public DefaultValue defaultValue() {
        return this.defaultValue;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public String checkboxLabel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.checkboxLabel() : this.checkboxLabel;
    }

    @Override
    public String description() {
        InitShim shim = this.initShim;
        return shim != null ? shim.description() : this.description;
    }

    public final ImmutablePropertyDescriptor withName(String value) {
        String newValue = Preconditions.checkNotNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutablePropertyDescriptor(newValue, this.type, this.defaultValue, this.label, this.checkboxLabel, this.description);
    }

    public final ImmutablePropertyDescriptor withType(Descriptor.PropertyType value) {
        if (this.type == value) {
            return this;
        }
        Descriptor.PropertyType newValue = Preconditions.checkNotNull(value, "type");
        if (this.type.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePropertyDescriptor(this.name, newValue, this.defaultValue, this.label, this.checkboxLabel, this.description);
    }

    public final ImmutablePropertyDescriptor withDefaultValue(@Nullable DefaultValue value) {
        if (this.defaultValue == value) {
            return this;
        }
        return new ImmutablePropertyDescriptor(this.name, this.type, value, this.label, this.checkboxLabel, this.description);
    }

    public final ImmutablePropertyDescriptor withLabel(String value) {
        String newValue = Preconditions.checkNotNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return new ImmutablePropertyDescriptor(this.name, this.type, this.defaultValue, newValue, this.checkboxLabel, this.description);
    }

    public final ImmutablePropertyDescriptor withCheckboxLabel(String value) {
        String newValue = Preconditions.checkNotNull(value, "checkboxLabel");
        if (this.checkboxLabel.equals(newValue)) {
            return this;
        }
        return new ImmutablePropertyDescriptor(this.name, this.type, this.defaultValue, this.label, newValue, this.description);
    }

    public final ImmutablePropertyDescriptor withDescription(String value) {
        String newValue = Preconditions.checkNotNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutablePropertyDescriptor(this.name, this.type, this.defaultValue, this.label, this.checkboxLabel, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePropertyDescriptor && this.equalTo((ImmutablePropertyDescriptor)another);
    }

    private boolean equalTo(ImmutablePropertyDescriptor another) {
        return this.name.equals(another.name) && this.type.equals((Object)another.type) && Objects.equal(this.defaultValue, another.defaultValue) && this.label.equals(another.label) && this.checkboxLabel.equals(another.checkboxLabel) && this.description.equals(another.description);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.defaultValue);
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.checkboxLabel.hashCode();
        h += (h << 5) + this.description.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PropertyDescriptor").omitNullValues().add("name", this.name).add("type", (Object)this.type).add("defaultValue", this.defaultValue).add("label", this.label).add("checkboxLabel", this.checkboxLabel).add("description", this.description).toString();
    }

    public static ImmutablePropertyDescriptor copyOf(PropertyDescriptor instance) {
        if (instance instanceof ImmutablePropertyDescriptor) {
            return (ImmutablePropertyDescriptor)instance;
        }
        return ImmutablePropertyDescriptor.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PropertyDescriptor", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_LABEL = 4L;
        private long initBits = 7L;
        private String name;
        private Descriptor.PropertyType type;
        private DefaultValue defaultValue;
        private String label;
        private String checkboxLabel;
        private String description;

        private Builder() {
        }

        public final Builder from(PropertyDescriptor instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.name(instance.name());
            this.type(instance.type());
            DefaultValue defaultValueValue = instance.defaultValue();
            if (defaultValueValue != null) {
                this.defaultValue(defaultValueValue);
            }
            this.label(instance.label());
            this.checkboxLabel(instance.checkboxLabel());
            this.description(instance.description());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder type(Descriptor.PropertyType type) {
            this.type = Preconditions.checkNotNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder defaultValue(@Nullable DefaultValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Builder label(String label) {
            this.label = Preconditions.checkNotNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder checkboxLabel(String checkboxLabel) {
            this.checkboxLabel = Preconditions.checkNotNull(checkboxLabel, "checkboxLabel");
            return this;
        }

        public final Builder description(String description) {
            this.description = Preconditions.checkNotNull(description, "description");
            return this;
        }

        public ImmutablePropertyDescriptor build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePropertyDescriptor(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("label");
            }
            return "Cannot build PropertyDescriptor, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="PropertyDescriptor", generator="Immutables")
    private final class InitShim {
        private byte checkboxLabelBuildStage = 0;
        private String checkboxLabel;
        private byte descriptionBuildStage = 0;
        private String description;

        private InitShim() {
        }

        String checkboxLabel() {
            if (this.checkboxLabelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.checkboxLabelBuildStage == 0) {
                this.checkboxLabelBuildStage = (byte)-1;
                this.checkboxLabel = Preconditions.checkNotNull(ImmutablePropertyDescriptor.super.checkboxLabel(), "checkboxLabel");
                this.checkboxLabelBuildStage = 1;
            }
            return this.checkboxLabel;
        }

        void checkboxLabel(String checkboxLabel) {
            this.checkboxLabel = checkboxLabel;
            this.checkboxLabelBuildStage = 1;
        }

        String description() {
            if (this.descriptionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.descriptionBuildStage == 0) {
                this.descriptionBuildStage = (byte)-1;
                this.description = Preconditions.checkNotNull(ImmutablePropertyDescriptor.super.description(), "description");
                this.descriptionBuildStage = 1;
            }
            return this.description;
        }

        void description(String description) {
            this.description = description;
            this.descriptionBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.checkboxLabelBuildStage == -1) {
                attributes.add("checkboxLabel");
            }
            if (this.descriptionBuildStage == -1) {
                attributes.add("description");
            }
            return "Cannot build PropertyDescriptor, attribute initializers form cycle " + attributes;
        }
    }
}

