/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.config;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Charsets;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Iterators;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Resources;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.glowroot.instrumentation.api.Descriptor;
import org.glowroot.instrumentation.engine.config.AdviceConfig;
import org.glowroot.instrumentation.engine.config.DefaultValue;
import org.glowroot.instrumentation.engine.config.ImmutableAdviceConfig;
import org.glowroot.instrumentation.engine.config.ImmutableInstrumentationDescriptor;
import org.glowroot.instrumentation.engine.config.ImmutablePropertyDescriptor;
import org.glowroot.instrumentation.engine.config.InstrumentationDescriptor;
import org.glowroot.instrumentation.engine.config.PropertyDescriptor;

public class InstrumentationDescriptors {
    private InstrumentationDescriptors() {
    }

    public static List<InstrumentationDescriptor> read() throws IOException, ClassNotFoundException {
        List<URL> resources = InstrumentationDescriptors.getResources("META-INF/instrumentation.list");
        ArrayList<InstrumentationDescriptor> descriptors = Lists.newArrayList();
        for (URL resource : resources) {
            List<String> jsonFiles = Resources.readLines(resource, Charsets.ISO_8859_1);
            for (String jsonFile : jsonFiles) {
                if (jsonFile.isEmpty()) continue;
                Class<?> clazz = Class.forName(jsonFile, false, InstrumentationDescriptors.class.getClassLoader());
                Descriptor descriptor = Preconditions.checkNotNull(clazz.getAnnotation(Descriptor.class));
                descriptors.add(InstrumentationDescriptors.read(descriptor));
            }
        }
        return Preconditions.checkNotNull(descriptors);
    }

    private static InstrumentationDescriptor read(Descriptor descriptor) {
        ImmutableInstrumentationDescriptor.Builder builder = ImmutableInstrumentationDescriptor.builder().id(descriptor.id()).name(descriptor.name());
        for (Descriptor.Property property : descriptor.properties()) {
            ImmutablePropertyDescriptor.Builder propertyBuilder = ImmutablePropertyDescriptor.builder().name(property.name()).type(property.type());
            Descriptor.DefaultValue[] defaultValues = property.defaultValue();
            if (defaultValues.length > 0) {
                Descriptor.DefaultValue defaultValue = defaultValues[0];
                propertyBuilder.defaultValue(new DefaultValue(InstrumentationDescriptors.getValue(property, defaultValue)));
            }
            builder.addProperties((PropertyDescriptor)propertyBuilder.label(property.label()).checkboxLabel(property.checkboxLabel()).description(property.description()).build());
        }
        for (Annotation annotation : descriptor.advice()) {
            builder.addAdviceConfigs((AdviceConfig)ImmutableAdviceConfig.builder().className(annotation.className()).classAnnotation(annotation.classAnnotation()).subTypeRestriction(annotation.subTypeRestriction()).superTypeRestriction(annotation.superTypeRestriction()).methodName(annotation.methodName()).methodAnnotation(annotation.methodAnnotation()).addMethodParameterTypes(annotation.methodParameterTypes()).methodReturnType(annotation.methodReturnType()).addMethodModifiers(annotation.methodModifiers()).nestingGroup(annotation.nestingGroup()).order(annotation.order()).captureKind(annotation.captureKind()).transactionType(annotation.transactionType()).transactionNameTemplate(annotation.transactionNameTemplate()).transactionUserTemplate(annotation.transactionUserTemplate()).transactionSlowThresholdMillis(InstrumentationDescriptors.toNullableInteger(annotation.transactionSlowThresholdMillis())).alreadyInTransactionBehavior(annotation.alreadyInTransactionBehavior()).spanMessageTemplate(annotation.spanMessageTemplate()).spanStackThresholdMillis(InstrumentationDescriptors.toNullableInteger(annotation.spanStackThresholdMillis())).spanCaptureSelfNested(annotation.spanCaptureSelfNested()).timerName(annotation.timerName()).enabledProperty(annotation.enabledProperty()).localSpanEnabledProperty(annotation.localSpanEnabledProperty()).build());
        }
        for (Class<?> clazz : descriptor.classes()) {
            builder.addClasses(clazz.getName());
        }
        return builder.collocate(descriptor.collocate()).build();
    }

    private static List<URL> getResources(String resourceName) throws IOException {
        ClassLoader loader = InstrumentationDescriptors.class.getClassLoader();
        if (loader == null) {
            return ImmutableList.copyOf(Iterators.forEnumeration(ClassLoader.getSystemResources(resourceName)));
        }
        return ImmutableList.copyOf(Iterators.forEnumeration(loader.getResources(resourceName)));
    }

    private static Object getValue(Descriptor.Property property, Descriptor.DefaultValue defaultValue) {
        switch (property.type()) {
            case STRING: {
                return defaultValue.stringValue();
            }
            case BOOLEAN: {
                return defaultValue.booleanValue();
            }
            case DOUBLE: {
                return defaultValue.doubleValue();
            }
            case LIST: {
                return Arrays.asList(defaultValue.listValue());
            }
        }
        throw new IllegalStateException("Unexpected property type: " + (Object)((Object)property.type()));
    }

    @Nullable
    private static Integer toNullableInteger(int value) {
        return value == -1 ? null : Integer.valueOf(value);
    }
}

