/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.config;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.util.List;
import org.glowroot.instrumentation.api.Descriptor;
import org.glowroot.instrumentation.engine.config.DefaultValue;
import org.immutables.value.Value;

@Value.Immutable
public abstract class PropertyDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(PropertyDescriptor.class);

    public abstract String name();

    public abstract Descriptor.PropertyType type();

    @Nullable
    public abstract DefaultValue defaultValue();

    public abstract String label();

    @Value.Default
    public String checkboxLabel() {
        return "";
    }

    @Value.Default
    public String description() {
        return "";
    }

    public DefaultValue getValidatedNonNullDefaultValue() {
        DefaultValue defaultValue = this.defaultValue();
        if (defaultValue == null) {
            return PropertyDescriptor.getDefaultValue(this.type());
        }
        Object value = defaultValue.value();
        if (value == null) {
            return PropertyDescriptor.getDefaultValue(this.type());
        }
        if (PropertyDescriptor.isValidType(value, this.type())) {
            return new DefaultValue(value);
        }
        logger.warn("invalid default value for instrumentation property: {}", (Object)this.name());
        return PropertyDescriptor.getDefaultValue(this.type());
    }

    public static DefaultValue getDefaultValue(Descriptor.PropertyType type) {
        switch (type) {
            case BOOLEAN: {
                return new DefaultValue(false);
            }
            case DOUBLE: {
                return new DefaultValue(null);
            }
            case STRING: {
                return new DefaultValue("");
            }
            case LIST: {
                return new DefaultValue(ImmutableList.of());
            }
        }
        throw new AssertionError((Object)("Unexpected property type: " + (Object)((Object)type)));
    }

    public static boolean isValidType(Object value, Descriptor.PropertyType type) {
        switch (type) {
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case STRING: {
                return value instanceof String;
            }
            case DOUBLE: {
                return value instanceof Double;
            }
            case LIST: {
                return value instanceof List;
            }
        }
        throw new AssertionError((Object)("Unexpected property type: " + (Object)((Object)type)));
    }
}

