/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.impl;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.annotations.VisibleForTesting;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Strings;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.cache.CacheBuilder;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.cache.CacheLoader;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.cache.LoadingCache;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMap;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableSet;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Maps;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.config.ConfigService;
import org.glowroot.instrumentation.api.internal.InstrumentationService;
import org.glowroot.instrumentation.engine.bytecode.api.BytecodeServiceHolder;
import org.glowroot.instrumentation.engine.impl.TimerNameCache;
import org.glowroot.instrumentation.engine.weaving.Beans;

public class InstrumentationServiceImpl
implements InstrumentationService {
    private static final Logger logger = LoggerFactory.getLogger(InstrumentationServiceImpl.class);
    private final TimerNameCache timerNameCache;
    private final LoadingCache<String, ConfigService> configServices;

    public InstrumentationServiceImpl(TimerNameCache timerNameCache, final ConfigServiceFactory configServiceFactory) {
        this.timerNameCache = timerNameCache;
        this.configServices = CacheBuilder.newBuilder().build(new CacheLoader<String, ConfigService>(){

            @Override
            public ConfigService load(String instrumentationId) {
                return configServiceFactory.create(instrumentationId);
            }
        });
    }

    @Override
    public TimerName getTimerName(String name) {
        return this.timerNameCache.getTimerName(name);
    }

    @Override
    public ConfigService getConfigService(String instrumentationId) {
        return this.configServices.getUnchecked(instrumentationId);
    }

    @Override
    @Nullable
    public ThreadContext getThreadContext() {
        return BytecodeServiceHolder.get().getCurrentThreadContextHolder().get();
    }

    @Override
    public <E> List<E> toImmutableList(Collection<E> elements) {
        return ImmutableList.copyOf(elements);
    }

    @Override
    public <E> Set<E> toImmutableSet(Collection<E> elements) {
        return ImmutableSet.copyOf(elements);
    }

    @Override
    public <K, V> Map<K, V> toImmutableMap(Map<K, V> map) {
        return ImmutableMap.copyOf(map);
    }

    @Override
    @Nullable
    public Object getBeanValue(@Nullable Object obj, List<String> path) throws Exception {
        return Beans.value(obj, path);
    }

    @Override
    public Map<String, String> getBeanPropertiesAsText(Object obj) {
        return Beans2.propertiesAsText(obj);
    }

    @VisibleForTesting
    static class Beans2 {
        private static final LoadingCache<Class<?>, Map<String, Method>> wildcardGetters = CacheBuilder.newBuilder().weakKeys().build(new WildcardGettersCacheLoader());

        private Beans2() {
        }

        @VisibleForTesting
        static Map<String, String> propertiesAsText(Object obj) {
            HashMap<String, String> properties = Maps.newHashMap();
            Map<String, Method> allGettersForObj = wildcardGetters.getUnchecked(obj.getClass());
            for (Map.Entry<String, Method> entry : allGettersForObj.entrySet()) {
                try {
                    Object value = entry.getValue().invoke(obj, new Object[0]);
                    if (value == null) continue;
                    properties.put(entry.getKey(), Strings.nullToEmpty(value.toString()));
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), e);
                    properties.put(entry.getKey(), "<could not access>");
                }
            }
            return properties;
        }

        private static void sentinelMethod() {
        }

        private static class WildcardGettersCacheLoader
        extends CacheLoader<Class<?>, Map<String, Method>> {
            private WildcardGettersCacheLoader() {
            }

            @Override
            public Map<String, Method> load(Class<?> clazz) {
                HashMap<String, Method> propertyNames = Maps.newHashMap();
                for (Method method : clazz.getMethods()) {
                    Method otherMethod;
                    String propertyName = WildcardGettersCacheLoader.getPropertyName(method);
                    if (propertyName == null || (otherMethod = (Method)propertyNames.get(propertyName)) != null && otherMethod.getName().startsWith("get")) continue;
                    method.setAccessible(true);
                    propertyNames.put(propertyName, method);
                }
                return ImmutableMap.copyOf(propertyNames);
            }

            @Nullable
            private static String getPropertyName(Method method) {
                if (method.getParameterTypes().length > 0) {
                    return null;
                }
                String methodName = method.getName();
                if (methodName.equals("getClass")) {
                    return null;
                }
                if (WildcardGettersCacheLoader.startsWithAndThenUpperCaseChar(methodName, "get")) {
                    return WildcardGettersCacheLoader.getRemainingWithFirstCharLowercased(methodName, "get");
                }
                if (WildcardGettersCacheLoader.startsWithAndThenUpperCaseChar(methodName, "is")) {
                    return WildcardGettersCacheLoader.getRemainingWithFirstCharLowercased(methodName, "is");
                }
                return null;
            }

            private static boolean startsWithAndThenUpperCaseChar(String str, String prefix) {
                return str.startsWith(prefix) && str.length() > prefix.length() && Character.isUpperCase(str.charAt(prefix.length()));
            }

            private static String getRemainingWithFirstCharLowercased(String str, String prefix) {
                return Character.toLowerCase(str.charAt(prefix.length())) + str.substring(prefix.length() + 1);
            }
        }
    }

    public static interface ConfigServiceFactory {
        public ConfigService create(String var1);
    }
}

