/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.impl;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Joiner;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMap;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Maps;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glowroot.instrumentation.api.config.BooleanProperty;
import org.glowroot.instrumentation.api.config.ConfigListener;
import org.glowroot.instrumentation.api.config.ConfigService;
import org.glowroot.instrumentation.api.config.DoubleProperty;
import org.glowroot.instrumentation.api.config.ListProperty;
import org.glowroot.instrumentation.api.config.StringProperty;
import org.glowroot.instrumentation.engine.config.InstrumentationDescriptor;
import org.glowroot.instrumentation.engine.config.PropertyDescriptor;
import org.glowroot.instrumentation.engine.impl.InstrumentationServiceImpl;

public class SimpleConfigServiceFactory
implements InstrumentationServiceImpl.ConfigServiceFactory {
    private final List<InstrumentationDescriptor> instrumentationDescriptors;
    private final Map<String, Map<String, Object>> overrides;

    public SimpleConfigServiceFactory(List<InstrumentationDescriptor> instrumentationDescriptors) {
        this(instrumentationDescriptors, ImmutableMap.of());
    }

    public SimpleConfigServiceFactory(List<InstrumentationDescriptor> instrumentationDescriptors, Map<String, Map<String, Object>> overrides) {
        this.instrumentationDescriptors = instrumentationDescriptors;
        this.overrides = overrides;
    }

    @Override
    public ConfigService create(String instrumentationId) {
        InstrumentationDescriptor descriptor = SimpleConfigServiceFactory.getDescriptor(instrumentationId, this.instrumentationDescriptors);
        Map<String, Object> overrides = this.overrides.get(instrumentationId);
        if (overrides == null) {
            overrides = ImmutableMap.of();
        }
        return new ConfigServiceImpl(descriptor.properties(), overrides);
    }

    private static InstrumentationDescriptor getDescriptor(String id, List<InstrumentationDescriptor> descriptors) {
        for (InstrumentationDescriptor descriptor : descriptors) {
            if (!id.equals(descriptor.id())) continue;
            return descriptor;
        }
        if (descriptors.isEmpty()) {
            throw new IllegalStateException("Unexpected instrumentation id: " + id + " (there is no available instrumentation)");
        }
        ArrayList<String> ids = Lists.newArrayList();
        for (InstrumentationDescriptor descriptor : descriptors) {
            ids.add(descriptor.id());
        }
        throw new IllegalStateException("Unexpected instrumentation id: " + id + " (available instrumentation ids are " + Joiner.on(", ").join(ids) + ")");
    }

    private static class ListPropertyImpl
    implements ListProperty {
        private final List<String> value;

        private ListPropertyImpl(List<String> value) {
            this.value = value;
        }

        @Override
        public List<String> value() {
            return this.value;
        }
    }

    private static class DoublePropertyImpl
    implements DoubleProperty {
        @Nullable
        private final Double value;

        private DoublePropertyImpl(@Nullable Double value) {
            this.value = value;
        }

        @Override
        @Nullable
        public Double value() {
            return this.value;
        }
    }

    private static class BooleanPropertyImpl
    implements BooleanProperty {
        private final boolean value;

        private BooleanPropertyImpl(boolean value) {
            this.value = value;
        }

        @Override
        public boolean value() {
            return this.value;
        }
    }

    private static class StringPropertyImpl
    implements StringProperty {
        private final String value;

        private StringPropertyImpl(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }
    }

    private static class ConfigServiceImpl
    implements ConfigService {
        private final Map<String, StringProperty> stringProperties;
        private final Map<String, BooleanProperty> booleanProperties;
        private final Map<String, DoubleProperty> doubleProperties;
        private final Map<String, ListProperty> listProperties;

        private ConfigServiceImpl(List<PropertyDescriptor> propertyDescriptors, Map<String, Object> overrides) {
            HashMap<String, StringPropertyImpl> stringProperties = Maps.newHashMap();
            HashMap<String, BooleanPropertyImpl> booleanProperties = Maps.newHashMap();
            HashMap<String, DoublePropertyImpl> doubleProperties = Maps.newHashMap();
            HashMap<String, ListPropertyImpl> listProperties = Maps.newHashMap();
            block6: for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                String name = propertyDescriptor.name();
                Object value = overrides.containsKey(name) ? overrides.get(name) : propertyDescriptor.getValidatedNonNullDefaultValue().value();
                switch (propertyDescriptor.type()) {
                    case STRING: {
                        if (value instanceof String) {
                            stringProperties.put(name, new StringPropertyImpl((String)value));
                            continue block6;
                        }
                        throw ConfigServiceImpl.unexpectedValueType(name, "string", value);
                    }
                    case BOOLEAN: {
                        if (value instanceof Boolean) {
                            booleanProperties.put(name, new BooleanPropertyImpl((Boolean)value));
                            continue block6;
                        }
                        throw ConfigServiceImpl.unexpectedValueType(name, "boolean", value);
                    }
                    case DOUBLE: {
                        if (value == null) {
                            doubleProperties.put(name, new DoublePropertyImpl(null));
                            continue block6;
                        }
                        if (value instanceof Number) {
                            doubleProperties.put(name, new DoublePropertyImpl(((Number)value).doubleValue()));
                            continue block6;
                        }
                        throw ConfigServiceImpl.unexpectedValueType(name, "number", value);
                    }
                    case LIST: {
                        if (value instanceof List) {
                            ArrayList<String> stringList = Lists.newArrayList();
                            for (Object val : (List)value) {
                                if (val instanceof String) {
                                    stringList.add((String)val);
                                    continue;
                                }
                                throw ConfigServiceImpl.unexpectedValueTypeForList(name, val);
                            }
                            listProperties.put(name, new ListPropertyImpl(stringList));
                            continue block6;
                        }
                        throw ConfigServiceImpl.unexpectedValueType(name, "list", value);
                    }
                }
                throw new IllegalStateException("Unexpected property descriptor type: " + (Object)((Object)propertyDescriptor.type()));
            }
            this.stringProperties = ImmutableMap.copyOf(stringProperties);
            this.booleanProperties = ImmutableMap.copyOf(booleanProperties);
            this.doubleProperties = ImmutableMap.copyOf(doubleProperties);
            this.listProperties = ImmutableMap.copyOf(listProperties);
        }

        @Override
        public void registerConfigListener(ConfigListener listener) {
            listener.onChange();
        }

        @Override
        public StringProperty getStringProperty(String name) {
            StringProperty stringProperty = this.stringProperties.get(name);
            if (stringProperty == null) {
                throw new IllegalStateException("No such string property: " + name);
            }
            return stringProperty;
        }

        @Override
        public BooleanProperty getBooleanProperty(String name) {
            BooleanProperty booleanProperty = this.booleanProperties.get(name);
            if (booleanProperty == null) {
                throw new IllegalStateException("No such boolean property: " + name);
            }
            return booleanProperty;
        }

        @Override
        public DoubleProperty getDoubleProperty(String name) {
            DoubleProperty doubleProperty = this.doubleProperties.get(name);
            if (doubleProperty == null) {
                throw new IllegalStateException("No such double property: " + name);
            }
            return doubleProperty;
        }

        @Override
        public ListProperty getListProperty(String name) {
            ListProperty listProperty = this.listProperties.get(name);
            if (listProperty == null) {
                throw new IllegalStateException("No such list property: " + name);
            }
            return listProperty;
        }

        private static RuntimeException unexpectedValueType(String propertyName, String propertyType, @Nullable Object value) {
            String found = value == null ? "null" : value.getClass().getSimpleName();
            return new IllegalStateException("Unexpected value for " + propertyType + " property " + propertyName + ": " + found);
        }

        private static RuntimeException unexpectedValueTypeForList(String propertyName, @Nullable Object value) {
            String found = value == null ? "null" : value.getClass().getSimpleName();
            return new IllegalStateException("Unexpected value for element of list property " + propertyName + ": " + found);
        }
    }
}

