/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.init;

import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassReader;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassVisitor;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassWriter;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.MethodVisitor;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.AdviceAdapter;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import org.glowroot.instrumentation.engine.bytecode.api.BytecodeSafe;

class ManagementFactoryHackClassFileTransformer
implements ClassFileTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ManagementFactoryHackClassFileTransformer.class);

    ManagementFactoryHackClassFileTransformer() {
    }

    @Override
    public byte[] transform(@Nullable ClassLoader loader, @Nullable String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] bytes) {
        try {
            if ("java/lang/management/ManagementFactory".equals(className)) {
                ClassWriter cw = new ClassWriter(0);
                ManagementFactoryHackClassVisitor cv = new ManagementFactoryHackClassVisitor(cw);
                ClassReader cr = new ClassReader(bytes);
                cr.accept(cv, 8);
                return cw.toByteArray();
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        return null;
    }

    private static class ManagementFactoryHackMethodVisitor
    extends AdviceAdapter {
        private ManagementFactoryHackMethodVisitor(MethodVisitor mv, int access, String name, String descriptor) {
            super(458752, mv, access, name, descriptor);
        }

        @Override
        protected void onMethodExit(int opcode) {
            if (opcode != 191) {
                this.visitMethodInsn(184, Type.getType(BytecodeSafe.class).getInternalName(), "exitingGetPlatformMBeanServer", "()V", false);
            }
        }
    }

    private static class ManagementFactoryHackClassVisitor
    extends ClassVisitor {
        private final ClassWriter cw;

        private ManagementFactoryHackClassVisitor(ClassWriter cw) {
            super(458752, cw);
            this.cw = cw;
        }

        @Override
        @Nullable
        public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
            MethodVisitor mv = this.cw.visitMethod(access, name, descriptor, signature, exceptions);
            if (name.equals("getPlatformMBeanServer") && descriptor.equals("()Ljavax/management/MBeanServer;")) {
                return new ManagementFactoryHackMethodVisitor(mv, access, name, descriptor);
            }
            return mv;
        }
    }
}

