/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.init;

import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class PreCheckLoadedClasses {
    private static final String SHADE_PROOF_JUL_LOGGER_CLASS_NAME = "_java.util.logging.Logger".substring(1);
    private static final Set<String> IMPORTANT_CLASS_NAMES;
    private static final boolean CHECK_FOR_JUL_LOGGER;

    private PreCheckLoadedClasses() {
    }

    static boolean isImportantClass(String className, Class<?> clazz) {
        return IMPORTANT_CLASS_NAMES.contains(className) || PreCheckLoadedClasses.isImportantRunnableOrCallable(className, clazz) || className.equals("java.net.HttpURLConnection") || CHECK_FOR_JUL_LOGGER && className.equals(SHADE_PROOF_JUL_LOGGER_CLASS_NAME);
    }

    private static boolean isImportantRunnableOrCallable(String className, Class<?> clazz) {
        return className.startsWith("java.util.concurrent.") && !clazz.isInterface() && (Runnable.class.isAssignableFrom(clazz) || Callable.class.isAssignableFrom(clazz));
    }

    static /* synthetic */ String access$000() {
        return SHADE_PROOF_JUL_LOGGER_CLASS_NAME;
    }

    static {
        CHECK_FOR_JUL_LOGGER = System.getProperty("test.harness.tmpDir") != null;
        List<String> importantClassNames = Arrays.asList("org/jboss/weld/util/Decorators".replace('/', '.'), "org/jboss/net/protocol/URLStreamHandlerFactory".replace('/', '.'));
        IMPORTANT_CLASS_NAMES = new HashSet<String>(importantClassNames);
    }

    public static class PreCheckClassFileTransformer
    implements ClassFileTransformer {
        @MonotonicNonNull
        private static volatile Logger logger;
        private final Set<String> importantInternalNames;
        private final String shadeProofJulLoggerInternalName = PreCheckLoadedClasses.access$000().replace('.', '/');
        private final Map<String, Exception> importantClassLoadingPoints = new ConcurrentHashMap<String, Exception>();

        public PreCheckClassFileTransformer() {
            ArrayList<String> internalNames = new ArrayList<String>();
            for (String className : IMPORTANT_CLASS_NAMES) {
                internalNames.add(className.replace('.', '/'));
            }
            this.importantInternalNames = new HashSet<String>(internalNames);
        }

        public Map<String, Exception> getImportantClassLoadingPoints() {
            return this.importantClassLoadingPoints;
        }

        @Override
        public byte[] transform(@Nullable ClassLoader loader, @Nullable String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] bytes) {
            try {
                if (className == null) {
                    return null;
                }
                if (this.importantInternalNames.contains(className) || className.equals("java/net/HttpURLConnection") || CHECK_FOR_JUL_LOGGER && className.equals(this.shadeProofJulLoggerInternalName)) {
                    this.importantClassLoadingPoints.put(className.replace('/', '.'), new Exception("location stack trace"));
                }
            }
            catch (Throwable t) {
                if (logger == null) {
                    t.printStackTrace();
                }
                logger.error(t.getMessage(), t);
            }
            return null;
        }

        static void initLogger() {
            logger = LoggerFactory.getLogger(PreCheckLoadedClasses.class);
        }
    }
}

