/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.init;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.annotations.VisibleForTesting;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

class PreInitializeWeavingClasses {
    private static final Logger logger = LoggerFactory.getLogger(PreInitializeWeavingClasses.class);
    @Nullable
    public static volatile Object toPreventDeadCodeElimination;

    private PreInitializeWeavingClasses() {
    }

    static void preInitializeClasses() {
        ClassLoader loader = PreInitializeWeavingClasses.class.getClassLoader();
        for (String type : PreInitializeWeavingClasses.usedTypes()) {
            PreInitializeWeavingClasses.initialize(type, loader, true);
        }
        if (PreInitializeWeavingClasses.isGuavaPriorTo24()) {
            for (String type : PreInitializeWeavingClasses.getGuava20UsedTypes()) {
                PreInitializeWeavingClasses.initialize(type, loader, true);
            }
        } else {
            for (String type : PreInitializeWeavingClasses.getGuava27UsedTypes()) {
                PreInitializeWeavingClasses.initialize(type, loader, true);
            }
        }
        for (String type : PreInitializeWeavingClasses.maybeUsedTypes()) {
            PreInitializeWeavingClasses.initialize(type, loader, false);
        }
        for (String type : PreInitializeWeavingClasses.javaUsedTypes()) {
            PreInitializeWeavingClasses.initialize(type, loader, false);
        }
        PreInitializeWeavingClasses.preInitializeLinkedHashMapKeySetAndKeySetIterator();
    }

    private static void initialize(String type, @Nullable ClassLoader loader, boolean warnOnNotExists) {
        try {
            Class.forName(type, true, loader);
        }
        catch (ClassNotFoundException e) {
            if (warnOnNotExists) {
                logger.warn("class not found: {}", (Object)type);
            }
            logger.trace(e.getMessage(), e);
        }
    }

    @VisibleForTesting
    static List<String> usedTypes() {
        ArrayList<String> types = Lists.newArrayList();
        types.addAll(PreInitializeWeavingClasses.getGuavaUsedTypes());
        types.addAll(PreInitializeWeavingClasses.getEngineUsedTypes());
        types.addAll(PreInitializeWeavingClasses.getInstrumentationApiUsedTypes());
        types.addAll(PreInitializeWeavingClasses.getAsmUsedTypes());
        return types;
    }

    private static List<String> getGuavaUsedTypes() {
        ArrayList<String> types = Lists.newArrayList();
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Charsets");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.ExtraObjectsMethodsForWeb");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Function");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Joiner");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects$ToStringHelper");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects$ToStringHelper$ValueHolder");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Objects");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.PatternCompiler");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Platform");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Platform$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Platform$JdkPatternCompiler");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.StandardSystemProperty");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Supplier");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Throwables");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Ticker");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Ticker$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.AbstractIndexedListIterator");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ByFunctionOrdering");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.CollectPreconditions");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Collections2");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ComparatorOrdering");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Hashing");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableCollection");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableCollection$ArrayBasedBuilder");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableCollection$Builder");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList$Builder");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList$ReverseImmutableList");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList$SubList");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMap");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMap$Builder");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableSet");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableSet$Builder");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Iterables");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Iterators");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists$RandomAccessReverseList");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists$ReverseList");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists$ReverseList$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Maps");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Maps$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Maps$EntryFunction");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Maps$EntryFunction$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Maps$EntryFunction$2");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ObjectArrays");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Ordering");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Platform");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableList");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableMap");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableMap$KeySet");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableSet");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Sets");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SingletonImmutableSet");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.TransformedIterator");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.TreeTraverser");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.UnmodifiableIterator");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.UnmodifiableListIterator");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.ByteSink");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.ByteSource");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.ByteStreams");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.ByteStreams$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Closeables");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Closer");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Closer$LoggingSuppressor");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Closer$SuppressingSuppressor");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Closer$Suppressor");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Files");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Files$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Files$2");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Files$FileByteSink");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.FileWriteMode");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.LineProcessor");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Resources");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Resources$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Resources$UrlByteSource");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.primitives.Booleans");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.primitives.Bytes");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.primitives.Ints");
        return types;
    }

    @VisibleForTesting
    public static List<String> getGuava20UsedTypes() {
        ArrayList<String> types = Lists.newArrayList();
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Joiner$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Joiner$MapJoiner");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Predicate");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Predicates");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Predicates$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Predicates$IsEqualToPredicate");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Predicates$ObjectPredicate");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Predicates$ObjectPredicate$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Predicates$ObjectPredicate$2");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Predicates$ObjectPredicate$3");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Predicates$ObjectPredicate$4");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.AbstractMapEntry");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.BiMap");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.DescendingImmutableSortedSet");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableAsList");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableBiMap");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableEntry");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableEnumMap");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableEnumSet");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMap$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMap$IteratorBasedImmutableMap");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMap$IteratorBasedImmutableMap$1EntrySetImpl");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMapEntry");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMapEntry$NonTerminalImmutableMapEntry");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMapEntrySet");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMapEntrySet$RegularEntrySet");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMapKeySet");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMapValues");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMapValues$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMapValues$2");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableSet$Indexed");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableSet$Indexed$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableSortedAsList");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableSortedMap");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableSortedMap$1EntrySet");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableSortedMap$1EntrySet$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableSortedMapFauxverideShim");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableSortedSet");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableSortedSetFauxverideShim");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Iterators$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Iterators$10");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Iterators$11");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Iterators$2");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Iterators$3");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Iterators$PeekingImpl");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Maps$5");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Maps$6");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Multiset");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.NaturalOrdering");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.PeekingIterator");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableAsList");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableBiMap");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableBiMap$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableBiMap$Inverse");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableBiMap$Inverse$InverseEntrySet");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableBiMap$Inverse$InverseEntrySet$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableMap$Values");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableSortedSet");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ReverseNaturalOrdering");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ReverseOrdering");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SingletonImmutableBiMap");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SingletonImmutableList");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SortedIterable");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SortedIterables");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SortedLists");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SortedLists$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SortedLists$KeyAbsentBehavior");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SortedLists$KeyAbsentBehavior$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SortedLists$KeyAbsentBehavior$2");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SortedLists$KeyAbsentBehavior$3");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SortedLists$KeyPresentBehavior");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SortedLists$KeyPresentBehavior$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SortedLists$KeyPresentBehavior$2");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SortedLists$KeyPresentBehavior$3");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SortedLists$KeyPresentBehavior$4");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.SortedLists$KeyPresentBehavior$5");
        return types;
    }

    @VisibleForTesting
    public static List<String> getGuava27UsedTypes() {
        ArrayList<String> types = Lists.newArrayList();
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Absent");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Optional");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Strings");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList$Itr");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Iterators$9");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableMap$EntrySet");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableMap$EntrySet$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.RegularImmutableMap$KeysOrValuesAsList");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Files$3");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.graph.SuccessorsFunction");
        types.add("com.microsoft.applicationinsights.agent.shadow.com.google.common.math.IntMath");
        return types;
    }

    private static List<String> getEngineUsedTypes() {
        ArrayList<String> types = Lists.newArrayList();
        types.add("org.glowroot.instrumentation.engine.bytecode.api.Bytecode");
        types.add("org.glowroot.instrumentation.engine.bytecode.api.BytecodeService");
        types.add("org.glowroot.instrumentation.engine.bytecode.api.BytecodeServiceHolder");
        types.add("org.glowroot.instrumentation.engine.bytecode.api.ThreadContextPlus");
        types.add("org.glowroot.instrumentation.engine.bytecode.api.ThreadContextThreadLocal$Holder");
        types.add("org.glowroot.instrumentation.engine.bytecode.api.Util");
        types.add("org.glowroot.instrumentation.engine.config.ImmutableAdviceConfig");
        types.add("org.glowroot.instrumentation.engine.config.ImmutableAdviceConfig$Builder");
        types.add("org.glowroot.instrumentation.engine.config.ImmutableAdviceConfig$InitShim");
        types.add("org.glowroot.instrumentation.engine.config.AdviceConfig");
        types.add("org.glowroot.instrumentation.engine.util.IterableWithSelfRemovableEntries");
        types.add("org.glowroot.instrumentation.engine.util.IterableWithSelfRemovableEntries$ElementIterator");
        types.add("org.glowroot.instrumentation.engine.util.IterableWithSelfRemovableEntries$Entry");
        types.add("org.glowroot.instrumentation.engine.util.IterableWithSelfRemovableEntries$SelfRemovableEntry");
        types.add("org.glowroot.instrumentation.engine.weaving.Advice");
        types.add("org.glowroot.instrumentation.engine.weaving.AdviceGenerator");
        types.add("org.glowroot.instrumentation.engine.weaving.Advice$AdviceOrdering");
        types.add("org.glowroot.instrumentation.engine.weaving.Advice$AdviceParameter");
        types.add("org.glowroot.instrumentation.engine.weaving.Advice$ParameterKind");
        types.add("org.glowroot.instrumentation.engine.weaving.AdviceAdapter");
        types.add("org.glowroot.instrumentation.engine.weaving.AdviceBuilder");
        types.add("org.glowroot.instrumentation.engine.weaving.AdviceBuilder$AdviceConstructionException");
        types.add("org.glowroot.instrumentation.engine.weaving.AdviceMatcher");
        types.add("org.glowroot.instrumentation.engine.weaving.AnalyzedClass");
        types.add("org.glowroot.instrumentation.engine.weaving.AnalyzedMethod");
        types.add("org.glowroot.instrumentation.engine.weaving.AnalyzedWorld");
        types.add("org.glowroot.instrumentation.engine.weaving.AnalyzedWorld$AnalyzedClassAndLoader");
        types.add("org.glowroot.instrumentation.engine.weaving.AnalyzedWorld$ParseContext");
        types.add("org.glowroot.instrumentation.engine.weaving.BootstrapMetaHolders");
        types.add("org.glowroot.instrumentation.engine.weaving.BootstrapMetaHolders$ClassMetaHolder");
        types.add("org.glowroot.instrumentation.engine.weaving.BootstrapMetaHolders$MethodMetaHolder");
        types.add("org.glowroot.instrumentation.engine.weaving.ClassAnalyzer");
        types.add("org.glowroot.instrumentation.engine.weaving.ClassAnalyzer$AnalyzedMethodKey");
        types.add("org.glowroot.instrumentation.engine.weaving.ClassAnalyzer$BridgeMethodClassVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.ClassAnalyzer$BridgeMethodClassVisitor$BridgeMethodVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.ClassAnalyzer$MatchedMixinTypes");
        types.add("org.glowroot.instrumentation.engine.weaving.ClassAnalyzer$NonAbstractMethodClassVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.ClassInfoImpl");
        types.add("org.glowroot.instrumentation.engine.weaving.ClassLoaders");
        types.add("org.glowroot.instrumentation.engine.weaving.ClassLoaders$LazyDefinedClass");
        types.add("org.glowroot.instrumentation.engine.weaving.ClassNames");
        types.add("org.glowroot.instrumentation.engine.weaving.FrameDeduppingMethodVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.MethodInfoImpl");
        types.add("org.glowroot.instrumentation.engine.weaving.Weaver$ActiveWeaving");
        types.add("org.glowroot.instrumentation.engine.weaving.Weaver$ClassLoaderHackClassVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.Weaver$ClassLoaderHackMethodVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.Weaver$JBossUrlHackClassVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.Weaver$JBossUrlHackMethodVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.Weaver$JBossWeldHackClassVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.Weaver$JBossWeldHackMethodVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAdvice");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAdvice$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAdvice$InitShim");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAnalyzedClassAndLoader");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAnalyzedClassAndLoader$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutablePointcutClass");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutablePointcutClass$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutablePointcutMethod");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutablePointcutMethod$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAdviceMatcher");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAdviceMatcher$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAdviceParameter");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAdviceParameter$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAnalyzedClass");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAnalyzedClass$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAnalyzedMethod");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAnalyzedMethod$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAnalyzedMethodKey");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAnalyzedMethodKey$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableBindAnnotation");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableBindAnnotation$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableCatchHandler");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableCatchHandler$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableMatchedMixinTypes");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableMatchedMixinTypes$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableMethodMetaGroup");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableMethodMetaGroup$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableParseContext");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableParseContext$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutablePublicFinalMethod");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutablePublicFinalMethod$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableThinClass");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableThinClass$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableThinMethod");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableThinMethod$Builder");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationSeekerClassVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationSeekerClassVisitor$InstrumentationAnnotationMethodVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationSeekerClassVisitor$TimerAnnotationVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationSeekerClassVisitor$LocalSpanAnnotationVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationSeekerClassVisitor$TransactionAnnotationVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.JSRInlinerClassVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.MaybePatterns");
        types.add("org.glowroot.instrumentation.engine.weaving.MixinType");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationClassRenamer");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationClassRenamer$InstrumentationClassRemapper");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationDetail$BindAnnotation");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationDetail$PointcutClass");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationDetail$PointcutMethod");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationDetailBuilder");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationDetailBuilder$BindAnnotationVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationDetailBuilder$MemberClassVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationDetailBuilder$MixinMethodVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationDetailBuilder$PointcutMethodVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationDetailBuilder$MethodModifierArrayAnnotationVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationDetailBuilder$MixinAnnotationVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationDetailBuilder$PointcutAnnotationVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationDetailBuilder$PointcutAnnotationVisitor$1");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationDetailBuilder$StringArrayAnnotationVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.PreloadSomeSuperTypesCache");
        types.add("org.glowroot.instrumentation.engine.weaving.PreloadSomeSuperTypesCache$CacheValue");
        types.add("org.glowroot.instrumentation.engine.weaving.PublicFinalMethod");
        types.add("org.glowroot.instrumentation.engine.weaving.ShimType");
        types.add("org.glowroot.instrumentation.engine.weaving.ThinClassVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.ThinClassVisitor$AnnotationCaptureMethodVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.ThinClassVisitor$RemoteAnnotationVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.ThinClassVisitor$ValueAnnotationVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.ThinClassVisitor$ThinClass");
        types.add("org.glowroot.instrumentation.engine.weaving.ThinClassVisitor$ThinMethod");
        types.add("org.glowroot.instrumentation.engine.weaving.Weaver");
        types.add("org.glowroot.instrumentation.engine.weaving.WeavingClassFileTransformer");
        types.add("org.glowroot.instrumentation.engine.weaving.WeavingClassVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.WeavingClassVisitor$InitMixins");
        types.add("org.glowroot.instrumentation.engine.weaving.WeavingClassVisitor$MethodMetaGroup");
        types.add("org.glowroot.instrumentation.engine.weaving.WeavingMethodVisitor");
        types.add("org.glowroot.instrumentation.engine.weaving.WeavingMethodVisitor$CatchHandler");
        return types;
    }

    private static List<String> getInstrumentationApiUsedTypes() {
        ArrayList<String> types = Lists.newArrayList();
        types.add("org.glowroot.instrumentation.api.ClassInfo");
        types.add("org.glowroot.instrumentation.api.Descriptor$CaptureKind");
        types.add("org.glowroot.instrumentation.api.MethodInfo");
        types.add("org.glowroot.instrumentation.api.OptionalThreadContext");
        types.add("org.glowroot.instrumentation.api.OptionalThreadContext$AlreadyInTransactionBehavior");
        types.add("org.glowroot.instrumentation.api.ParameterHolder");
        types.add("org.glowroot.instrumentation.api.ThreadContext");
        types.add("org.glowroot.instrumentation.api.internal.ParameterHolderImpl");
        types.add("org.glowroot.instrumentation.api.weaving.Bind$ClassMeta");
        types.add("org.glowroot.instrumentation.api.weaving.Bind$MethodMeta");
        types.add("org.glowroot.instrumentation.api.weaving.Bind$MethodName");
        types.add("org.glowroot.instrumentation.api.weaving.Bind$OptionalReturn");
        types.add("org.glowroot.instrumentation.api.weaving.Bind$Argument");
        types.add("org.glowroot.instrumentation.api.weaving.Bind$AllArguments");
        types.add("org.glowroot.instrumentation.api.weaving.Bind$This");
        types.add("org.glowroot.instrumentation.api.weaving.Bind$Return");
        types.add("org.glowroot.instrumentation.api.weaving.Bind$Thrown");
        types.add("org.glowroot.instrumentation.api.weaving.Bind$Enter");
        types.add("org.glowroot.instrumentation.api.weaving.Bind$Special");
        types.add("org.glowroot.instrumentation.api.weaving.Advice$IsEnabled");
        types.add("org.glowroot.instrumentation.api.weaving.Advice$MethodModifier");
        types.add("org.glowroot.instrumentation.api.weaving.Advice$OnMethodAfter");
        types.add("org.glowroot.instrumentation.api.weaving.Advice$OnMethodBefore");
        types.add("org.glowroot.instrumentation.api.weaving.Advice$OnMethodReturn");
        types.add("org.glowroot.instrumentation.api.weaving.Advice$OnMethodThrow");
        types.add("org.glowroot.instrumentation.api.weaving.Advice$Pointcut");
        types.add("org.glowroot.instrumentation.api.weaving.Shim");
        return types;
    }

    private static List<String> getAsmUsedTypes() {
        ArrayList<String> types = Lists.newArrayList();
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.AnnotationVisitor");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.AnnotationWriter");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Attribute");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Attribute$Set");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ByteVector");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassReader");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassTooLargeException");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassVisitor");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassWriter");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ConstantDynamic");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Context");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.CurrentFrame");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Edge");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.FieldVisitor");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.FieldWriter");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Frame");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Handle");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Handler");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Label");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.MethodTooLargeException");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.MethodVisitor");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.MethodWriter");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ModuleVisitor");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ModuleWriter");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Opcodes");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Symbol");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.SymbolTable");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.SymbolTable$Entry");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.TypePath");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.TypeReference");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.AdviceAdapter");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.AnnotationRemapper");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.ClassRemapper");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.FieldRemapper");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.GeneratorAdapter");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.InstructionAdapter");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.JSRInlinerAdapter");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.JSRInlinerAdapter$Instantiation");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.LocalVariablesSorter");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.Method");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.MethodRemapper");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.ModuleRemapper");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.ModuleHashesAttribute");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.Remapper");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.SignatureRemapper");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.SimpleRemapper");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.signature.SignatureReader");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.signature.SignatureVisitor");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.signature.SignatureWriter");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.AbstractInsnNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.AnnotationNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.ClassNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.FieldInsnNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.FieldNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.FrameNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.IincInsnNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.InnerClassNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.InsnList");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.InsnList$InsnListIterator");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.InsnNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.IntInsnNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.InvokeDynamicInsnNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.JumpInsnNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.LabelNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.LdcInsnNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.LineNumberNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.LocalVariableAnnotationNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.LocalVariableNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.LookupSwitchInsnNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.MethodInsnNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.MethodNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.MethodNode$1");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.ModuleExportNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.ModuleNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.ModuleOpenNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.ModuleProvideNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.ModuleRequireNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.MultiANewArrayInsnNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.ParameterNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.TableSwitchInsnNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.TryCatchBlockNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.TypeAnnotationNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.TypeInsnNode");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.Util");
        types.add("com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.tree.VarInsnNode");
        return types;
    }

    @VisibleForTesting
    public static List<String> maybeUsedTypes() {
        ArrayList<String> types = Lists.newArrayList();
        types.add("org.glowroot.instrumentation.engine.config.ImmutableAdviceConfig$1");
        types.add("org.glowroot.instrumentation.engine.util.IterableWithSelfRemovableEntries$1");
        types.add("org.glowroot.instrumentation.engine.weaving.Advice$1");
        types.add("org.glowroot.instrumentation.engine.weaving.AdviceBuilder$1");
        types.add("org.glowroot.instrumentation.engine.weaving.AnalyzedClass$1");
        types.add("org.glowroot.instrumentation.engine.weaving.AnalyzedMethod$1");
        types.add("org.glowroot.instrumentation.engine.weaving.AnalyzedMethodKey$1");
        types.add("org.glowroot.instrumentation.engine.weaving.BootstrapMetaHolders$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ClassAnalyzer$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ClassAnalyzer$BridgeMethodClassVisitor$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutablePointcutClass$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutablePointcutMethod$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAnalyzedClass$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAnalyzedClassAndLoader$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAnalyzedMethod$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAnalyzedMethodKey$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAdvice$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAdviceMatcher$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableAdviceParameter$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableBindAnnotation$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableCatchHandler$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableLazyDefinedClass$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableMatchedMixinTypes$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableMethodMetaGroup$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableParseContext$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutablePublicFinalMethod$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableThinClass$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ImmutableThinMethod$1");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationSeekerClassVisitor$1");
        types.add("org.glowroot.instrumentation.engine.weaving.MethodMetaGroup$1");
        types.add("org.glowroot.instrumentation.engine.weaving.ThinClassVisitor$1");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationClassRenamer$1");
        types.add("org.glowroot.instrumentation.engine.weaving.InstrumentationDetailBuilder$1");
        types.add("org.glowroot.instrumentation.engine.weaving.Weaver$1");
        types.add("org.glowroot.instrumentation.engine.weaving.Weaver$2");
        types.add("org.glowroot.instrumentation.engine.weaving.Weaver$FelixOsgiHackClassVisitor$1");
        types.add("org.glowroot.instrumentation.engine.weaving.Weaver$EclipseOsgiHackClassVisitor$1");
        types.add("org.glowroot.instrumentation.engine.weaving.WeavingClassVisitor$1");
        types.add("org.glowroot.instrumentation.engine.weaving.AdviceMatcher$1");
        types.add("org.glowroot.instrumentation.engine.weaving.WeavingMethodVisitor$1");
        types.add("org.glowroot.instrumentation.engine.weaving.PreloadSomeSuperTypesCache$1");
        types.add("org.glowroot.instrumentation.api.config.ConfigListener");
        return types;
    }

    private static List<String> javaUsedTypes() {
        ArrayList<String> types = Lists.newArrayList();
        types.add("java.util.concurrent.ThreadLocalRandom");
        return types;
    }

    private static void preInitializeLinkedHashMapKeySetAndKeySetIterator() {
        toPreventDeadCodeElimination = new LinkedHashMap().keySet().iterator();
    }

    @VisibleForTesting
    static boolean isGuavaPriorTo24() {
        try {
            Class.forName("com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.BinaryTreeTraverser");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

