/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableSet;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Ordering;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Sets;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.primitives.Ints;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.engine.weaving.ClassLoaders;
import org.immutables.value.Value;

@Value.Immutable
abstract class Advice {
    static final Ordering<Advice> ordering = new AdviceOrdering();

    Advice() {
    }

    abstract Advice.Pointcut pointcut();

    abstract Type adviceType();

    @Nullable
    abstract Pattern pointcutClassNamePattern();

    @Nullable
    abstract Pattern pointcutClassAnnotationPattern();

    @Nullable
    abstract Pattern pointcutSubTypeRestrictionPattern();

    @Nullable
    abstract Pattern pointcutSuperTypeRestrictionPattern();

    @Nullable
    abstract Pattern pointcutMethodNamePattern();

    @Nullable
    abstract Pattern pointcutMethodAnnotationPattern();

    abstract List<Object> pointcutMethodParameterTypes();

    @Nullable
    abstract Type travelerType();

    @Nullable
    abstract Method isEnabledAdvice();

    @Nullable
    abstract Method onBeforeAdvice();

    @Nullable
    abstract Method onReturnAdvice();

    @Nullable
    abstract Method onThrowAdvice();

    @Nullable
    abstract Method onAfterAdvice();

    abstract ImmutableList<AdviceParameter> isEnabledParameters();

    abstract ImmutableList<AdviceParameter> onBeforeParameters();

    abstract ImmutableList<AdviceParameter> onReturnParameters();

    abstract ImmutableList<AdviceParameter> onThrowParameters();

    abstract ImmutableList<AdviceParameter> onAfterParameters();

    abstract boolean hasBindThreadContext();

    abstract boolean hasBindOptionalThreadContext();

    abstract boolean reweavable();

    @Nullable
    abstract Advice nonBootstrapLoaderAdvice();

    @Nullable
    abstract ClassLoaders.LazyDefinedClass nonBootstrapLoaderAdviceClass();

    @Value.Derived
    ImmutableSet<Type> classMetaTypes() {
        HashSet<Type> metaTypes = Sets.newHashSet();
        metaTypes.addAll(Advice.getClassMetaTypes(this.isEnabledParameters()));
        metaTypes.addAll(Advice.getClassMetaTypes(this.onBeforeParameters()));
        metaTypes.addAll(Advice.getClassMetaTypes(this.onReturnParameters()));
        metaTypes.addAll(Advice.getClassMetaTypes(this.onThrowParameters()));
        metaTypes.addAll(Advice.getClassMetaTypes(this.onAfterParameters()));
        return ImmutableSet.copyOf(metaTypes);
    }

    @Value.Derived
    ImmutableSet<Type> methodMetaTypes() {
        HashSet<Type> metaTypes = Sets.newHashSet();
        metaTypes.addAll(Advice.getMethodMetaTypes(this.isEnabledParameters()));
        metaTypes.addAll(Advice.getMethodMetaTypes(this.onBeforeParameters()));
        metaTypes.addAll(Advice.getMethodMetaTypes(this.onReturnParameters()));
        metaTypes.addAll(Advice.getMethodMetaTypes(this.onThrowParameters()));
        metaTypes.addAll(Advice.getMethodMetaTypes(this.onAfterParameters()));
        return ImmutableSet.copyOf(metaTypes);
    }

    private static Set<Type> getClassMetaTypes(List<AdviceParameter> parameters) {
        HashSet<Type> types = Sets.newHashSet();
        for (AdviceParameter parameter : parameters) {
            if (parameter.kind() != ParameterKind.CLASS_META) continue;
            types.add(parameter.type());
        }
        return types;
    }

    private static Set<Type> getMethodMetaTypes(List<AdviceParameter> parameters) {
        HashSet<Type> types = Sets.newHashSet();
        for (AdviceParameter parameter : parameters) {
            if (parameter.kind() != ParameterKind.METHOD_META) continue;
            types.add(parameter.type());
        }
        return types;
    }

    @Value.Immutable
    static interface AdviceParameter {
        public ParameterKind kind();

        public Type type();

        public int argIndex();
    }

    private static class AdviceOrdering
    extends Ordering<Advice> {
        private AdviceOrdering() {
        }

        @Override
        public int compare(Advice left, Advice right) {
            return Ints.compare(left.pointcut().order(), right.pointcut().order());
        }
    }

    static enum ParameterKind {
        RECEIVER,
        METHOD_ARG,
        METHOD_ARG_ARRAY,
        METHOD_NAME,
        RETURN,
        OPTIONAL_RETURN,
        THROWABLE,
        TRAVELER,
        CLASS_META,
        METHOD_META,
        THREAD_CONTEXT,
        OPTIONAL_THREAD_CONTEXT,
        SPECIAL;

    }
}

