/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Joiner;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMap;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.glowroot.instrumentation.api.OptionalThreadContext;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.engine.weaving.Advice;
import org.glowroot.instrumentation.engine.weaving.ClassLoaders;
import org.glowroot.instrumentation.engine.weaving.ImmutableAdvice;
import org.glowroot.instrumentation.engine.weaving.ImmutableAdviceParameter;
import org.glowroot.instrumentation.engine.weaving.InstrumentationClassRenamer;
import org.glowroot.instrumentation.engine.weaving.InstrumentationDetail;
import org.glowroot.instrumentation.engine.weaving.InstrumentationDetailBuilder;
import org.glowroot.instrumentation.engine.weaving.MaybePatterns;

class AdviceBuilder {
    private static final Type IsEnabledType = Type.getType(Advice.IsEnabled.class);
    private static final Type OnBeforeType = Type.getType(Advice.OnMethodBefore.class);
    private static final Type OnReturnType = Type.getType(Advice.OnMethodReturn.class);
    private static final Type OnThrowType = Type.getType(Advice.OnMethodThrow.class);
    private static final Type OnAfterType = Type.getType(Advice.OnMethodAfter.class);
    private static final Type ThreadContextType = Type.getType(ThreadContext.class);
    private static final Type OptionalThreadContextType = Type.getType(OptionalThreadContext.class);
    private static final Type BindReceiverType = Type.getType(Bind.This.class);
    private static final Type BindParameterType = Type.getType(Bind.Argument.class);
    private static final Type BindParameterArrayType = Type.getType(Bind.AllArguments.class);
    private static final Type BindMethodNameType = Type.getType(Bind.MethodName.class);
    private static final Type BindReturnType = Type.getType(Bind.Return.class);
    private static final Type BindOptionalReturnType = Type.getType(Bind.OptionalReturn.class);
    private static final Type BindThrowableType = Type.getType(Bind.Thrown.class);
    private static final Type BindTravelerType = Type.getType(Bind.Enter.class);
    private static final Type BindClassMetaType = Type.getType(Bind.ClassMeta.class);
    private static final Type BindMethodMetaType = Type.getType(Bind.MethodMeta.class);
    private static final Type BindSpecialType = Type.getType(Bind.Special.class);
    private static final Type StringType = Type.getType(String.class);
    private static final Type ThrowableType = Type.getType(Throwable.class);
    private static final ImmutableList<Type> isEnabledBindAnnotationTypes = ImmutableList.of(BindReceiverType, BindParameterType, BindParameterArrayType, BindMethodNameType, BindClassMetaType, BindMethodMetaType);
    private static final ImmutableList<Type> onBeforeBindAnnotationTypes = ImmutableList.of(BindReceiverType, BindParameterType, BindParameterArrayType, BindMethodNameType, BindClassMetaType, BindMethodMetaType, BindSpecialType);
    private static final ImmutableList<Type> onReturnBindAnnotationTypes = ImmutableList.of(BindReceiverType, BindParameterType, BindParameterArrayType, BindMethodNameType, BindReturnType, BindOptionalReturnType, BindTravelerType, BindClassMetaType, BindMethodMetaType);
    private static final ImmutableList<Type> onThrowBindAnnotationTypes = ImmutableList.of(BindReceiverType, BindParameterType, BindParameterArrayType, BindMethodNameType, BindThrowableType, BindTravelerType, BindClassMetaType, BindMethodMetaType);
    private static final ImmutableList<Type> onAfterBindAnnotationTypes = ImmutableList.of(BindReceiverType, BindParameterType, BindParameterArrayType, BindMethodNameType, BindReturnType, BindThrowableType, BindTravelerType, BindClassMetaType, BindMethodMetaType);
    private static final ImmutableMap<Type, Advice.ParameterKind> parameterKindMap = new ImmutableMap.Builder<Type, Advice.ParameterKind>().put(BindReceiverType, Advice.ParameterKind.RECEIVER).put(BindParameterType, Advice.ParameterKind.METHOD_ARG).put(BindParameterArrayType, Advice.ParameterKind.METHOD_ARG_ARRAY).put(BindMethodNameType, Advice.ParameterKind.METHOD_NAME).put(BindReturnType, Advice.ParameterKind.RETURN).put(BindOptionalReturnType, Advice.ParameterKind.OPTIONAL_RETURN).put(BindThrowableType, Advice.ParameterKind.THROWABLE).put(BindTravelerType, Advice.ParameterKind.TRAVELER).put(BindClassMetaType, Advice.ParameterKind.CLASS_META).put(BindMethodMetaType, Advice.ParameterKind.METHOD_META).put(BindSpecialType, Advice.ParameterKind.SPECIAL).build();
    private final ImmutableAdvice.Builder builder = ImmutableAdvice.builder();
    @Nullable
    private final InstrumentationDetail.PointcutClass adviceClass;
    @Nullable
    private final ClassLoaders.LazyDefinedClass lazyAdviceClass;
    private boolean hasIsEnabledAdvice;
    private boolean hasOnBeforeAdvice;
    private boolean hasOnReturnAdvice;
    private boolean hasOnThrowAdvice;
    private boolean hasOnAfterAdvice;

    AdviceBuilder(InstrumentationDetail.PointcutClass adviceClass) {
        this.adviceClass = adviceClass;
        this.lazyAdviceClass = null;
        this.builder.reweavable(false);
    }

    AdviceBuilder(ClassLoaders.LazyDefinedClass lazyAdviceClass, boolean reweavable) {
        this.adviceClass = null;
        this.lazyAdviceClass = lazyAdviceClass;
        this.builder.reweavable(reweavable);
    }

    Advice build() throws Exception {
        return this.build(new HashMap<String, ClassLoaders.LazyDefinedClass>());
    }

    Advice build(Map<String, ClassLoaders.LazyDefinedClass> collocatedClassCache) throws Exception {
        InstrumentationDetail.PointcutClass adviceClass = this.adviceClass;
        if (adviceClass == null) {
            Preconditions.checkNotNull(this.lazyAdviceClass);
            adviceClass = InstrumentationDetailBuilder.buildAdviceClass(this.lazyAdviceClass.getBytes());
        }
        Advice.Pointcut pointcut = adviceClass.pointcut();
        Preconditions.checkNotNull(pointcut, "Class has no @Advice.Pointcut annotation");
        this.builder.pointcut(pointcut);
        this.builder.adviceType(adviceClass.type());
        this.builder.pointcutClassNamePattern(MaybePatterns.buildPattern(pointcut.className()));
        this.builder.pointcutClassAnnotationPattern(MaybePatterns.buildPattern(pointcut.classAnnotation()));
        this.builder.pointcutSubTypeRestrictionPattern(MaybePatterns.buildPattern(pointcut.subTypeRestriction()));
        this.builder.pointcutSuperTypeRestrictionPattern(MaybePatterns.buildPattern(pointcut.superTypeRestriction()));
        this.builder.pointcutMethodNamePattern(MaybePatterns.buildPattern(pointcut.methodName()));
        this.builder.pointcutMethodAnnotationPattern(MaybePatterns.buildPattern(pointcut.methodAnnotation()));
        this.builder.pointcutMethodParameterTypes(AdviceBuilder.buildPatterns(pointcut.methodParameterTypes()));
        this.builder.hasBindThreadContext(false);
        this.builder.hasBindOptionalThreadContext(false);
        for (InstrumentationDetail.PointcutMethod pointcutMethod : adviceClass.methods()) {
            if (pointcutMethod.annotationTypes().contains(IsEnabledType)) {
                this.initIsEnabledAdvice(adviceClass, pointcutMethod);
                continue;
            }
            if (pointcutMethod.annotationTypes().contains(OnBeforeType)) {
                this.initOnBeforeAdvice(adviceClass, pointcutMethod);
                continue;
            }
            if (pointcutMethod.annotationTypes().contains(OnReturnType)) {
                this.initOnReturnAdvice(adviceClass, pointcutMethod);
                continue;
            }
            if (pointcutMethod.annotationTypes().contains(OnThrowType)) {
                this.initOnThrowAdvice(adviceClass, pointcutMethod);
                continue;
            }
            if (!pointcutMethod.annotationTypes().contains(OnAfterType)) continue;
            this.initOnAfterAdvice(adviceClass, pointcutMethod);
        }
        if (adviceClass.collocateInClassLoader()) {
            InstrumentationClassRenamer classRenamer = new InstrumentationClassRenamer(adviceClass, collocatedClassCache);
            this.builder.nonBootstrapLoaderAdviceClass(classRenamer.buildNonBootstrapLoaderAdviceClass());
            this.builder.nonBootstrapLoaderAdvice(classRenamer.buildNonBootstrapLoaderAdvice(this.builder.build()));
        }
        ImmutableAdvice advice = this.builder.build();
        if (pointcut.methodName().equals("<init>")) {
            if (((Advice)advice).onBeforeAdvice() != null && ((Advice)advice).hasBindOptionalThreadContext()) {
                throw new IllegalStateException("@BindOptionalThreadContext is not allowed in a @Advice.Pointcut with methodName \"<init>\" that has an @Advice.OnMethodBefore method");
            }
            if (((Advice)advice).isEnabledAdvice() != null) {
                for (Advice.AdviceParameter parameter : ((Advice)advice).isEnabledParameters()) {
                    if (parameter.kind() != Advice.ParameterKind.RECEIVER) continue;
                    throw new IllegalStateException("@Bind.This is not allowed on @Advice.IsEnabled for an @Advice.Pointcut with methodName \"<init>\"");
                }
            }
            if (this.hasOnBeforeAdvice) {
                boolean bl = this.hasIsEnabledAdvice || !pointcut.nestingGroup().isEmpty() || !pointcut.suppressibleUsingKey().isEmpty() || ((Advice)advice).hasBindThreadContext() && !((Advice)advice).hasBindOptionalThreadContext();
                boolean hasSpecial = false;
                for (Advice.AdviceParameter parameter : ((Advice)advice).onBeforeParameters()) {
                    if (parameter.kind() != Advice.ParameterKind.SPECIAL) continue;
                    hasSpecial = true;
                    break;
                }
                if (bl) {
                    AdviceBuilder.checkState(hasSpecial, "@Advice.OnMethodBefore for this particular constructor pointcut requires @Bind.Special");
                } else {
                    AdviceBuilder.checkState(!hasSpecial, "@Advice.OnMethodBefore for this particular constructor pointcut does not require @Bind.Special");
                }
            }
        }
        return advice;
    }

    private void initIsEnabledAdvice(InstrumentationDetail.PointcutClass adviceClass, InstrumentationDetail.PointcutMethod adviceMethod) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasIsEnabledAdvice, "@Advice.Pointcut '" + adviceClass.type().getClassName() + "' has more than one @Advice.IsEnabled method");
        Method asmMethod = adviceMethod.toAsmMethod();
        AdviceBuilder.checkState(asmMethod.getReturnType().getSort() == 1, "@Advice.IsEnabled method must return boolean");
        this.builder.isEnabledAdvice(asmMethod);
        List<Advice.AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(adviceMethod.bindAnnotations(), asmMethod.getArgumentTypes(), isEnabledBindAnnotationTypes, IsEnabledType);
        this.builder.addAllIsEnabledParameters(parameters);
        this.hasIsEnabledAdvice = true;
    }

    private void initOnBeforeAdvice(InstrumentationDetail.PointcutClass adviceClass, InstrumentationDetail.PointcutMethod adviceMethod) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasOnBeforeAdvice, "@Advice.Pointcut '" + adviceClass.type().getClassName() + "' has more than one @Advice.OnMethodBefore method");
        Method asmMethod = adviceMethod.toAsmMethod();
        this.builder.onBeforeAdvice(asmMethod);
        List<Advice.AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(adviceMethod.bindAnnotations(), asmMethod.getArgumentTypes(), onBeforeBindAnnotationTypes, OnBeforeType);
        this.builder.addAllOnBeforeParameters(parameters);
        if (asmMethod.getReturnType().getSort() != 0) {
            this.builder.travelerType(asmMethod.getReturnType());
        }
        this.checkForBindThreadContext(parameters);
        this.checkForBindOptionalThreadContext(parameters);
        this.hasOnBeforeAdvice = true;
    }

    private void initOnReturnAdvice(InstrumentationDetail.PointcutClass adviceClass, InstrumentationDetail.PointcutMethod adviceMethod) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasOnReturnAdvice, "@Advice.Pointcut '" + adviceClass.type().getClassName() + "' has more than one @Advice.OnMethodReturn method");
        Method asmMethod = adviceMethod.toAsmMethod();
        List<Advice.AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(adviceMethod.bindAnnotations(), asmMethod.getArgumentTypes(), onReturnBindAnnotationTypes, OnReturnType);
        for (int i = 1; i < parameters.size(); ++i) {
            AdviceBuilder.checkState(parameters.get(i).kind() != Advice.ParameterKind.RETURN, "@Bind.Return must be the first argument to @Advice.OnMethodReturn");
            AdviceBuilder.checkState(parameters.get(i).kind() != Advice.ParameterKind.OPTIONAL_RETURN, "@Bind.OptionalReturn must be the first argument to @Advice.OnMethodReturn");
        }
        this.builder.onReturnAdvice(asmMethod);
        this.builder.addAllOnReturnParameters(parameters);
        this.checkForBindThreadContext(parameters);
        this.checkForBindOptionalThreadContext(parameters);
        this.hasOnReturnAdvice = true;
    }

    private void initOnThrowAdvice(InstrumentationDetail.PointcutClass adviceClass, InstrumentationDetail.PointcutMethod adviceMethod) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasOnThrowAdvice, "@Advice.Pointcut '" + adviceClass.type().getClassName() + "' has more than one @Advice.OnMethodThrow method");
        Method asmMethod = adviceMethod.toAsmMethod();
        List<Advice.AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(adviceMethod.bindAnnotations(), asmMethod.getArgumentTypes(), onThrowBindAnnotationTypes, OnThrowType);
        for (int i = 1; i < parameters.size(); ++i) {
            AdviceBuilder.checkState(parameters.get(i).kind() != Advice.ParameterKind.THROWABLE, "@Bind.Thrown must be the first argument to @Advice.OnMethodThrow");
        }
        AdviceBuilder.checkState(asmMethod.getReturnType().getSort() == 0, "@Advice.OnMethodThrow method must return void (for now)");
        this.builder.onThrowAdvice(asmMethod);
        this.builder.addAllOnThrowParameters(parameters);
        this.checkForBindThreadContext(parameters);
        this.checkForBindOptionalThreadContext(parameters);
        this.hasOnThrowAdvice = true;
    }

    private void initOnAfterAdvice(InstrumentationDetail.PointcutClass adviceClass, InstrumentationDetail.PointcutMethod adviceMethod) throws AdviceConstructionException {
        AdviceBuilder.checkState(!this.hasOnAfterAdvice, "@Advice.Pointcut '" + adviceClass.type().getClassName() + "' has more than one @Advice.OnMethodAfter method");
        Method asmMethod = adviceMethod.toAsmMethod();
        AdviceBuilder.checkState(asmMethod.getReturnType().getSort() == 0, "@Advice.OnMethodAfter method must return void");
        this.builder.onAfterAdvice(asmMethod);
        List<Advice.AdviceParameter> parameters = AdviceBuilder.getAdviceParameters(adviceMethod.bindAnnotations(), asmMethod.getArgumentTypes(), onAfterBindAnnotationTypes, OnAfterType);
        this.builder.addAllOnAfterParameters(parameters);
        this.checkForBindThreadContext(parameters);
        this.checkForBindOptionalThreadContext(parameters);
        this.hasOnAfterAdvice = true;
    }

    private void checkForBindThreadContext(List<Advice.AdviceParameter> parameters) {
        for (Advice.AdviceParameter parameter : parameters) {
            if (parameter.kind() != Advice.ParameterKind.THREAD_CONTEXT) continue;
            this.builder.hasBindThreadContext(true);
            return;
        }
    }

    private void checkForBindOptionalThreadContext(List<Advice.AdviceParameter> parameters) {
        for (Advice.AdviceParameter parameter : parameters) {
            if (parameter.kind() != Advice.ParameterKind.OPTIONAL_THREAD_CONTEXT) continue;
            this.builder.hasBindOptionalThreadContext(true);
            break;
        }
    }

    private static void checkState(boolean condition, String message) throws AdviceConstructionException {
        if (!condition) {
            throw new AdviceConstructionException(message);
        }
    }

    private static List<Object> buildPatterns(String[] maybePatterns) {
        ArrayList<Object> patterns = Lists.newArrayList();
        for (String maybePattern : maybePatterns) {
            Pattern pattern = MaybePatterns.buildPattern(maybePattern);
            if (pattern == null) {
                patterns.add(maybePattern);
                continue;
            }
            patterns.add(pattern);
        }
        return patterns;
    }

    private static List<Advice.AdviceParameter> getAdviceParameters(Map<Integer, InstrumentationDetail.BindAnnotation> parameterAnnotations, Type[] parameterTypes, List<Type> validBindAnnotationTypes, Type adviceAnnotationType) throws AdviceConstructionException {
        ArrayList<Advice.AdviceParameter> parameters = Lists.newArrayList();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].equals(ThreadContextType)) {
                parameters.add(ImmutableAdviceParameter.builder().kind(Advice.ParameterKind.THREAD_CONTEXT).type(ThreadContextType).argIndex(-1).build());
                continue;
            }
            if (parameterTypes[i].equals(OptionalThreadContextType)) {
                parameters.add(ImmutableAdviceParameter.builder().kind(Advice.ParameterKind.OPTIONAL_THREAD_CONTEXT).type(OptionalThreadContextType).argIndex(-1).build());
                continue;
            }
            InstrumentationDetail.BindAnnotation bindAnnotation = parameterAnnotations.get(i);
            if (bindAnnotation == null) {
                ArrayList<String> validBindAnnotationNames = Lists.newArrayList();
                for (Type annotationType : validBindAnnotationTypes) {
                    validBindAnnotationNames.add("@" + annotationType.getClassName());
                }
                throw new AdviceConstructionException("All parameters to @" + adviceAnnotationType.getClassName() + " must be annotated with one of " + Joiner.on(", ").join(validBindAnnotationNames));
            }
            Type bindAnnotationType = bindAnnotation.type();
            AdviceBuilder.checkState(validBindAnnotationTypes.contains(bindAnnotationType), "Annotation '" + bindAnnotationType.getClassName() + "' found in an invalid location");
            if (bindAnnotationType.equals(BindSpecialType)) {
                AdviceBuilder.checkState(parameterTypes[i].getSort() == 1, "@Bind.Special must be bound to a boolean parameter");
            }
            parameters.add(AdviceBuilder.getAdviceParameter(bindAnnotationType, parameterTypes[i], bindAnnotation.argIndex()));
        }
        return parameters;
    }

    private static Advice.AdviceParameter getAdviceParameter(Type validBindAnnotationType, Type parameterType, int argIndex) throws AdviceConstructionException {
        AdviceBuilder.checkState(!validBindAnnotationType.equals(BindMethodNameType) || parameterType.equals(StringType), "@Bind.MethodName parameter type must be java.lang.String");
        AdviceBuilder.checkState(!validBindAnnotationType.equals(BindThrowableType) || parameterType.equals(ThrowableType), "@Bind.MethodName parameter type must be java.lang.Throwable");
        Advice.ParameterKind parameterKind = parameterKindMap.get(validBindAnnotationType);
        Preconditions.checkNotNull(parameterKind, "Annotation not found in parameterKindMap: " + validBindAnnotationType.getClassName());
        return ImmutableAdviceParameter.builder().kind(parameterKind).type(parameterType).argIndex(argIndex).build();
    }

    private static class AdviceConstructionException
    extends Exception {
        private AdviceConstructionException(@Nullable String message) {
            super(message);
        }
    }
}

