/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableMap;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Maps;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.RequiresNonNull;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.AnnotationVisitor;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassWriter;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Label;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.MethodVisitor;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.glowroot.instrumentation.api.Descriptor;
import org.glowroot.instrumentation.api.OptionalThreadContext;
import org.glowroot.instrumentation.engine.config.AdviceConfig;
import org.glowroot.instrumentation.engine.weaving.Advice;
import org.glowroot.instrumentation.engine.weaving.AdviceBuilder;
import org.glowroot.instrumentation.engine.weaving.ClassLoaders;

class AdviceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(AdviceGenerator.class);
    private static final AtomicInteger counter = new AtomicInteger();
    private final AdviceConfig config;
    @Nullable
    private final String instrumentationId;
    private final int priorityForSetters;
    private final String adviceInternalName;
    @Nullable
    private final String methodMetaInternalName;
    private final int uniqueNum;

    static ImmutableMap<Advice, ClassLoaders.LazyDefinedClass> createAdvisors(List<AdviceConfig> configs, @Nullable String instrumentationId, boolean userInstrumentation, boolean reweavable) {
        HashMap<Advice, ClassLoaders.LazyDefinedClass> advisors = Maps.newHashMap();
        for (AdviceConfig config : configs) {
            if (!config.validationErrors().isEmpty()) continue;
            try {
                ClassLoaders.LazyDefinedClass lazyAdviceClass = new AdviceGenerator(config, instrumentationId, userInstrumentation).generate();
                Advice advice = new AdviceBuilder(lazyAdviceClass, reweavable).build();
                advisors.put(advice, lazyAdviceClass);
            }
            catch (Exception e) {
                logger.error("error creating advice for advice config: {}", (Object)config, (Object)e);
            }
        }
        return ImmutableMap.copyOf(advisors);
    }

    private AdviceGenerator(AdviceConfig config, @Nullable String instrumentationId, boolean userInstrumentation) {
        this.config = config;
        this.instrumentationId = instrumentationId;
        this.priorityForSetters = instrumentationId == null ? 10000 : (userInstrumentation ? 100 : -100);
        this.uniqueNum = counter.incrementAndGet();
        this.adviceInternalName = "org/glowroot/instrumentation/engine/weaving/GeneratedAdvice" + this.uniqueNum;
        this.methodMetaInternalName = config.isLocalSpanOrGreater() || !config.transactionNameTemplate().isEmpty() || !config.transactionUserTemplate().isEmpty() || !config.transactionAttributeTemplates().isEmpty() ? "org/glowroot/instrumentation/engine/weaving/GeneratedMethodMeta" + this.uniqueNum : null;
    }

    private ClassLoaders.LazyDefinedClass generate() {
        ClassLoaders.LazyDefinedClass methodMetaClass = null;
        if (this.methodMetaInternalName != null) {
            methodMetaClass = this.generateMethodMetaClass(this.config);
        }
        ClassWriter cw = new ClassWriter(3);
        String[] interfaces = null;
        if (!this.config.enabledProperty().isEmpty() || !this.config.localSpanEnabledProperty().isEmpty()) {
            interfaces = new String[]{"org/glowroot/instrumentation/api/config/ConfigListener"};
        }
        cw.visit(49, 33, this.adviceInternalName, null, "java/lang/Object", interfaces);
        this.addClassAnnotation(cw);
        this.addStaticFields(cw);
        this.addStaticInitializer(cw);
        boolean checkNotInTransaction = this.config.isTransaction() && this.config.alreadyInTransactionBehavior() == OptionalThreadContext.AlreadyInTransactionBehavior.DO_NOTHING;
        boolean checkPropertyNotEnabled = this.instrumentationId != null && !this.config.enabledProperty().isEmpty();
        this.addIsEnabledMethodIfNeeded(cw, checkNotInTransaction, checkPropertyNotEnabled);
        if (this.config.isLocalSpanOrGreater()) {
            Preconditions.checkNotNull(this.methodMetaInternalName);
            this.addOnBeforeMethod(cw);
            this.addOnThrowMethod(cw);
            this.addOnReturnMethod(cw);
        } else if (this.config.captureKind() == Descriptor.CaptureKind.TIMER) {
            this.addOnBeforeMethodTimerOnly(cw);
            AdviceGenerator.addOnAfterMethodTimerOnly(cw);
        } else {
            this.addOnBeforeMethodOther(cw);
        }
        cw.visitEnd();
        ClassLoaders.LazyDefinedClass lazyDefinedClass = new ClassLoaders.LazyDefinedClass(this.adviceInternalName, cw.toByteArray());
        if (methodMetaClass != null) {
            lazyDefinedClass.getDependencies().add(methodMetaClass);
        }
        return lazyDefinedClass;
    }

    private void addClassAnnotation(ClassWriter cw) {
        AnnotationVisitor annotationVisitor = cw.visitAnnotation("Lorg/glowroot/instrumentation/api/weaving/Advice$Pointcut;", true);
        annotationVisitor.visit("className", this.config.className());
        annotationVisitor.visit("classAnnotation", this.config.classAnnotation());
        annotationVisitor.visit("subTypeRestriction", this.config.subTypeRestriction());
        annotationVisitor.visit("superTypeRestriction", this.config.superTypeRestriction());
        annotationVisitor.visit("methodName", this.config.methodName());
        annotationVisitor.visit("methodAnnotation", this.config.methodAnnotation());
        AnnotationVisitor arrayAnnotationVisitor = Preconditions.checkNotNull(annotationVisitor.visitArray("methodParameterTypes"));
        for (String methodParameterType : this.config.methodParameterTypes()) {
            arrayAnnotationVisitor.visit(null, methodParameterType);
        }
        arrayAnnotationVisitor.visitEnd();
        String nestingGroup = this.config.nestingGroup();
        if (!nestingGroup.isEmpty()) {
            annotationVisitor.visit("nestingGroup", nestingGroup);
        } else if (!this.config.spanCaptureSelfNested()) {
            annotationVisitor.visit("nestingGroup", "__GeneratedAdvice" + this.uniqueNum);
        }
        annotationVisitor.visit("order", this.config.order());
        annotationVisitor.visitEnd();
    }

    private void addStaticFields(ClassWriter cw) {
        if (this.instrumentationId != null) {
            cw.visitField(26, "configService", "Lorg/glowroot/instrumentation/api/config/ConfigService;", null, null).visitEnd();
        }
        if (this.config.isTimerOrGreater()) {
            cw.visitField(26, "timerName", "Lorg/glowroot/instrumentation/api/TimerName;", null, null).visitEnd();
        }
        if (!this.config.enabledProperty().isEmpty()) {
            cw.visitField(26, "enabled", "Lorg/glowroot/instrumentation/api/config/BooleanProperty;", null, null).visitEnd();
        }
        if (!this.config.localSpanEnabledProperty().isEmpty()) {
            cw.visitField(26, "entryEnabled", "Lorg/glowroot/instrumentation/api/config/BooleanProperty;", null, null).visitEnd();
        }
    }

    private void addStaticInitializer(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        if (this.instrumentationId != null) {
            mv.visitLdcInsn(this.instrumentationId);
            mv.visitMethodInsn(184, "org/glowroot/instrumentation/api/Agent", "getConfigService", "(Ljava/lang/String;)Lorg/glowroot/instrumentation/api/config/ConfigService;", false);
            mv.visitFieldInsn(179, this.adviceInternalName, "configService", "Lorg/glowroot/instrumentation/api/config/ConfigService;");
        }
        if (this.config.isTimerOrGreater()) {
            String timerName = this.config.timerName();
            if (timerName.isEmpty()) {
                mv.visitLdcInsn("<no timer name provided>");
            } else {
                mv.visitLdcInsn(timerName);
            }
            mv.visitMethodInsn(184, "org/glowroot/instrumentation/api/Agent", "getTimerName", "(Ljava/lang/String;)Lorg/glowroot/instrumentation/api/TimerName;", false);
            mv.visitFieldInsn(179, this.adviceInternalName, "timerName", "Lorg/glowroot/instrumentation/api/TimerName;");
        }
        if (!this.config.enabledProperty().isEmpty() && this.instrumentationId != null) {
            mv.visitFieldInsn(178, this.adviceInternalName, "configService", "Lorg/glowroot/instrumentation/api/config/ConfigService;");
            mv.visitLdcInsn(this.config.enabledProperty());
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/config/ConfigService", "getBooleanProperty", "(Ljava/lang/String;)Lorg/glowroot/instrumentation/api/config/BooleanProperty;", true);
            mv.visitFieldInsn(179, this.adviceInternalName, "enabled", "Lorg/glowroot/instrumentation/api/config/BooleanProperty;");
        }
        if (!this.config.localSpanEnabledProperty().isEmpty() && this.instrumentationId != null) {
            mv.visitFieldInsn(178, this.adviceInternalName, "configService", "Lorg/glowroot/instrumentation/api/config/ConfigService;");
            mv.visitLdcInsn(this.config.localSpanEnabledProperty());
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/config/ConfigService", "getBooleanProperty", "(Ljava/lang/String;)Lorg/glowroot/instrumentation/api/config/BooleanProperty;", true);
            mv.visitFieldInsn(179, this.adviceInternalName, "entryEnabled", "Lorg/glowroot/instrumentation/api/config/BooleanProperty;");
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addIsEnabledMethodIfNeeded(ClassWriter cw, boolean checkNotInTransaction, boolean checkPropertyNotEnabled) {
        if (!checkNotInTransaction && !checkPropertyNotEnabled) {
            return;
        }
        String descriptor = checkNotInTransaction ? "(Lorg/glowroot/instrumentation/api/OptionalThreadContext;)Z" : "()Z";
        MethodVisitor mv = cw.visitMethod(9, "isEnabled", descriptor, null, null);
        AdviceGenerator.visitAnnotation(mv, "Lorg/glowroot/instrumentation/api/weaving/Advice$IsEnabled;");
        mv.visitCode();
        if (checkNotInTransaction && !checkPropertyNotEnabled) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/OptionalThreadContext", "isInTransaction", "()Z", true);
            Label returnTrueLabel = new Label();
            mv.visitJumpInsn(153, returnTrueLabel);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(returnTrueLabel);
            mv.visitInsn(4);
            mv.visitInsn(172);
        } else if (!checkNotInTransaction) {
            mv.visitFieldInsn(178, this.adviceInternalName, "enabled", "Lorg/glowroot/instrumentation/api/config/BooleanProperty;");
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/config/BooleanProperty", "value", "()Z", true);
            mv.visitInsn(172);
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/OptionalThreadContext", "isInTransaction", "()Z", true);
            Label returnTrueLabel = new Label();
            mv.visitJumpInsn(153, returnTrueLabel);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitFieldInsn(178, this.adviceInternalName, "enabled", "Lorg/glowroot/instrumentation/api/config/BooleanProperty;");
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/config/BooleanProperty", "value", "()Z", true);
            mv.visitJumpInsn(154, returnTrueLabel);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(returnTrueLabel);
            mv.visitInsn(4);
            mv.visitInsn(172);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    @RequiresNonNull(value={"methodMetaInternalName"})
    private void addOnBeforeMethod(ClassWriter cw) {
        MethodVisitor mv = this.visitOnBeforeMethod(cw, "Lorg/glowroot/instrumentation/api/Span;");
        mv.visitCode();
        if (!this.config.localSpanEnabledProperty().isEmpty() && this.instrumentationId != null) {
            mv.visitFieldInsn(178, this.adviceInternalName, "entryEnabled", "Lorg/glowroot/instrumentation/api/config/BooleanProperty;");
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/config/BooleanProperty", "value", "()Z", true);
            Label label = new Label();
            mv.visitJumpInsn(154, label);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(178, this.adviceInternalName, "timerName", "Lorg/glowroot/instrumentation/api/TimerName;");
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/ThreadContext", "startTimer", "(Lorg/glowroot/instrumentation/api/TimerName;)Lorg/glowroot/instrumentation/api/Timer;", true);
            mv.visitInsn(176);
            mv.visitLabel(label);
        }
        mv.visitVarInsn(25, 0);
        if (this.config.isTransaction()) {
            String transactionType = this.config.transactionType();
            if (transactionType.isEmpty()) {
                mv.visitLdcInsn("<no transaction type provided>");
            } else {
                mv.visitLdcInsn(transactionType);
            }
            mv.visitVarInsn(25, 4);
            mv.visitMethodInsn(182, this.methodMetaInternalName, "getTransactionNameTemplate", "()Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;", false);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(184, "org/glowroot/instrumentation/engine/bytecode/api/Bytecode", "getMessageText", "(Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
            mv.visitFieldInsn(178, "org/glowroot/instrumentation/engine/bytecode/api/NopGetter", "GETTER", "Lorg/glowroot/instrumentation/api/Getter;");
            mv.visitFieldInsn(178, "org/glowroot/instrumentation/engine/bytecode/api/NopGetter", "CARRIER", "Ljava/lang/Object;");
        }
        mv.visitVarInsn(25, 4);
        mv.visitMethodInsn(182, this.methodMetaInternalName, "getMessageTemplate", "()Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;", false);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(184, "org/glowroot/instrumentation/engine/bytecode/api/Bytecode", "createMessageSupplier", "(Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Lorg/glowroot/instrumentation/api/MessageSupplier;", false);
        mv.visitFieldInsn(178, this.adviceInternalName, "timerName", "Lorg/glowroot/instrumentation/api/TimerName;");
        if (this.config.isTransaction()) {
            String fieldName = this.config.alreadyInTransactionBehaviorCorrected() == OptionalThreadContext.AlreadyInTransactionBehavior.CAPTURE_NEW_TRANSACTION ? "CAPTURE_NEW_TRANSACTION" : "CAPTURE_LOCAL_SPAN";
            mv.visitFieldInsn(178, "org/glowroot/instrumentation/api/OptionalThreadContext$AlreadyInTransactionBehavior", fieldName, "Lorg/glowroot/instrumentation/api/OptionalThreadContext$AlreadyInTransactionBehavior;");
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/OptionalThreadContext", "startIncomingSpan", "(Ljava/lang/String;Ljava/lang/String;Lorg/glowroot/instrumentation/api/Getter;Ljava/lang/Object;Lorg/glowroot/instrumentation/api/MessageSupplier;Lorg/glowroot/instrumentation/api/TimerName;Lorg/glowroot/instrumentation/api/OptionalThreadContext$AlreadyInTransactionBehavior;)Lorg/glowroot/instrumentation/api/Span;", true);
        } else {
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/ThreadContext", "startLocalSpan", "(Lorg/glowroot/instrumentation/api/MessageSupplier;Lorg/glowroot/instrumentation/api/TimerName;)Lorg/glowroot/instrumentation/api/Span;", true);
        }
        this.addCodeForOptionalTransactionAttributes(mv);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addOnBeforeMethodTimerOnly(ClassWriter cw) {
        MethodVisitor mv = this.visitOnBeforeMethod(cw, "Lorg/glowroot/instrumentation/api/Timer;");
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, this.adviceInternalName, "timerName", "Lorg/glowroot/instrumentation/api/TimerName;");
        mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/ThreadContext", "startTimer", "(Lorg/glowroot/instrumentation/api/TimerName;)Lorg/glowroot/instrumentation/api/Timer;", true);
        this.addCodeForOptionalTransactionAttributes(mv);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addOnBeforeMethodOther(ClassWriter cw) {
        MethodVisitor mv = this.visitOnBeforeMethod(cw, "V");
        mv.visitCode();
        this.addCodeForOptionalTransactionAttributes(mv);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private MethodVisitor visitOnBeforeMethod(ClassWriter cw, String returnInternalName) {
        StringBuilder descriptor = new StringBuilder();
        descriptor.append("(");
        if (this.config.isTransaction()) {
            descriptor.append("Lorg/glowroot/instrumentation/api/OptionalThreadContext;");
        } else {
            descriptor.append("Lorg/glowroot/instrumentation/api/ThreadContext;");
        }
        if (this.methodMetaInternalName != null) {
            descriptor.append("Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;L");
            descriptor.append(this.methodMetaInternalName);
            descriptor.append(";)");
        } else {
            descriptor.append(")");
        }
        descriptor.append(returnInternalName);
        MethodVisitor mv = cw.visitMethod(9, "onBefore", descriptor.toString(), null, null);
        AdviceGenerator.visitAnnotation(mv, "Lorg/glowroot/instrumentation/api/weaving/Advice$OnMethodBefore;");
        if (this.methodMetaInternalName != null) {
            Preconditions.checkNotNull(mv.visitParameterAnnotation(1, "Lorg/glowroot/instrumentation/api/weaving/Bind$This;", true)).visitEnd();
            Preconditions.checkNotNull(mv.visitParameterAnnotation(2, "Lorg/glowroot/instrumentation/api/weaving/Bind$MethodName;", true)).visitEnd();
            Preconditions.checkNotNull(mv.visitParameterAnnotation(3, "Lorg/glowroot/instrumentation/api/weaving/Bind$AllArguments;", true)).visitEnd();
            Preconditions.checkNotNull(mv.visitParameterAnnotation(4, "Lorg/glowroot/instrumentation/api/weaving/Bind$MethodMeta;", true)).visitEnd();
        }
        return mv;
    }

    private void addCodeForOptionalTransactionAttributes(MethodVisitor mv) {
        if (!this.config.transactionType().isEmpty() && !this.config.isTransaction()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(this.config.transactionType());
            mv.visitLdcInsn(this.priorityForSetters);
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/ThreadContext", "setTransactionType", "(Ljava/lang/String;I)V", true);
        }
        if (!this.config.transactionNameTemplate().isEmpty() && !this.config.isTransaction()) {
            this.addCodeForSetTransactionX(mv, "getTransactionNameTemplate", "setTransactionName");
        }
        if (!this.config.transactionUserTemplate().isEmpty()) {
            this.addCodeForSetTransactionX(mv, "getTransactionUserTemplate", "setTransactionUser");
        }
        int i = 0;
        for (String attrName : this.config.transactionAttributeTemplates().keySet()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(attrName);
            mv.visitVarInsn(25, 4);
            Preconditions.checkNotNull(this.methodMetaInternalName);
            mv.visitMethodInsn(182, this.methodMetaInternalName, "getTransactionAttributeTemplate" + i++, "()Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;", false);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(184, "org/glowroot/instrumentation/engine/bytecode/api/Bytecode", "getMessageText", "(Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/ThreadContext", "addTransactionAttribute", "(Ljava/lang/String;Ljava/lang/String;)V", true);
        }
        Integer slowThresholdMillis = this.config.transactionSlowThresholdMillis();
        if (slowThresholdMillis != null) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(slowThresholdMillis.longValue());
            mv.visitFieldInsn(178, "java/util/concurrent/TimeUnit", "MILLISECONDS", "Ljava/util/concurrent/TimeUnit;");
            mv.visitLdcInsn(this.priorityForSetters);
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/ThreadContext", "setTransactionSlowThreshold", "(JLjava/util/concurrent/TimeUnit;I)V", true);
        }
    }

    private void addOnReturnMethod(ClassWriter cw) {
        boolean spanOrTimer = !this.config.localSpanEnabledProperty().isEmpty();
        String travelerType = spanOrTimer ? "Ljava/lang/Object;" : "Lorg/glowroot/instrumentation/api/Span;";
        MethodVisitor mv = cw.visitMethod(9, "onReturn", "(Lorg/glowroot/instrumentation/api/weaving/OptionalReturn;" + travelerType + ")V", null, null);
        Preconditions.checkNotNull(mv.visitParameterAnnotation(0, "Lorg/glowroot/instrumentation/api/weaving/Bind$OptionalReturn;", true)).visitEnd();
        Preconditions.checkNotNull(mv.visitParameterAnnotation(1, "Lorg/glowroot/instrumentation/api/weaving/Bind$Enter;", true)).visitEnd();
        int travelerParamIndex = 1;
        AdviceGenerator.visitAnnotation(mv, "Lorg/glowroot/instrumentation/api/weaving/Advice$OnMethodReturn;");
        mv.visitCode();
        if (!this.config.localSpanEnabledProperty().isEmpty()) {
            mv.visitVarInsn(25, travelerParamIndex);
            mv.visitTypeInsn(193, "org/glowroot/instrumentation/api/Span");
            Label label = new Label();
            mv.visitJumpInsn(154, label);
            mv.visitVarInsn(25, travelerParamIndex);
            mv.visitTypeInsn(192, "org/glowroot/instrumentation/api/Timer");
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/Timer", "stop", "()V", true);
            mv.visitInsn(177);
            mv.visitLabel(label);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/weaving/OptionalReturn", "isVoid", "()Z", true);
        Label notVoidLabel = new Label();
        Label endIfLabel = new Label();
        mv.visitJumpInsn(153, notVoidLabel);
        mv.visitLdcInsn("void");
        mv.visitJumpInsn(167, endIfLabel);
        mv.visitLabel(notVoidLabel);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/weaving/OptionalReturn", "getValue", "()Ljava/lang/Object;", true);
        mv.visitLabel(endIfLabel);
        mv.visitMethodInsn(184, "org/glowroot/instrumentation/engine/bytecode/api/Bytecode", "updateWithReturnValue", "(Lorg/glowroot/instrumentation/api/Span;Ljava/lang/Object;)V", false);
        mv.visitVarInsn(25, travelerParamIndex);
        Integer stackTraceThresholdMillis = this.config.spanStackThresholdMillis();
        if (stackTraceThresholdMillis == null) {
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/Span", "end", "()V", true);
        } else {
            mv.visitLdcInsn(stackTraceThresholdMillis.longValue());
            mv.visitFieldInsn(178, "java/util/concurrent/TimeUnit", "MILLISECONDS", "Ljava/util/concurrent/TimeUnit;");
            mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/Span", "endWithLocationStackTrace", "(JLjava/util/concurrent/TimeUnit;)V", true);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addOnThrowMethod(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(9, "onThrow", "(Ljava/lang/Throwable;Lorg/glowroot/instrumentation/api/Span;)V", null, null);
        AdviceGenerator.visitAnnotation(mv, "Lorg/glowroot/instrumentation/api/weaving/Advice$OnMethodThrow;");
        Preconditions.checkNotNull(mv.visitParameterAnnotation(0, "Lorg/glowroot/instrumentation/api/weaving/Bind$Thrown;", true)).visitEnd();
        Preconditions.checkNotNull(mv.visitParameterAnnotation(1, "Lorg/glowroot/instrumentation/api/weaving/Bind$Enter;", true)).visitEnd();
        mv.visitCode();
        if (!this.config.localSpanEnabledProperty().isEmpty()) {
            mv.visitVarInsn(25, 1);
            Label l0 = new Label();
            mv.visitJumpInsn(199, l0);
            mv.visitInsn(177);
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/Span", "endWithError", "(Ljava/lang/Throwable;)V", true);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    @RequiresNonNull(value={"methodMetaInternalName"})
    private ClassLoaders.LazyDefinedClass generateMethodMetaClass(AdviceConfig config) {
        int i;
        ClassWriter cw = new ClassWriter(3);
        cw.visit(49, 33, this.methodMetaInternalName, null, "java/lang/Object", null);
        cw.visitField(18, "messageTemplate", "Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;", null, null).visitEnd();
        if (!config.transactionNameTemplate().isEmpty()) {
            cw.visitField(18, "transactionNameTemplate", "Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;", null, null).visitEnd();
        }
        if (!config.transactionUserTemplate().isEmpty()) {
            cw.visitField(18, "transactionUserTemplate", "Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;", null, null).visitEnd();
        }
        for (i = 0; i < config.transactionAttributeTemplates().size(); ++i) {
            cw.visitField(18, "transactionAttributeTemplate" + i, "Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;", null, null).visitEnd();
        }
        this.generateMethodMetaConstructor(cw);
        this.generateMethodMetaGetter(cw, "messageTemplate", "getMessageTemplate");
        if (!config.transactionNameTemplate().isEmpty()) {
            this.generateMethodMetaGetter(cw, "transactionNameTemplate", "getTransactionNameTemplate");
        }
        if (!config.transactionUserTemplate().isEmpty()) {
            this.generateMethodMetaGetter(cw, "transactionUserTemplate", "getTransactionUserTemplate");
        }
        for (i = 0; i < config.transactionAttributeTemplates().size(); ++i) {
            this.generateMethodMetaGetter(cw, "transactionAttributeTemplate" + i, "getTransactionAttributeTemplate" + i);
        }
        cw.visitEnd();
        return new ClassLoaders.LazyDefinedClass(this.methodMetaInternalName, cw.toByteArray());
    }

    private void addCodeForSetTransactionX(MethodVisitor mv, String templateGetterName, String threadContextSetterName) {
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 4);
        Preconditions.checkNotNull(this.methodMetaInternalName);
        mv.visitMethodInsn(182, this.methodMetaInternalName, templateGetterName, "()Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;", false);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(184, "org/glowroot/instrumentation/engine/bytecode/api/Bytecode", "getMessageText", "(Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
        mv.visitLdcInsn(this.priorityForSetters);
        mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/ThreadContext", threadContextSetterName, "(Ljava/lang/String;I)V", true);
    }

    @RequiresNonNull(value={"methodMetaInternalName"})
    private void generateMethodMetaConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Lorg/glowroot/instrumentation/api/MethodInfo;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitVarInsn(25, 0);
        if (this.config.isLocalSpanOrGreater()) {
            String messageTemplate = this.config.spanMessageTemplate();
            if (messageTemplate.isEmpty() && this.config.isTransaction()) {
                messageTemplate = this.config.transactionNameTemplate();
            }
            if (messageTemplate.isEmpty()) {
                mv.visitLdcInsn("<no message template provided>");
            } else {
                mv.visitLdcInsn(messageTemplate);
            }
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "org/glowroot/instrumentation/engine/bytecode/api/Bytecode", "createMessageTemplate", "(Ljava/lang/String;Lorg/glowroot/instrumentation/api/MethodInfo;)Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;", false);
        } else {
            mv.visitInsn(1);
        }
        mv.visitFieldInsn(181, this.methodMetaInternalName, "messageTemplate", "Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;");
        if (!this.config.transactionNameTemplate().isEmpty()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(this.config.transactionNameTemplate());
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "org/glowroot/instrumentation/engine/bytecode/api/Bytecode", "createMessageTemplate", "(Ljava/lang/String;Lorg/glowroot/instrumentation/api/MethodInfo;)Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;", false);
            mv.visitFieldInsn(181, this.methodMetaInternalName, "transactionNameTemplate", "Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;");
        }
        if (!this.config.transactionUserTemplate().isEmpty()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(this.config.transactionUserTemplate());
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "org/glowroot/instrumentation/engine/bytecode/api/Bytecode", "createMessageTemplate", "(Ljava/lang/String;Lorg/glowroot/instrumentation/api/MethodInfo;)Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;", false);
            mv.visitFieldInsn(181, this.methodMetaInternalName, "transactionUserTemplate", "Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;");
        }
        int i = 0;
        for (String attrTemplate : this.config.transactionAttributeTemplates().values()) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(attrTemplate);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "org/glowroot/instrumentation/engine/bytecode/api/Bytecode", "createMessageTemplate", "(Ljava/lang/String;Lorg/glowroot/instrumentation/api/MethodInfo;)Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;", false);
            mv.visitFieldInsn(181, this.methodMetaInternalName, "transactionAttributeTemplate" + i++, "Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;");
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    @RequiresNonNull(value={"methodMetaInternalName"})
    private void generateMethodMetaGetter(ClassWriter cw, String fieldName, String methodName) {
        MethodVisitor mv = cw.visitMethod(1, methodName, "()Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.methodMetaInternalName, fieldName, "Lorg/glowroot/instrumentation/engine/bytecode/api/MessageTemplate;");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void addOnAfterMethodTimerOnly(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(9, "onAfter", "(Lorg/glowroot/instrumentation/api/Timer;)V", null, null);
        AdviceGenerator.visitAnnotation(mv, "Lorg/glowroot/instrumentation/api/weaving/Advice$OnMethodAfter;");
        Preconditions.checkNotNull(mv.visitParameterAnnotation(0, "Lorg/glowroot/instrumentation/api/weaving/Bind$Enter;", true)).visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(185, "org/glowroot/instrumentation/api/Timer", "stop", "()V", true);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void visitAnnotation(MethodVisitor mv, String descriptor) {
        AnnotationVisitor av = mv.visitAnnotation(descriptor, true);
        Preconditions.checkNotNull(av);
        av.visitEnd();
    }
}

