/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Modifier;
import org.glowroot.instrumentation.engine.weaving.Advice;
import org.glowroot.instrumentation.engine.weaving.AnalyzedMethod;
import org.glowroot.instrumentation.engine.weaving.MixinType;
import org.glowroot.instrumentation.engine.weaving.PublicFinalMethod;
import org.glowroot.instrumentation.engine.weaving.ShimType;
import org.immutables.value.Value;

@Value.Immutable
abstract class AnalyzedClass {
    AnalyzedClass() {
    }

    abstract int modifiers();

    abstract String name();

    @Nullable
    abstract String superName();

    abstract ImmutableList<String> interfaceNames();

    abstract ImmutableList<AnalyzedMethod> analyzedMethods();

    abstract ImmutableList<PublicFinalMethod> publicFinalMethods();

    abstract ImmutableList<ShimType> shimTypes();

    abstract ImmutableList<MixinType> mixinTypes();

    abstract ImmutableList<MixinType> nonReweavableMixinTypes();

    abstract boolean ejbRemote();

    boolean isInterface() {
        return Modifier.isInterface(this.modifiers());
    }

    boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers());
    }

    boolean hasReweavableAdvice() {
        for (AnalyzedMethod analyzedMethod : this.analyzedMethods()) {
            for (Advice advice : analyzedMethod.advisors()) {
                if (!advice.reweavable()) continue;
                return true;
            }
        }
        return false;
    }
}

