/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.annotations.VisibleForTesting;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type;
import java.lang.reflect.Modifier;
import java.util.List;
import org.glowroot.instrumentation.engine.weaving.Advice;
import org.immutables.value.Value;

@Value.Immutable
abstract class AnalyzedMethod {
    AnalyzedMethod() {
    }

    abstract String name();

    abstract ImmutableList<String> parameterTypes();

    abstract String returnType();

    abstract int modifiers();

    @Nullable
    abstract String signature();

    abstract ImmutableList<String> exceptions();

    abstract ImmutableList<Advice> advisors();

    abstract ImmutableList<Advice> subTypeRestrictedAdvisors();

    String getDesc() {
        ImmutableList<String> parameterTypes = this.parameterTypes();
        Type[] types = new Type[parameterTypes.size()];
        for (int i = 0; i < parameterTypes.size(); ++i) {
            types[i] = AnalyzedMethod.getType((String)parameterTypes.get(i));
        }
        return Type.getMethodDescriptor(AnalyzedMethod.getType(this.returnType()), types);
    }

    boolean isOverriddenBy(String methodName, List<Type> parameterTypes) {
        if (Modifier.isStatic(this.modifiers())) {
            return false;
        }
        if (Modifier.isPrivate(this.modifiers())) {
            return false;
        }
        if (!methodName.equals(this.name())) {
            return false;
        }
        if (parameterTypes.size() != this.parameterTypes().size()) {
            return false;
        }
        for (int i = 0; i < parameterTypes.size(); ++i) {
            if (parameterTypes.get(i).getClassName().equals(this.parameterTypes().get(i))) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static Type getType(String type) {
        if (type.equals(Void.TYPE.getName())) {
            return Type.VOID_TYPE;
        }
        if (type.equals(Boolean.TYPE.getName())) {
            return Type.BOOLEAN_TYPE;
        }
        if (type.equals(Character.TYPE.getName())) {
            return Type.CHAR_TYPE;
        }
        if (type.equals(Byte.TYPE.getName())) {
            return Type.BYTE_TYPE;
        }
        if (type.equals(Short.TYPE.getName())) {
            return Type.SHORT_TYPE;
        }
        if (type.equals(Integer.TYPE.getName())) {
            return Type.INT_TYPE;
        }
        if (type.equals(Float.TYPE.getName())) {
            return Type.FLOAT_TYPE;
        }
        if (type.equals(Long.TYPE.getName())) {
            return Type.LONG_TYPE;
        }
        if (type.equals(Double.TYPE.getName())) {
            return Type.DOUBLE_TYPE;
        }
        if (type.endsWith("[]")) {
            return AnalyzedMethod.getArrayType(type);
        }
        return Type.getObjectType(type.replace('.', '/'));
    }

    private static Type getArrayType(String type) {
        StringBuilder sb = new StringBuilder();
        String remaining = type;
        while (remaining.endsWith("[]")) {
            sb.append("[");
            remaining = remaining.substring(0, remaining.length() - 2);
        }
        Type elementType = AnalyzedMethod.getType(remaining);
        sb.append(elementType.getDescriptor());
        return Type.getType(sb.toString());
    }
}

