/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Sets;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glowroot.instrumentation.api.MessageSupplier;
import org.glowroot.instrumentation.api.MethodInfo;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.engine.bytecode.api.BytecodeService;
import org.glowroot.instrumentation.engine.bytecode.api.MessageTemplate;
import org.glowroot.instrumentation.engine.bytecode.api.ThreadContextPlus;
import org.glowroot.instrumentation.engine.bytecode.api.ThreadContextThreadLocal;
import org.glowroot.instrumentation.engine.impl.OptionalThreadContextImpl;
import org.glowroot.instrumentation.engine.spi.AgentSPI;
import org.glowroot.instrumentation.engine.weaving.BootstrapMetaHolders;
import org.glowroot.instrumentation.engine.weaving.GenericMessageSupplier;
import org.glowroot.instrumentation.engine.weaving.MessageTemplateImpl;
import org.glowroot.instrumentation.engine.weaving.PreloadSomeSuperTypesCache;

public class BytecodeServiceImpl
implements BytecodeService {
    private static final boolean DEBUG_MAIN_CLASS = Boolean.getBoolean("ai.debug.mainClass");
    private static final Logger logger = LoggerFactory.getLogger(BytecodeServiceImpl.class);
    private final ThreadContextThreadLocal threadContextThreadLocal;
    private final AgentSPI agentSPI;
    private final List<OnEnteringMain> onEnteringMainList = Lists.newCopyOnWriteArrayList();
    private final AtomicBoolean hasRunOnEnteringMain = new AtomicBoolean();
    @MonotonicNonNull
    private volatile Runnable onExitingGetPlatformMBeanServer;
    private final AtomicBoolean hasRunOnExitingGetPlatformMBeanServer = new AtomicBoolean();
    private final List<String> tryToLoadInBootstrapClassLoader;
    private final PreloadSomeSuperTypesCache preloadSomeSuperTypesCache;
    private final ThreadLocal<Set<String>> currentlyLoadingTypesHolder = new ThreadLocal();

    public BytecodeServiceImpl(ThreadContextThreadLocal threadContextThreadLocal, AgentSPI agentSPI, List<String> tryToLoadInBootstrapClassLoader, PreloadSomeSuperTypesCache preloadSomeSuperTypesCache) {
        this.threadContextThreadLocal = threadContextThreadLocal;
        this.agentSPI = agentSPI;
        this.tryToLoadInBootstrapClassLoader = tryToLoadInBootstrapClassLoader;
        this.preloadSomeSuperTypesCache = preloadSomeSuperTypesCache;
    }

    public void addOnEnteringMain(OnEnteringMain onEnteringMain) {
        this.onEnteringMainList.add(onEnteringMain);
    }

    public void setOnExitingGetPlatformMBeanServer(Runnable onExitingGetPlatformMBeanServer) {
        this.onExitingGetPlatformMBeanServer = onExitingGetPlatformMBeanServer;
    }

    @Override
    public boolean tryToLoadInBootstrapClassLoader(String className) {
        if (className.startsWith("org.glowroot.instrumentation.")) {
            return true;
        }
        for (String prefix : this.tryToLoadInBootstrapClassLoader) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void enteringMainMethod(String mainClass, @Nullable String[] mainArgs) {
        this.enteringMainMethod(mainClass, mainArgs, mainClass, "main");
    }

    @Override
    public void enteringApacheCommonsDaemonLoadMethod(String mainClass, @Nullable String[] mainArgs) {
        this.enteringMainMethod(mainClass, mainArgs, "org.apache.commons.daemon.support.DaemonLoader", "load");
    }

    @Override
    public void enteringPossibleProcrunStartMethod(String className, String methodName, @Nullable String[] methodArgs) {
        this.enteringMainMethod(className, methodArgs, className, methodName);
    }

    @Override
    public void exitingGetPlatformMBeanServer() {
        if (this.onExitingGetPlatformMBeanServer == null) {
            return;
        }
        if (this.hasRunOnExitingGetPlatformMBeanServer.getAndSet(true)) {
            return;
        }
        try {
            this.onExitingGetPlatformMBeanServer.run();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    @Override
    public ThreadContextThreadLocal.Holder getCurrentThreadContextHolder() {
        return this.threadContextThreadLocal.getHolder();
    }

    @Override
    public ThreadContextPlus createOptionalThreadContext(ThreadContextThreadLocal.Holder threadContextHolder, int currentNestingGroupId, int currentSuppressionKeyId) {
        return new OptionalThreadContextImpl(this.agentSPI, threadContextHolder, currentNestingGroupId, currentSuppressionKeyId);
    }

    @Override
    public Object getClassMeta(int index) throws Exception {
        return BootstrapMetaHolders.getClassMeta(index);
    }

    @Override
    public Object getMethodMeta(int index) throws Exception {
        return BootstrapMetaHolders.getMethodMeta(index);
    }

    @Override
    public MessageTemplate createMessageTemplate(String template, MethodInfo methodInfo) {
        return MessageTemplateImpl.create(template, methodInfo);
    }

    @Override
    public MessageSupplier createMessageSupplier(MessageTemplate template, Object receiver, String methodName, Object ... args) {
        return GenericMessageSupplier.create((MessageTemplateImpl)template, receiver, methodName, args);
    }

    @Override
    public String getMessageText(MessageTemplate template, Object receiver, String methodName, Object ... args) {
        return GenericMessageSupplier.create((MessageTemplateImpl)template, receiver, methodName, args).getMessageText();
    }

    @Override
    public void updateWithReturnValue(Span span, @Nullable Object returnValue) {
        GenericMessageSupplier.updateWithReturnValue(span, returnValue);
    }

    @Override
    public void logThrowable(Throwable throwable) {
        logger.error(throwable.getMessage(), throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preloadSomeSuperTypes(ClassLoader loader, @Nullable String className) {
        boolean topLevel;
        if (className == null) {
            return;
        }
        Set<String> preloadSomeSuperTypes = this.preloadSomeSuperTypesCache.get(className);
        if (preloadSomeSuperTypes.isEmpty()) {
            return;
        }
        Set<String> currentlyLoadingTypes = this.currentlyLoadingTypesHolder.get();
        if (currentlyLoadingTypes == null) {
            currentlyLoadingTypes = Sets.newLinkedHashSet();
            this.currentlyLoadingTypesHolder.set(currentlyLoadingTypes);
            topLevel = true;
        } else {
            if (currentlyLoadingTypes.iterator().next().equals(className)) {
                throw new AbortPreload();
            }
            topLevel = false;
        }
        if (!currentlyLoadingTypes.add(className)) {
            return;
        }
        try {
            for (String superClassName : preloadSomeSuperTypes) {
                logger.debug("pre-loading super class {} for {}, in loader={}@{}", superClassName, className, loader.getClass().getName(), loader.hashCode());
                try {
                    Class.forName(superClassName, false, loader);
                }
                catch (ClassNotFoundException e) {
                    logger.debug("super class {} not found (for sub-class {})", superClassName, className, e);
                }
                catch (LinkageError e) {
                    logger.debug("linkage error occurred while loading super class {} (for sub-class {})", superClassName, className, e);
                }
                catch (AbortPreload abortPreload) {}
            }
        }
        finally {
            if (topLevel) {
                this.currentlyLoadingTypesHolder.remove();
            } else {
                currentlyLoadingTypes.remove(className);
            }
        }
    }

    private void enteringMainMethod(String className, @Nullable String[] methodArgs, String expectedTopLevelClassName, String expectedTopLevelMethodName) {
        if (this.onEnteringMainList == null) {
            if (DEBUG_MAIN_CLASS) {
                logger.info("entering {}.main(), but callback not set yet", (Object)className, (Object)new Exception("location stack trace"));
            }
            return;
        }
        if (this.hasRunOnEnteringMain.get()) {
            return;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (BytecodeServiceImpl.ignoreMainClass(expectedTopLevelClassName, expectedTopLevelMethodName, stackTrace)) {
            if (DEBUG_MAIN_CLASS) {
                logger.info("ignoring {}.main()", (Object)className, (Object)new Exception("location stack trace"));
            }
            return;
        }
        if (className.equals("com.ibm.java.diagnostics.healthcenter.agent.mbean.HCLaunchMBean")) {
            return;
        }
        if (this.hasRunOnEnteringMain.getAndSet(true)) {
            return;
        }
        String unwrappedMainClass = className.startsWith("org.tanukisoftware.wrapper.") && methodArgs != null && methodArgs.length > 0 ? methodArgs[0] : className;
        if (DEBUG_MAIN_CLASS) {
            logger.info("entering {}.main()", (Object)className, (Object)new Exception("location stack trace"));
        }
        try {
            for (OnEnteringMain onEnteringMain : this.onEnteringMainList) {
                onEnteringMain.run(unwrappedMainClass);
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    private static boolean ignoreMainClass(String expectedTopLevelClass, String expectedTopLevelMethodName, StackTraceElement[] stackTrace) {
        if (stackTrace.length == 0) {
            return true;
        }
        StackTraceElement topStackTraceElement = stackTrace[stackTrace.length - 1];
        return !topStackTraceElement.getClassName().equals(expectedTopLevelClass) || !expectedTopLevelMethodName.equals(topStackTraceElement.getMethodName());
    }

    private static class AbortPreload
    extends RuntimeException {
        private AbortPreload() {
        }
    }

    public static interface OnEnteringMain {
        public void run(@Nullable String var1) throws Exception;
    }
}

