/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Maps;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Sets;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.hash.Hasher;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.hash.Hashing;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Closer;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

class ClassLoaders {
    private static final Logger logger = LoggerFactory.getLogger(ClassLoaders.class);
    private static final Object lock = new Object();

    private ClassLoaders() {
    }

    static void defineClassesInBootstrapClassLoader(Collection<LazyDefinedClass> lazyDefinedClasses, Instrumentation instrumentation, File tmpDir, String fileNamePrefix) throws IOException {
        if (lazyDefinedClasses.isEmpty()) {
            return;
        }
        Collection<LazyDefinedClass> flattenedAndOrderedList = ClassLoaders.getFlattenedAndOrderedList(lazyDefinedClasses);
        String uniqueHash = ClassLoaders.getUniqueHash(flattenedAndOrderedList);
        File generatedJarFile = new File(tmpDir, fileNamePrefix + uniqueHash + ".jar");
        if (!generatedJarFile.exists()) {
            File tmpFile = ClassLoaders.createTempFile(fileNamePrefix + uniqueHash, ".jar", tmpDir);
            Closer closer = Closer.create();
            try {
                FileOutputStream out = closer.register(new FileOutputStream(tmpFile));
                JarOutputStream jarOut = closer.register(new JarOutputStream(out));
                ClassLoaders.generate(flattenedAndOrderedList, jarOut);
            }
            catch (Throwable t) {
                throw closer.rethrow(t);
            }
            finally {
                closer.close();
            }
            if (!tmpFile.renameTo(generatedJarFile)) {
                if (!generatedJarFile.exists()) {
                    logger.warn("could not rename file {} to {}", (Object)tmpFile.getAbsolutePath(), (Object)generatedJarFile.getAbsolutePath());
                    generatedJarFile = tmpFile;
                } else if (!tmpFile.delete()) {
                    logger.warn("could not delete file {}", (Object)tmpFile.getAbsolutePath());
                }
            }
        }
        instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(generatedJarFile));
        ClassLoaders.appendToBootstrapResourcePath(generatedJarFile);
    }

    static void defineClasses(Collection<LazyDefinedClass> lazyDefinedClasses, ClassLoader loader) throws Exception {
        for (LazyDefinedClass lazyDefinedClass : lazyDefinedClasses) {
            ClassLoaders.defineClass(lazyDefinedClass, loader);
        }
    }

    static void defineClassIfNotExists(LazyDefinedClass lazyDefinedClass, ClassLoader loader) throws Exception {
        ClassLoaders.defineClassIfNotExists(lazyDefinedClass, loader, new HashSet<Type>());
    }

    static void defineClass(String name, byte[] bytes, ClassLoader loader) throws Exception {
        Method defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        defineClassMethod.setAccessible(true);
        defineClassMethod.invoke((Object)loader, name, bytes, 0, bytes.length);
    }

    static void createDirectoryOrCleanPreviousContentsWithPrefix(File dir, String prefix) throws IOException {
        ClassLoaders.deleteIfRegularFile(dir);
        if (dir.exists()) {
            ClassLoaders.deleteFilesWithPrefix(dir, prefix);
        } else {
            ClassLoaders.createDirectory(dir);
        }
    }

    private static void defineClass(LazyDefinedClass lazyDefinedClass, ClassLoader loader) throws Exception {
        for (LazyDefinedClass dependency : lazyDefinedClass.getDependencies()) {
            ClassLoaders.defineClass(dependency, loader);
        }
        ClassLoaders.defineClass(lazyDefinedClass.getType().getClassName(), lazyDefinedClass.getBytes(), loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void defineClassIfNotExists(LazyDefinedClass lazyDefinedClass, ClassLoader loader, Set<Type> alreadyDefinedOrToBeDefined) throws Exception {
        if (!alreadyDefinedOrToBeDefined.add(lazyDefinedClass.getType())) {
            return;
        }
        for (LazyDefinedClass dependency : lazyDefinedClass.getDependencies()) {
            ClassLoaders.defineClassIfNotExists(dependency, loader, alreadyDefinedOrToBeDefined);
        }
        String className = lazyDefinedClass.getType().getClassName();
        Object object = lock;
        synchronized (object) {
            if (!ClassLoaders.classExists(className, loader)) {
                ClassLoaders.defineClass(className, lazyDefinedClass.getBytes(), loader);
            }
        }
    }

    private static boolean classExists(String name, ClassLoader loader) throws Exception {
        Method findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
        findLoadedClassMethod.setAccessible(true);
        return findLoadedClassMethod.invoke((Object)loader, name) != null;
    }

    private static void generate(Collection<LazyDefinedClass> flattenedAndOrderedList, JarOutputStream jarOut) throws IOException {
        for (LazyDefinedClass lazyDefinedClass : flattenedAndOrderedList) {
            JarEntry jarEntry = new JarEntry(lazyDefinedClass.getType().getInternalName() + ".class");
            jarOut.putNextEntry(jarEntry);
            jarOut.write(lazyDefinedClass.getBytes());
            jarOut.closeEntry();
        }
    }

    private static void deleteIfRegularFile(File file) throws IOException {
        if (file.isFile() && !file.delete()) {
            logger.debug("could not delete file: " + file.getAbsolutePath());
        }
    }

    private static void deleteFilesWithPrefix(File dir, String prefix) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("Could not get listing for directory: " + dir.getAbsolutePath());
        }
        for (File file : files) {
            if (!file.getName().startsWith(prefix) || file.delete()) continue;
            logger.debug("could not delete file: " + file.getAbsolutePath());
        }
    }

    private static void createDirectory(File dir) throws IOException {
        if (!dir.mkdirs()) {
            throw new IOException("Could not create directory: " + dir.getAbsolutePath());
        }
    }

    private static void appendToBootstrapResourcePath(File generatedJarFile) {
        try {
            Class<?> launcherClass = Class.forName("sun.misc.Launcher", false, null);
            Method getBootstrapClassPathMethod = launcherClass.getMethod("getBootstrapClassPath", new Class[0]);
            Class<?> urlClassPathClass = Class.forName("sun.misc.URLClassPath", false, null);
            Method addUrlMethod = urlClassPathClass.getMethod("addURL", URL.class);
            Object urlClassPath = getBootstrapClassPathMethod.invoke(null, new Object[0]);
            addUrlMethod.invoke(urlClassPath, generatedJarFile.toURI().toURL());
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), e);
        }
    }

    private static Collection<LazyDefinedClass> getFlattenedAndOrderedList(Collection<LazyDefinedClass> lazyDefinedClasses) {
        TreeMap<String, LazyDefinedClass> flattenedMap = Maps.newTreeMap();
        ClassLoaders.put(flattenedMap, lazyDefinedClasses);
        return flattenedMap.values();
    }

    private static void put(Map<String, LazyDefinedClass> flattenedMap, Collection<LazyDefinedClass> lazyDefinedClasses) {
        for (LazyDefinedClass lazyDefinedClass : lazyDefinedClasses) {
            flattenedMap.put(lazyDefinedClass.getType().getInternalName(), lazyDefinedClass);
            ClassLoaders.put(flattenedMap, lazyDefinedClass.getDependencies());
        }
    }

    private static File createTempFile(String prefix, String suffix, File tmpDir) throws IOException {
        String baseName = prefix + "-" + System.currentTimeMillis() + "-";
        for (int i = 0; i < 10000; ++i) {
            File tempFile = new File(tmpDir, baseName + i + suffix);
            if (!tempFile.createNewFile()) continue;
            return tempFile;
        }
        throw new IOException("Could not create temp file, tried " + baseName + "0" + suffix + " through " + baseName + "999" + suffix);
    }

    private static String getUniqueHash(Collection<LazyDefinedClass> flattened) {
        Hasher hasher = Hashing.sha1().newHasher();
        for (LazyDefinedClass lazyDefinedClass : flattened) {
            hasher.putBytes(lazyDefinedClass.getBytes());
        }
        return hasher.hash().toString();
    }

    static class LazyDefinedClass {
        private final Type type;
        private final byte[] bytes;
        private final Set<LazyDefinedClass> dependencies = Sets.newConcurrentHashSet();

        LazyDefinedClass(String internalName, byte[] bytes) {
            this.type = Type.getObjectType(internalName);
            this.bytes = bytes;
        }

        public Type getType() {
            return this.type;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public Set<LazyDefinedClass> getDependencies() {
            return this.dependencies;
        }
    }
}

