/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Objects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.ImmutableList;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import org.glowroot.instrumentation.engine.weaving.Advice;
import org.glowroot.instrumentation.engine.weaving.AnalyzedMethod;
import org.immutables.value.Generated;

@Generated(from="AnalyzedMethod", generator="Immutables")
final class ImmutableAnalyzedMethod
extends AnalyzedMethod {
    private final String name;
    private final ImmutableList<String> parameterTypes;
    private final String returnType;
    private final int modifiers;
    @Nullable
    private final String signature;
    private final ImmutableList<String> exceptions;
    private final ImmutableList<Advice> advisors;
    private final ImmutableList<Advice> subTypeRestrictedAdvisors;

    private ImmutableAnalyzedMethod(String name, ImmutableList<String> parameterTypes, String returnType, int modifiers, @Nullable String signature, ImmutableList<String> exceptions, ImmutableList<Advice> advisors, ImmutableList<Advice> subTypeRestrictedAdvisors) {
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.modifiers = modifiers;
        this.signature = signature;
        this.exceptions = exceptions;
        this.advisors = advisors;
        this.subTypeRestrictedAdvisors = subTypeRestrictedAdvisors;
    }

    @Override
    String name() {
        return this.name;
    }

    @Override
    ImmutableList<String> parameterTypes() {
        return this.parameterTypes;
    }

    @Override
    String returnType() {
        return this.returnType;
    }

    @Override
    int modifiers() {
        return this.modifiers;
    }

    @Override
    @Nullable
    String signature() {
        return this.signature;
    }

    @Override
    ImmutableList<String> exceptions() {
        return this.exceptions;
    }

    @Override
    ImmutableList<Advice> advisors() {
        return this.advisors;
    }

    @Override
    ImmutableList<Advice> subTypeRestrictedAdvisors() {
        return this.subTypeRestrictedAdvisors;
    }

    public final ImmutableAnalyzedMethod withName(String value) {
        String newValue = Preconditions.checkNotNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableAnalyzedMethod(newValue, this.parameterTypes, this.returnType, this.modifiers, this.signature, this.exceptions, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withParameterTypes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, newValue, this.returnType, this.modifiers, this.signature, this.exceptions, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withParameterTypes(Iterable<String> elements) {
        if (this.parameterTypes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, newValue, this.returnType, this.modifiers, this.signature, this.exceptions, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withReturnType(String value) {
        String newValue = Preconditions.checkNotNull(value, "returnType");
        if (this.returnType.equals(newValue)) {
            return this;
        }
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, newValue, this.modifiers, this.signature, this.exceptions, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withModifiers(int value) {
        if (this.modifiers == value) {
            return this;
        }
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, value, this.signature, this.exceptions, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withSignature(@Nullable String value) {
        if (Objects.equal(this.signature, value)) {
            return this;
        }
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, value, this.exceptions, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withExceptions(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, newValue, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withExceptions(Iterable<String> elements) {
        if (this.exceptions == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, newValue, this.advisors, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withAdvisors(Advice ... elements) {
        ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, this.exceptions, newValue, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withAdvisors(Iterable<? extends Advice> elements) {
        if (this.advisors == elements) {
            return this;
        }
        ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, this.exceptions, newValue, this.subTypeRestrictedAdvisors);
    }

    public final ImmutableAnalyzedMethod withSubTypeRestrictedAdvisors(Advice ... elements) {
        ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, this.exceptions, this.advisors, newValue);
    }

    public final ImmutableAnalyzedMethod withSubTypeRestrictedAdvisors(Iterable<? extends Advice> elements) {
        if (this.subTypeRestrictedAdvisors == elements) {
            return this;
        }
        ImmutableList<Advice> newValue = ImmutableList.copyOf(elements);
        return new ImmutableAnalyzedMethod(this.name, this.parameterTypes, this.returnType, this.modifiers, this.signature, this.exceptions, this.advisors, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAnalyzedMethod && this.equalTo((ImmutableAnalyzedMethod)another);
    }

    private boolean equalTo(ImmutableAnalyzedMethod another) {
        return this.name.equals(another.name) && this.parameterTypes.equals(another.parameterTypes) && this.returnType.equals(another.returnType) && this.modifiers == another.modifiers && Objects.equal(this.signature, another.signature) && this.exceptions.equals(another.exceptions) && this.advisors.equals(another.advisors) && this.subTypeRestrictedAdvisors.equals(another.subTypeRestrictedAdvisors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.parameterTypes.hashCode();
        h += (h << 5) + this.returnType.hashCode();
        h += (h << 5) + this.modifiers;
        h += (h << 5) + Objects.hashCode(this.signature);
        h += (h << 5) + this.exceptions.hashCode();
        h += (h << 5) + this.advisors.hashCode();
        h += (h << 5) + this.subTypeRestrictedAdvisors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AnalyzedMethod").omitNullValues().add("name", this.name).add("parameterTypes", this.parameterTypes).add("returnType", this.returnType).add("modifiers", this.modifiers).add("signature", this.signature).add("exceptions", this.exceptions).add("advisors", this.advisors).add("subTypeRestrictedAdvisors", this.subTypeRestrictedAdvisors).toString();
    }

    public static ImmutableAnalyzedMethod copyOf(AnalyzedMethod instance) {
        if (instance instanceof ImmutableAnalyzedMethod) {
            return (ImmutableAnalyzedMethod)instance;
        }
        return ImmutableAnalyzedMethod.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AnalyzedMethod", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_RETURN_TYPE = 2L;
        private static final long INIT_BIT_MODIFIERS = 4L;
        private long initBits = 7L;
        private String name;
        private ImmutableList.Builder<String> parameterTypes = ImmutableList.builder();
        private String returnType;
        private int modifiers;
        private String signature;
        private ImmutableList.Builder<String> exceptions = ImmutableList.builder();
        private ImmutableList.Builder<Advice> advisors = ImmutableList.builder();
        private ImmutableList.Builder<Advice> subTypeRestrictedAdvisors = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(AnalyzedMethod instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.name(instance.name());
            this.addAllParameterTypes(instance.parameterTypes());
            this.returnType(instance.returnType());
            this.modifiers(instance.modifiers());
            String signatureValue = instance.signature();
            if (signatureValue != null) {
                this.signature(signatureValue);
            }
            this.addAllExceptions(instance.exceptions());
            this.addAllAdvisors(instance.advisors());
            this.addAllSubTypeRestrictedAdvisors(instance.subTypeRestrictedAdvisors());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addParameterTypes(String element) {
            this.parameterTypes.add((Object)element);
            return this;
        }

        public final Builder addParameterTypes(String ... elements) {
            this.parameterTypes.add(elements);
            return this;
        }

        public final Builder parameterTypes(Iterable<String> elements) {
            this.parameterTypes = ImmutableList.builder();
            return this.addAllParameterTypes(elements);
        }

        public final Builder addAllParameterTypes(Iterable<String> elements) {
            this.parameterTypes.addAll((Iterable)elements);
            return this;
        }

        public final Builder returnType(String returnType) {
            this.returnType = Preconditions.checkNotNull(returnType, "returnType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder modifiers(int modifiers) {
            this.modifiers = modifiers;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder signature(@Nullable String signature) {
            this.signature = signature;
            return this;
        }

        public final Builder addExceptions(String element) {
            this.exceptions.add((Object)element);
            return this;
        }

        public final Builder addExceptions(String ... elements) {
            this.exceptions.add(elements);
            return this;
        }

        public final Builder exceptions(Iterable<String> elements) {
            this.exceptions = ImmutableList.builder();
            return this.addAllExceptions(elements);
        }

        public final Builder addAllExceptions(Iterable<String> elements) {
            this.exceptions.addAll((Iterable)elements);
            return this;
        }

        public final Builder addAdvisors(Advice element) {
            this.advisors.add((Object)element);
            return this;
        }

        public final Builder addAdvisors(Advice ... elements) {
            this.advisors.add(elements);
            return this;
        }

        public final Builder advisors(Iterable<? extends Advice> elements) {
            this.advisors = ImmutableList.builder();
            return this.addAllAdvisors(elements);
        }

        public final Builder addAllAdvisors(Iterable<? extends Advice> elements) {
            this.advisors.addAll(elements);
            return this;
        }

        public final Builder addSubTypeRestrictedAdvisors(Advice element) {
            this.subTypeRestrictedAdvisors.add((Object)element);
            return this;
        }

        public final Builder addSubTypeRestrictedAdvisors(Advice ... elements) {
            this.subTypeRestrictedAdvisors.add(elements);
            return this;
        }

        public final Builder subTypeRestrictedAdvisors(Iterable<? extends Advice> elements) {
            this.subTypeRestrictedAdvisors = ImmutableList.builder();
            return this.addAllSubTypeRestrictedAdvisors(elements);
        }

        public final Builder addAllSubTypeRestrictedAdvisors(Iterable<? extends Advice> elements) {
            this.subTypeRestrictedAdvisors.addAll(elements);
            return this;
        }

        public ImmutableAnalyzedMethod build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAnalyzedMethod(this.name, (ImmutableList)this.parameterTypes.build(), this.returnType, this.modifiers, this.signature, (ImmutableList)this.exceptions.build(), (ImmutableList)this.advisors.build(), (ImmutableList)this.subTypeRestrictedAdvisors.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("returnType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("modifiers");
            }
            return "Cannot build AnalyzedMethod, some of required attributes are not set " + attributes;
        }
    }
}

