/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Objects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import java.security.CodeSource;
import java.util.ArrayList;
import org.glowroot.instrumentation.engine.weaving.AnalyzedWorld;
import org.immutables.value.Generated;

@Generated(from="AnalyzedWorld.ParseContext", generator="Immutables")
final class ImmutableParseContext
extends AnalyzedWorld.ParseContext {
    private final String className;
    @Nullable
    private final CodeSource codeSource;

    private ImmutableParseContext(String className, @Nullable CodeSource codeSource) {
        this.className = className;
        this.codeSource = codeSource;
    }

    @Override
    String className() {
        return this.className;
    }

    @Override
    @Nullable
    CodeSource codeSource() {
        return this.codeSource;
    }

    public final ImmutableParseContext withClassName(String value) {
        String newValue = Preconditions.checkNotNull(value, "className");
        if (this.className.equals(newValue)) {
            return this;
        }
        return new ImmutableParseContext(newValue, this.codeSource);
    }

    public final ImmutableParseContext withCodeSource(@Nullable CodeSource value) {
        if (this.codeSource == value) {
            return this;
        }
        return new ImmutableParseContext(this.className, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParseContext && this.equalTo((ImmutableParseContext)another);
    }

    private boolean equalTo(ImmutableParseContext another) {
        return this.className.equals(another.className) && Objects.equal(this.codeSource, another.codeSource);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.className.hashCode();
        h += (h << 5) + Objects.hashCode(this.codeSource);
        return h;
    }

    public static ImmutableParseContext copyOf(AnalyzedWorld.ParseContext instance) {
        if (instance instanceof ImmutableParseContext) {
            return (ImmutableParseContext)instance;
        }
        return ImmutableParseContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AnalyzedWorld.ParseContext", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CLASS_NAME = 1L;
        private long initBits = 1L;
        private String className;
        private CodeSource codeSource;

        private Builder() {
        }

        public final Builder from(AnalyzedWorld.ParseContext instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.className(instance.className());
            CodeSource codeSourceValue = instance.codeSource();
            if (codeSourceValue != null) {
                this.codeSource(codeSourceValue);
            }
            return this;
        }

        public final Builder className(String className) {
            this.className = Preconditions.checkNotNull(className, "className");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder codeSource(@Nullable CodeSource codeSource) {
            this.codeSource = codeSource;
            return this;
        }

        public ImmutableParseContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableParseContext(this.className, this.codeSource);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("className");
            }
            return "Cannot build ParseContext, some of required attributes are not set " + attributes;
        }
    }
}

