/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Sets;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassReader;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassWriter;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.ClassRemapper;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.commons.Remapper;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.glowroot.instrumentation.engine.weaving.Advice;
import org.glowroot.instrumentation.engine.weaving.ClassLoaders;
import org.glowroot.instrumentation.engine.weaving.ImmutableAdvice;
import org.glowroot.instrumentation.engine.weaving.InstrumentationDetail;
import org.glowroot.instrumentation.engine.weaving.InstrumentationDetailBuilder;

class InstrumentationClassRenamer {
    static final String SHIM_SUFFIX = "Shim";
    static final String MIXIN_SUFFIX = "Mixin";
    private static final Logger logger = LoggerFactory.getLogger(InstrumentationClassRenamer.class);
    private final InstrumentationDetail.PointcutClass adviceClass;
    private final String rootPackageName;
    private final String bootstrapClassLoaderPackageName;
    private final Map<String, ClassLoaders.LazyDefinedClass> collocatedClassCache;

    InstrumentationClassRenamer(InstrumentationDetail.PointcutClass adviceClass, Map<String, ClassLoaders.LazyDefinedClass> collocatedClassCache) {
        this.adviceClass = adviceClass;
        String internalName = adviceClass.type().getInternalName();
        int index = internalName.lastIndexOf(47);
        this.rootPackageName = index == -1 ? "" : internalName.substring(0, index);
        this.bootstrapClassLoaderPackageName = this.rootPackageName + "/boot/";
        this.collocatedClassCache = collocatedClassCache;
    }

    @Nullable
    Advice buildNonBootstrapLoaderAdvice(Advice advice) {
        if (this.rootPackageName.isEmpty()) {
            logger.warn("advice needs to be in a named package in order to collocate the advice in the class loader that it is used from (as opposed to located in the bootstrap class loader)");
            return null;
        }
        return ImmutableAdvice.builder().from(advice).adviceType(advice.adviceType()).travelerType(advice.travelerType()).isEnabledAdvice(advice.isEnabledAdvice()).onBeforeAdvice(advice.onBeforeAdvice()).onReturnAdvice(advice.onReturnAdvice()).onThrowAdvice(advice.onThrowAdvice()).onAfterAdvice(advice.onAfterAdvice()).isEnabledParameters(advice.isEnabledParameters()).onBeforeParameters(advice.onBeforeParameters()).onReturnParameters(advice.onReturnParameters()).onThrowParameters(advice.onThrowParameters()).onAfterParameters(advice.onAfterParameters()).build();
    }

    @Nullable
    ClassLoaders.LazyDefinedClass buildNonBootstrapLoaderAdviceClass() throws IOException {
        if (this.rootPackageName.isEmpty()) {
            logger.warn("advice needs to be in a named package in order to co-locate the advice in the class loader that it is used from (as opposed to located in the bootstrap class loader)");
            return null;
        }
        return this.build(this.adviceClass.type().getInternalName(), this.adviceClass.bytes());
    }

    private ClassLoaders.LazyDefinedClass build(String internalName, byte[] bytes) throws IOException {
        ClassLoaders.LazyDefinedClass lazyDefinedClass = this.collocatedClassCache.get(internalName);
        if (lazyDefinedClass != null) {
            return lazyDefinedClass;
        }
        InstrumentationClassRemapper remapper = new InstrumentationClassRemapper();
        if (bytes == null) {
            bytes = InstrumentationDetailBuilder.getBytes(internalName, this.adviceClass.jarFile());
        }
        lazyDefinedClass = new ClassLoaders.LazyDefinedClass(remapper.mapType(internalName), bytes);
        this.collocatedClassCache.put(internalName, lazyDefinedClass);
        ClassWriter cw = new ClassWriter(0);
        ClassRemapper cv = new ClassRemapper(cw, remapper);
        ClassReader cr = new ClassReader(bytes);
        cr.accept(cv, 0);
        for (String dependencyName : remapper.dependencyNames) {
            if (dependencyName.equals(internalName)) continue;
            lazyDefinedClass.getDependencies().add(this.build(dependencyName, null));
        }
        return lazyDefinedClass;
    }

    private class InstrumentationClassRemapper
    extends Remapper {
        private final Set<String> dependencyNames = Sets.newHashSet();

        private InstrumentationClassRemapper() {
        }

        @Override
        public String map(String internalName) {
            if (this.collocate(internalName)) {
                this.dependencyNames.add(internalName);
            }
            return internalName;
        }

        private boolean collocate(String internalName) {
            return internalName.startsWith(InstrumentationClassRenamer.this.rootPackageName) && !internalName.endsWith(InstrumentationClassRenamer.MIXIN_SUFFIX) && !internalName.endsWith(InstrumentationClassRenamer.SHIM_SUFFIX) && !internalName.startsWith(InstrumentationClassRenamer.this.bootstrapClassLoaderPackageName);
        }
    }
}

