/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Iterables;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Maps;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.io.Resources;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.AnnotationVisitor;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassReader;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassVisitor;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.MethodVisitor;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.engine.config.InstrumentationDescriptor;
import org.glowroot.instrumentation.engine.util.OnlyUsedByTests;
import org.glowroot.instrumentation.engine.weaving.ClassNames;
import org.glowroot.instrumentation.engine.weaving.ImmutableBindAnnotation;
import org.glowroot.instrumentation.engine.weaving.ImmutableInstrumentationDetail;
import org.glowroot.instrumentation.engine.weaving.ImmutableMixinType;
import org.glowroot.instrumentation.engine.weaving.ImmutablePointcutClass;
import org.glowroot.instrumentation.engine.weaving.ImmutablePointcutMethod;
import org.glowroot.instrumentation.engine.weaving.InstrumentationDetail;
import org.glowroot.instrumentation.engine.weaving.MixinType;
import org.glowroot.instrumentation.engine.weaving.ShimType;

class InstrumentationDetailBuilder {
    private static final Logger logger = LoggerFactory.getLogger(InstrumentationDetailBuilder.class);
    private InstrumentationDescriptor instrumentationDescriptor;

    InstrumentationDetailBuilder(InstrumentationDescriptor instrumentationDescriptor) {
        this.instrumentationDescriptor = instrumentationDescriptor;
    }

    InstrumentationDetail build() throws IOException, ClassNotFoundException {
        ImmutableInstrumentationDetail.Builder builder = ImmutableInstrumentationDetail.builder();
        for (String clazz : this.instrumentationDescriptor.classes()) {
            String internalName = ClassNames.toInternalName(clazz);
            byte[] bytes = InstrumentationDetailBuilder.getBytes(internalName, this.instrumentationDescriptor.jarFile());
            InstrumentationClassVisitor cv = new InstrumentationClassVisitor(internalName);
            new ClassReader(bytes).accept(cv, 1);
            for (String innerClassName : cv.innerClassNames) {
                bytes = InstrumentationDetailBuilder.getBytes(innerClassName, this.instrumentationDescriptor.jarFile());
                MemberClassVisitor mcv = new MemberClassVisitor();
                new ClassReader(bytes).accept(mcv, 1);
                if (mcv.pointcutAnnotationVisitor != null) {
                    builder.addPointcutClasses((InstrumentationDetail.PointcutClass)mcv.buildPointcutClass(bytes, this.instrumentationDescriptor.collocate(), this.instrumentationDescriptor.jarFile()));
                    continue;
                }
                if (mcv.mixinAnnotationVisitor != null) {
                    builder.addMixinTypes(mcv.buildMixinType(this.instrumentationDescriptor.collocate(), bytes));
                    continue;
                }
                if (!mcv.shim) continue;
                builder.addShimTypes(mcv.buildShimType(this.instrumentationDescriptor.collocate()));
            }
        }
        return builder.build();
    }

    static InstrumentationDetail.PointcutClass buildAdviceClass(byte[] bytes) {
        MemberClassVisitor acv = new MemberClassVisitor();
        new ClassReader(bytes).accept(acv, 1);
        return acv.buildPointcutClass(bytes, false, null);
    }

    static byte[] getBytes(String className, @Nullable File jarFile) throws IOException {
        String resourceName = "/" + className + ".class";
        URL url = InstrumentationDetailBuilder.class.getResource(resourceName);
        if (url != null) {
            return Resources.toByteArray(url);
        }
        if (jarFile != null) {
            url = new URL("jar:" + jarFile.toURI() + "!" + resourceName);
            return Resources.toByteArray(url);
        }
        throw new IOException("Class not found: " + className);
    }

    @OnlyUsedByTests
    static InstrumentationDetail.PointcutClass buildAdviceClass(Class<?> clazz) throws IOException {
        return InstrumentationDetailBuilder.buildAdviceClassLookAtSuperClass(ClassNames.toInternalName(clazz.getName()));
    }

    @OnlyUsedByTests
    static MixinType buildMixinType(Class<?> clazz) throws IOException {
        URL url = Preconditions.checkNotNull(InstrumentationDetailBuilder.class.getResource("/" + ClassNames.toInternalName(clazz.getName()) + ".class"));
        byte[] bytes = Resources.asByteSource(url).read();
        MemberClassVisitor mcv = new MemberClassVisitor();
        new ClassReader(bytes).accept(mcv, 1);
        return mcv.buildMixinType(false, bytes);
    }

    private static InstrumentationDetail.PointcutClass buildAdviceClassLookAtSuperClass(String internalName) throws IOException {
        URL url = Preconditions.checkNotNull(InstrumentationDetailBuilder.class.getResource("/" + internalName + ".class"));
        byte[] bytes = Resources.asByteSource(url).read();
        MemberClassVisitor mcv = new MemberClassVisitor();
        new ClassReader(bytes).accept(mcv, 1);
        ImmutablePointcutClass pointcutClass = mcv.buildPointcutClass(bytes, false, null);
        String superName = Preconditions.checkNotNull(mcv.superName);
        if (!"java/lang/Object".equals(superName)) {
            pointcutClass = ImmutablePointcutClass.builder().from(pointcutClass).addAllMethods(InstrumentationDetailBuilder.buildAdviceClassLookAtSuperClass(superName).methods()).build();
        }
        return pointcutClass;
    }

    private static class MethodModifierArrayAnnotationVisitor
    extends AnnotationVisitor {
        private final List<Advice.MethodModifier> list;

        private MethodModifierArrayAnnotationVisitor(List<Advice.MethodModifier> list) {
            super(458752);
            this.list = list;
        }

        @Override
        public void visitEnum(String name, String descriptor, String value) {
            this.list.add(Advice.MethodModifier.valueOf(value));
        }
    }

    private static class StringArrayAnnotationVisitor
    extends AnnotationVisitor {
        private final List<String> list;

        private StringArrayAnnotationVisitor(List<String> list) {
            super(458752);
            this.list = list;
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            this.list.add((String)value);
        }
    }

    private static class MixinMethodVisitor
    extends MethodVisitor {
        private final String name;
        private final String descriptor;
        private boolean init;

        private MixinMethodVisitor(String name, String descriptor) {
            super(458752);
            this.name = name;
            this.descriptor = descriptor;
        }

        @Override
        @Nullable
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.equals("Lorg/glowroot/instrumentation/api/weaving/MixinInit;")) {
                if (Type.getArgumentTypes(this.descriptor).length > 0) {
                    throw new IllegalStateException("@MixinInit method cannot have any parameters");
                }
                if (!Type.getReturnType(this.descriptor).equals(Type.VOID_TYPE)) {
                    throw new IllegalStateException("@MixinInit method must return void");
                }
                this.init = true;
            }
            return null;
        }
    }

    private static class MixinAnnotationVisitor
    extends AnnotationVisitor {
        private List<String> values = Lists.newArrayList();

        private MixinAnnotationVisitor() {
            super(458752);
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            throw new IllegalStateException("Unexpected @Mixin attribute name: " + name);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            if ("value".equals(name)) {
                return new StringArrayAnnotationVisitor(this.values);
            }
            throw new IllegalStateException("Unexpected @Mixin attribute name: " + name);
        }

        private List<String> build() {
            return this.values;
        }
    }

    private static class BindAnnotationVisitor
    extends AnnotationVisitor {
        private final ImmutableBindAnnotation.Builder bindAnnotation;

        private BindAnnotationVisitor(ImmutableBindAnnotation.Builder bindAnnotation) {
            super(458752);
            this.bindAnnotation = bindAnnotation;
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            if (!"value".equals(name)) {
                throw new IllegalStateException("Unexpected @Bind.Argument attribute name: " + name);
            }
            this.bindAnnotation.argIndex((Integer)value);
        }
    }

    private static class PointcutMethodVisitor
    extends MethodVisitor {
        private final String name;
        private final String descriptor;
        private final List<Type> annotationTypes = Lists.newArrayList();
        private final Map<Integer, ImmutableBindAnnotation.Builder> bindAnnotations = Maps.newHashMap();

        private PointcutMethodVisitor(String name, String descriptor) {
            super(458752);
            this.name = name;
            this.descriptor = descriptor;
        }

        @Override
        @Nullable
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            this.annotationTypes.add(Type.getType(descriptor));
            return null;
        }

        @Override
        @Nullable
        public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            if (!descriptor.startsWith("Lorg/glowroot/instrumentation/api/weaving/Bind$")) {
                return null;
            }
            if (this.bindAnnotations.containsKey(parameter)) {
                throw new IllegalStateException("More than one bind annotation found on a method parameter: " + this.name + ", parameter: " + parameter);
            }
            ImmutableBindAnnotation.Builder bindAnnotation = ImmutableBindAnnotation.builder().type(Type.getType(descriptor));
            this.bindAnnotations.put(parameter, bindAnnotation);
            if (descriptor.equals("Lorg/glowroot/instrumentation/api/weaving/Bind$Argument;")) {
                return new BindAnnotationVisitor(bindAnnotation);
            }
            bindAnnotation.argIndex(-1);
            return null;
        }

        private InstrumentationDetail.PointcutMethod build() {
            ImmutablePointcutMethod.Builder builder = ImmutablePointcutMethod.builder().name(this.name).descriptor(this.descriptor).addAllAnnotationTypes(this.annotationTypes);
            for (Map.Entry<Integer, ImmutableBindAnnotation.Builder> entry : this.bindAnnotations.entrySet()) {
                builder.putBindAnnotations(entry.getKey(), entry.getValue().build());
            }
            return builder.build();
        }
    }

    private static class PointcutAnnotationVisitor
    extends AnnotationVisitor {
        private String className = "";
        private String classAnnotation = "";
        private String subTypeRestriction = "";
        private String superTypeRestriction = "";
        private String methodName = "";
        private String methodAnnotation = "";
        private List<String> methodParameterTypes = Lists.newArrayList();
        private String methodReturnType = "";
        private List<Advice.MethodModifier> methodModifiers = Lists.newArrayList();
        private String nestingGroup = "";
        private int order;
        private String suppressibleUsingKey = "";
        private String suppressionKey = "";

        private PointcutAnnotationVisitor() {
            super(458752);
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            if ("className".equals(name)) {
                this.className = (String)value;
            } else if ("classAnnotation".equals(name)) {
                this.classAnnotation = (String)value;
            } else if ("subTypeRestriction".equals(name)) {
                this.subTypeRestriction = (String)value;
            } else if ("superTypeRestriction".equals(name)) {
                this.superTypeRestriction = (String)value;
            } else if ("methodName".equals(name)) {
                this.methodName = (String)value;
            } else if ("methodAnnotation".equals(name)) {
                this.methodAnnotation = (String)value;
            } else if ("methodReturnType".equals(name)) {
                this.methodReturnType = (String)value;
            } else if ("nestingGroup".equals(name)) {
                this.nestingGroup = (String)value;
            } else if ("order".equals(name)) {
                this.order = (Integer)value;
            } else if ("suppressibleUsingKey".equals(name)) {
                this.suppressibleUsingKey = (String)value;
            } else if ("suppressionKey".equals(name)) {
                this.suppressionKey = (String)value;
            } else {
                throw new IllegalStateException("Unexpected @Advice.Pointcut attribute name: " + name);
            }
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            if ("methodParameterTypes".equals(name)) {
                return new StringArrayAnnotationVisitor(this.methodParameterTypes);
            }
            if ("methodModifiers".equals(name)) {
                return new MethodModifierArrayAnnotationVisitor(this.methodModifiers);
            }
            throw new IllegalStateException("Unexpected @Advice.Pointcut attribute name: " + name);
        }

        private Advice.Pointcut build() {
            return new Advice.Pointcut(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return Advice.Pointcut.class;
                }

                @Override
                public String className() {
                    return PointcutAnnotationVisitor.this.className;
                }

                @Override
                public String classAnnotation() {
                    return PointcutAnnotationVisitor.this.classAnnotation;
                }

                @Override
                public String subTypeRestriction() {
                    return PointcutAnnotationVisitor.this.subTypeRestriction;
                }

                @Override
                public String superTypeRestriction() {
                    return PointcutAnnotationVisitor.this.superTypeRestriction;
                }

                @Override
                public String methodName() {
                    return PointcutAnnotationVisitor.this.methodName;
                }

                @Override
                public String methodAnnotation() {
                    return PointcutAnnotationVisitor.this.methodAnnotation;
                }

                @Override
                public String[] methodParameterTypes() {
                    return Iterables.toArray(PointcutAnnotationVisitor.this.methodParameterTypes, String.class);
                }

                @Override
                public String methodReturnType() {
                    return PointcutAnnotationVisitor.this.methodReturnType;
                }

                @Override
                public Advice.MethodModifier[] methodModifiers() {
                    return Iterables.toArray(PointcutAnnotationVisitor.this.methodModifiers, Advice.MethodModifier.class);
                }

                @Override
                public String nestingGroup() {
                    return PointcutAnnotationVisitor.this.nestingGroup;
                }

                @Override
                public int order() {
                    return PointcutAnnotationVisitor.this.order;
                }

                @Override
                public String suppressibleUsingKey() {
                    return PointcutAnnotationVisitor.this.suppressibleUsingKey;
                }

                @Override
                public String suppressionKey() {
                    return PointcutAnnotationVisitor.this.suppressionKey;
                }
            };
        }
    }

    private static class MemberClassVisitor
    extends ClassVisitor {
        @MonotonicNonNull
        private String name;
        @Nullable
        private String superName;
        private String[] interfaces;
        @Nullable
        private PointcutAnnotationVisitor pointcutAnnotationVisitor;
        @Nullable
        private MixinAnnotationVisitor mixinAnnotationVisitor;
        private List<PointcutMethodVisitor> pointcutMethodVisitors = Lists.newArrayList();
        private List<MixinMethodVisitor> mixinMethodVisitors = Lists.newArrayList();
        private boolean shim;

        private MemberClassVisitor() {
            super(458752);
        }

        @Override
        public void visit(int version, int access, String name, @Nullable String signature, @Nullable String superName, String[] interfaces) {
            this.name = name;
            this.superName = superName;
            this.interfaces = interfaces;
        }

        @Override
        @Nullable
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.equals("Lorg/glowroot/instrumentation/api/weaving/Advice$Pointcut;")) {
                this.pointcutAnnotationVisitor = new PointcutAnnotationVisitor();
                return this.pointcutAnnotationVisitor;
            }
            if (descriptor.equals("Lorg/glowroot/instrumentation/api/weaving/Mixin;")) {
                this.mixinAnnotationVisitor = new MixinAnnotationVisitor();
                return this.mixinAnnotationVisitor;
            }
            if (descriptor.equals("Lorg/glowroot/instrumentation/api/weaving/Shim;")) {
                this.shim = true;
            }
            return null;
        }

        @Override
        @Nullable
        public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
            if (this.pointcutAnnotationVisitor != null) {
                PointcutMethodVisitor methodVisitor = new PointcutMethodVisitor(name, descriptor);
                this.pointcutMethodVisitors.add(methodVisitor);
                return methodVisitor;
            }
            if (this.mixinAnnotationVisitor != null) {
                MixinMethodVisitor methodVisitor = new MixinMethodVisitor(name, descriptor);
                this.mixinMethodVisitors.add(methodVisitor);
                return methodVisitor;
            }
            return null;
        }

        private ImmutablePointcutClass buildPointcutClass(byte[] bytes, boolean collocateInClassLoader, @Nullable File jarFile) {
            ImmutablePointcutClass.Builder builder = ImmutablePointcutClass.builder().type(Type.getObjectType(Preconditions.checkNotNull(this.name)));
            for (PointcutMethodVisitor methodVisitor : this.pointcutMethodVisitors) {
                builder.addMethods(methodVisitor.build());
            }
            return builder.pointcut(Preconditions.checkNotNull(this.pointcutAnnotationVisitor).build()).bytes(bytes).collocateInClassLoader(collocateInClassLoader).jarFile(jarFile).build();
        }

        private MixinType buildMixinType(boolean collocateInClassLoader, byte[] bytes) {
            String initMethodName = null;
            for (MixinMethodVisitor methodVisitor : this.mixinMethodVisitors) {
                if (!methodVisitor.init) continue;
                if (initMethodName != null) {
                    throw new IllegalStateException("@Mixin has more than one @MixinInit");
                }
                initMethodName = methodVisitor.name;
            }
            ImmutableMixinType.Builder builder = ImmutableMixinType.builder();
            if (this.interfaces != null) {
                for (String iface : this.interfaces) {
                    if (collocateInClassLoader && !iface.endsWith("Mixin")) {
                        logger.warn("mixin interface name should end with \"Mixin\": {}", (Object)iface);
                    }
                    builder.addInterfaces(Type.getObjectType(iface));
                }
            }
            builder.addAllTargets(Preconditions.checkNotNull(this.mixinAnnotationVisitor).build());
            builder.initMethodName(initMethodName);
            builder.implementationBytes(bytes);
            return builder.build();
        }

        private ShimType buildShimType(boolean collocateInClassLoader) throws ClassNotFoundException {
            Preconditions.checkNotNull(this.name);
            if (collocateInClassLoader && !this.name.endsWith("Shim")) {
                logger.warn("shim interface name should end with \"Shim\": {}", (Object)this.name);
            }
            Class<?> clazz = Class.forName(ClassNames.fromInternalName(this.name), false, MemberClassVisitor.class.getClassLoader());
            return ShimType.create(clazz);
        }
    }

    private static class InstrumentationClassVisitor
    extends ClassVisitor {
        private final String internalName;
        private final List<String> innerClassNames = Lists.newArrayList();

        private InstrumentationClassVisitor(String internalName) {
            super(458752);
            this.internalName = internalName;
        }

        @Override
        public void visitInnerClass(String name, @Nullable String outerName, @Nullable String innerName, int access) {
            if (this.internalName.equals(outerName)) {
                this.innerClassNames.add(name);
            }
        }
    }
}

