/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.MoreObjects;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.com.google.common.collect.Lists;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.RequiresNonNull;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.AnnotationVisitor;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassVisitor;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.MethodVisitor;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.Logger;
import com.microsoft.applicationinsights.agent.shadow.org.slf4j.LoggerFactory;
import java.util.List;
import org.glowroot.instrumentation.api.Descriptor;
import org.glowroot.instrumentation.api.OptionalThreadContext;
import org.glowroot.instrumentation.engine.config.AdviceConfig;
import org.glowroot.instrumentation.engine.config.ImmutableAdviceConfig;
import org.glowroot.instrumentation.engine.weaving.ClassNames;

class InstrumentationSeekerClassVisitor
extends ClassVisitor {
    private static final Logger logger = LoggerFactory.getLogger(InstrumentationSeekerClassVisitor.class);
    private final List<AdviceConfig> configs = Lists.newArrayList();
    @MonotonicNonNull
    private String owner;

    InstrumentationSeekerClassVisitor() {
        super(458752);
    }

    @Override
    public void visit(int version, int access, String name, @Nullable String signature, @Nullable String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.owner = name;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
        return new InstrumentationAnnotationMethodVisitor(name, descriptor);
    }

    List<AdviceConfig> getConfigs() {
        return this.configs;
    }

    private static class TimerAnnotationVisitor
    extends AnnotationVisitor {
        @Nullable
        private String timerName;

        private TimerAnnotationVisitor() {
            super(458752);
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            if (name == null) {
                return;
            }
            if (name.equals("value")) {
                this.timerName = (String)value;
            }
        }
    }

    private static class LocalSpanAnnotationVisitor
    extends AnnotationVisitor {
        @Nullable
        private String messageTemplate;
        @Nullable
        private String timerName;

        private LocalSpanAnnotationVisitor() {
            super(458752);
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            if (name == null) {
                return;
            }
            if (name.equals("message")) {
                this.messageTemplate = (String)value;
            } else if (name.equals("timer")) {
                this.timerName = (String)value;
            }
        }
    }

    private static class TransactionAnnotationVisitor
    extends AnnotationVisitor {
        @Nullable
        private String transactionType;
        @Nullable
        private String transactionNameTemplate;
        @Nullable
        private String traceHeadline;
        @Nullable
        private String timerName;
        @Nullable
        private OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehavior;

        private TransactionAnnotationVisitor() {
            super(458752);
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            if (name == null) {
                return;
            }
            if (name.equals("transactionType")) {
                this.transactionType = (String)value;
            } else if (name.equals("transactionName")) {
                this.transactionNameTemplate = (String)value;
            } else if (name.equals("traceHeadline")) {
                this.traceHeadline = (String)value;
            } else if (name.equals("timer")) {
                this.timerName = (String)value;
            }
        }

        @Override
        public void visitEnum(String name, String descriptor, String value) {
            if (name.equals("alreadyInTransactionBehavior")) {
                this.alreadyInTransactionBehavior = TransactionAnnotationVisitor.toProto(value);
            }
        }

        private static OptionalThreadContext.AlreadyInTransactionBehavior toProto(String value) {
            if (value.equals("CAPTURE_LOCAL_SPAN")) {
                return OptionalThreadContext.AlreadyInTransactionBehavior.CAPTURE_LOCAL_SPAN;
            }
            if (value.equals("CAPTURE_NEW_TRANSACTION")) {
                return OptionalThreadContext.AlreadyInTransactionBehavior.CAPTURE_NEW_TRANSACTION;
            }
            if (value.equals("DO_NOTHING")) {
                return OptionalThreadContext.AlreadyInTransactionBehavior.DO_NOTHING;
            }
            throw new IllegalStateException("Unexpected AlreadyInTransactionBehavior: " + value);
        }
    }

    private class InstrumentationAnnotationMethodVisitor
    extends MethodVisitor {
        private final String methodName;
        private final String descriptor;
        @MonotonicNonNull
        private TransactionAnnotationVisitor transactionAnnotationVisitor;
        @MonotonicNonNull
        private LocalSpanAnnotationVisitor localSpanAnnotationVisitor;
        @MonotonicNonNull
        private TimerAnnotationVisitor timerAnnotationVisitor;

        private InstrumentationAnnotationMethodVisitor(String methodName, String descriptor) {
            super(458752);
            this.methodName = methodName;
            this.descriptor = descriptor;
        }

        @Override
        @Nullable
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.equals("Lorg/glowroot/instrumentation/annotation/api/Instrumentation$Transaction;")) {
                this.transactionAnnotationVisitor = new TransactionAnnotationVisitor();
                return this.transactionAnnotationVisitor;
            }
            if (descriptor.equals("Lorg/glowroot/instrumentation/annotation/api/Instrumentation$LocalSpan;")) {
                this.localSpanAnnotationVisitor = new LocalSpanAnnotationVisitor();
                return this.localSpanAnnotationVisitor;
            }
            if (descriptor.equals("Lorg/glowroot/instrumentation/annotation/api/Instrumentation$Timer;")) {
                this.timerAnnotationVisitor = new TimerAnnotationVisitor();
                return this.timerAnnotationVisitor;
            }
            return null;
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            this.processTransaction();
            this.processLocalSpan();
            this.processTimer();
        }

        private void processTransaction() {
            if (this.transactionAnnotationVisitor == null) {
                return;
            }
            Preconditions.checkNotNull(InstrumentationSeekerClassVisitor.this.owner);
            String transactionType = this.transactionAnnotationVisitor.transactionType;
            if (transactionType == null) {
                logger.error("@Instrumentation.Transaction had no transactionType attribute: {}", (Object)ClassNames.fromInternalName(InstrumentationSeekerClassVisitor.this.owner));
                return;
            }
            String transactionNameTemplate = this.transactionAnnotationVisitor.transactionNameTemplate;
            if (transactionNameTemplate == null) {
                logger.error("@Instrumentation.Transaction had no transactionNameTemplate attribute: {}", (Object)ClassNames.fromInternalName(InstrumentationSeekerClassVisitor.this.owner));
                return;
            }
            String traceHeadline = this.transactionAnnotationVisitor.traceHeadline;
            if (traceHeadline == null) {
                logger.error("@Instrumentation.Transaction had no traceHeadline attribute: {}", (Object)ClassNames.fromInternalName(InstrumentationSeekerClassVisitor.this.owner));
                return;
            }
            String timerName = this.transactionAnnotationVisitor.timerName;
            if (timerName == null) {
                logger.error("@Instrumentation.Transaction had no timerName attribute: {}", (Object)ClassNames.fromInternalName(InstrumentationSeekerClassVisitor.this.owner));
                return;
            }
            OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehavior = MoreObjects.firstNonNull(this.transactionAnnotationVisitor.alreadyInTransactionBehavior, OptionalThreadContext.AlreadyInTransactionBehavior.CAPTURE_LOCAL_SPAN);
            InstrumentationSeekerClassVisitor.this.configs.add(this.startBuilder().captureKind(Descriptor.CaptureKind.TRANSACTION).transactionType(transactionType).transactionNameTemplate(transactionNameTemplate).spanMessageTemplate(traceHeadline).timerName(timerName).alreadyInTransactionBehavior(alreadyInTransactionBehavior).build());
        }

        private void processLocalSpan() {
            if (this.localSpanAnnotationVisitor == null) {
                return;
            }
            Preconditions.checkNotNull(InstrumentationSeekerClassVisitor.this.owner);
            String messageTemplate = this.localSpanAnnotationVisitor.messageTemplate;
            if (messageTemplate == null) {
                logger.error("@Instrumentation.LocalSpan had no messageTemplate attribute: {}", (Object)ClassNames.fromInternalName(InstrumentationSeekerClassVisitor.this.owner));
                return;
            }
            String timerName = this.localSpanAnnotationVisitor.timerName;
            if (timerName == null) {
                logger.error("@Instrumentation.LocalSpan had no timerName attribute: {}", (Object)ClassNames.fromInternalName(InstrumentationSeekerClassVisitor.this.owner));
                return;
            }
            InstrumentationSeekerClassVisitor.this.configs.add(this.startBuilder().captureKind(Descriptor.CaptureKind.LOCAL_SPAN).spanMessageTemplate(messageTemplate).timerName(timerName).build());
        }

        private void processTimer() {
            if (this.timerAnnotationVisitor == null) {
                return;
            }
            Preconditions.checkNotNull(InstrumentationSeekerClassVisitor.this.owner);
            String timerName = this.timerAnnotationVisitor.timerName;
            if (timerName == null) {
                logger.error("@Instrumentation.Timer had no value attribute: {}", (Object)ClassNames.fromInternalName(InstrumentationSeekerClassVisitor.this.owner));
                return;
            }
            InstrumentationSeekerClassVisitor.this.configs.add(this.startBuilder().captureKind(Descriptor.CaptureKind.TIMER).timerName(timerName).build());
        }

        @RequiresNonNull(value={"owner"})
        private ImmutableAdviceConfig.Builder startBuilder() {
            Type type = Type.getObjectType(InstrumentationSeekerClassVisitor.this.owner);
            Type[] argumentTypes = Type.getArgumentTypes(this.descriptor);
            ImmutableAdviceConfig.Builder builder = ImmutableAdviceConfig.builder().className(type.getClassName()).methodName(this.methodName);
            for (Type argumentType : argumentTypes) {
                builder.addMethodParameterTypes(argumentType.getClassName());
            }
            return builder;
        }
    }
}

