/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.engine.weaving;

import com.microsoft.applicationinsights.agent.shadow.com.google.common.base.Preconditions;
import com.microsoft.applicationinsights.agent.shadow.org.checkerframework.checker.nullness.qual.Nullable;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.AnnotationVisitor;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.ClassVisitor;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.MethodVisitor;
import com.microsoft.applicationinsights.agent.shadow.org.objectweb.asm.Type;
import java.util.List;
import org.glowroot.instrumentation.engine.weaving.ImmutableThinClass;
import org.glowroot.instrumentation.engine.weaving.ImmutableThinMethod;
import org.immutables.value.Value;

class ThinClassVisitor
extends ClassVisitor {
    private final ImmutableThinClass.Builder thinClassBuilder = ImmutableThinClass.builder();
    private int majorVersion;
    @Nullable
    private ThinClass thinClass;

    ThinClassVisitor() {
        super(458752);
    }

    @Override
    public void visit(int version, int access, String name, @Nullable String signature, @Nullable String superName, String[] interfaces) {
        this.majorVersion = version & 0xFFFF;
        this.thinClassBuilder.access(access);
        this.thinClassBuilder.name(name);
        this.thinClassBuilder.superName(superName);
        if (interfaces != null) {
            this.thinClassBuilder.addInterfaces(interfaces);
        }
    }

    @Override
    @Nullable
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.thinClassBuilder.addAnnotations(descriptor);
        if (descriptor.equals("Ljavax/ejb/Remote;")) {
            return new RemoteAnnotationVisitor();
        }
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, String[] exceptions) {
        ImmutableThinMethod.Builder thinMethodBuilder = ImmutableThinMethod.builder();
        thinMethodBuilder.access(access);
        thinMethodBuilder.name(name);
        thinMethodBuilder.descriptor(descriptor);
        thinMethodBuilder.signature(signature);
        if (exceptions != null) {
            thinMethodBuilder.addExceptions(exceptions);
        }
        return new AnnotationCaptureMethodVisitor(thinMethodBuilder);
    }

    @Override
    public void visitEnd() {
        this.thinClass = this.thinClassBuilder.build();
    }

    int getMajorVersion() {
        return this.majorVersion;
    }

    ThinClass getThinClass() {
        return Preconditions.checkNotNull(this.thinClass);
    }

    private class ValueAnnotationVisitor
    extends AnnotationVisitor {
        private ValueAnnotationVisitor() {
            super(458752);
        }

        @Override
        public void visit(@Nullable String name, Object value) {
            if (name == null && value instanceof Type) {
                ThinClassVisitor.this.thinClassBuilder.addEjbRemoteInterfaces((Type)value);
            }
        }
    }

    private class RemoteAnnotationVisitor
    extends AnnotationVisitor {
        private RemoteAnnotationVisitor() {
            super(458752);
        }

        @Override
        @Nullable
        public AnnotationVisitor visitArray(String name) {
            if (name.equals("value")) {
                return new ValueAnnotationVisitor();
            }
            return null;
        }
    }

    private class AnnotationCaptureMethodVisitor
    extends MethodVisitor {
        private final ImmutableThinMethod.Builder thinMethodBuilder;

        private AnnotationCaptureMethodVisitor(ImmutableThinMethod.Builder thinMethodBuilder) {
            super(458752);
            this.thinMethodBuilder = thinMethodBuilder;
        }

        @Override
        @Nullable
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            this.thinMethodBuilder.addAnnotations(descriptor);
            return null;
        }

        @Override
        public void visitEnd() {
            ImmutableThinMethod thinMethod = this.thinMethodBuilder.build();
            if ((thinMethod.access() & 0x40) != 0) {
                ThinClassVisitor.this.thinClassBuilder.addBridgeMethods((ThinMethod)thinMethod);
            } else {
                ThinClassVisitor.this.thinClassBuilder.addNonBridgeMethods((ThinMethod)thinMethod);
            }
        }
    }

    @Value.Immutable
    static interface ThinMethod {
        public int access();

        public String name();

        public String descriptor();

        @Nullable
        public String signature();

        public List<String> exceptions();

        public List<String> annotations();
    }

    @Value.Immutable
    static interface ThinClass {
        public int access();

        public String name();

        @Nullable
        public String superName();

        public List<String> interfaces();

        public List<String> annotations();

        public List<ThinMethod> nonBridgeMethods();

        public List<ThinMethod> bridgeMethods();

        public List<Type> ejbRemoteInterfaces();
    }
}

