/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.executor;

import java.util.concurrent.Callable;
import org.glowroot.instrumentation.api.AuxThreadContext;
import org.glowroot.instrumentation.api.Span;

class CallableWrapper<V>
implements Callable<V> {
    private final Callable<V> delegate;
    private final AuxThreadContext auxContext;

    CallableWrapper(Callable<V> delegate, AuxThreadContext auxContext) {
        this.delegate = delegate;
        this.auxContext = auxContext;
    }

    @Override
    public V call() {
        V v;
        Span span = this.auxContext.start();
        try {
            v = this.delegate.call();
        }
        catch (Throwable t) {
            span.endWithError(t);
            throw CallableWrapper.rethrow(t);
        }
        span.end();
        return v;
    }

    private static RuntimeException rethrow(Throwable t) {
        CallableWrapper.throwsUnchecked(t);
        throw new AssertionError();
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable t) throws T {
        throw t;
    }
}

