/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.executor;

import java.util.Collection;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.AuxThreadContext;
import org.glowroot.instrumentation.api.Logger;
import org.glowroot.instrumentation.api.ParameterHolder;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.api.weaving.Mixin;
import org.glowroot.instrumentation.executor.CallableWrapper;
import org.glowroot.instrumentation.executor.FutureClassMeta;
import org.glowroot.instrumentation.executor.RunnableWrapper;

public class ExecutorInstrumentation {
    private static final Logger logger = Logger.getLogger(ExecutorInstrumentation.class);
    private static final TimerName FUTURE_TIMER_NAME = Agent.getTimerName("wait on future");
    private static final String EXECUTOR_CLASSES = "java.util.concurrent.Executor|java.util.concurrent.ExecutorService|org.springframework.core.task.AsyncTaskExecutor|org.springframework.core.task.AsyncListenableTaskExecutor";
    private static final AtomicBoolean isDoneExceptionLogged = new AtomicBoolean();

    private static void onBeforeWithRunnableHolder(ParameterHolder<Runnable> runnableHolder, ThreadContext context) {
        Runnable runnable = runnableHolder.get();
        if (runnable instanceof SuppressedRunnableMixin) {
            return;
        }
        if (runnable instanceof RunnableEtcMixin) {
            ExecutorInstrumentation.onBeforeCommon((RunnableEtcMixin)((Object)runnable), context);
        } else if (runnable != null && runnable.getClass().getName().contains("$$Lambda$")) {
            ExecutorInstrumentation.wrapRunnable(runnableHolder, context);
        }
    }

    private static <T> void onBeforeWithCallableHolder(ParameterHolder<Callable<T>> callableHolder, ThreadContext context) {
        Callable<T> callable = callableHolder.get();
        if (callable instanceof RunnableEtcMixin) {
            ExecutorInstrumentation.onBeforeCommon((RunnableEtcMixin)((Object)callable), context);
        } else if (callable != null && callable.getClass().getName().contains("$$Lambda$")) {
            ExecutorInstrumentation.wrapCallable(callableHolder, context);
        }
    }

    private static void onThreadInitCommon(Thread thread, ThreadContext context) {
        if (thread instanceof RunnableEtcMixin && !(thread instanceof SuppressedRunnableMixin)) {
            ExecutorInstrumentation.onBeforeCommon((RunnableEtcMixin)((Object)thread), context);
        }
    }

    private static boolean onThreadInitCommon(ParameterHolder<Runnable> runnableHolder, ThreadContext context) {
        Runnable runnable = runnableHolder.get();
        if (!(runnable instanceof SuppressedRunnableMixin)) {
            if (runnable instanceof RunnableEtcMixin) {
                ExecutorInstrumentation.onBeforeCommon((RunnableEtcMixin)((Object)runnable), context);
                return true;
            }
            if (runnable != null && runnable.getClass().getName().contains("$$Lambda$")) {
                ExecutorInstrumentation.wrapRunnable(runnableHolder, context);
                return true;
            }
        }
        return false;
    }

    private static void onBeforeCommon(RunnableEtcMixin runnableEtc, ThreadContext context) {
        RunnableEtcMixin runnableMixin = runnableEtc;
        AuxThreadContext auxContext = context.createAuxThreadContext();
        runnableMixin.glowroot$setAuxContext(auxContext);
    }

    private static void wrapRunnable(ParameterHolder<Runnable> runnableHolder, ThreadContext context) {
        Runnable runnable = runnableHolder.get();
        if (runnable != null) {
            runnableHolder.set(new RunnableWrapper(runnable, context.createAuxThreadContext()));
        }
    }

    private static <T> void wrapCallable(ParameterHolder<Callable<T>> callableHolder, ThreadContext context) {
        Callable<T> callable = callableHolder.get();
        if (callable != null) {
            callableHolder.set(new CallableWrapper<T>(callable, context.createAuxThreadContext()));
        }
    }

    @Advice.Pointcut(className="java.util.concurrent.ForkJoinTask|akka.jsr166y.ForkJoinTask|scala.concurrent.forkjoin.ForkJoinTask", methodName="exec", methodParameterTypes={}, nestingGroup="executor-run")
    public static class ExecAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This Object task) {
            if (!(task instanceof RunnableEtcMixin)) {
                return false;
            }
            RunnableEtcMixin taskMixin = (RunnableEtcMixin)task;
            return taskMixin.glowroot$getAuxContext() != null;
        }

        @Advice.OnMethodBefore
        @Nullable
        public static Span onBefore(@Bind.This Object task) {
            RunnableEtcMixin taskMixin = (RunnableEtcMixin)task;
            AuxThreadContext auxContext = taskMixin.glowroot$getAuxContext();
            if (auxContext == null) {
                return null;
            }
            taskMixin.glowroot$setAuxContext(null);
            return auxContext.start();
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter @Nullable Span span) {
            if (span != null) {
                span.end();
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable Span span) {
            if (span != null) {
                span.endWithError(t);
            }
        }
    }

    @Advice.Pointcut(className="org.glowroot.instrumentation.executor.CallableWrapper", methodName="call", methodParameterTypes={}, nestingGroup="executor-run")
    public static class CallableWrapperAdvice {
    }

    @Advice.Pointcut(className="org.glowroot.instrumentation.executor.RunnableWrapper", methodName="run", methodParameterTypes={}, nestingGroup="executor-run")
    public static class RunnableWrapperAdvice {
    }

    @Advice.Pointcut(className="java.util.concurrent.Callable", methodName="call", methodParameterTypes={}, nestingGroup="executor-run")
    public static class CallableAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This Callable<?> callable) {
            if (!(callable instanceof RunnableEtcMixin)) {
                return false;
            }
            RunnableEtcMixin callableMixin = (RunnableEtcMixin)((Object)callable);
            return callableMixin.glowroot$getAuxContext() != null;
        }

        @Advice.OnMethodBefore
        @Nullable
        public static Span onBefore(@Bind.This Callable<?> callable) {
            RunnableEtcMixin callableMixin = (RunnableEtcMixin)((Object)callable);
            AuxThreadContext auxContext = callableMixin.glowroot$getAuxContext();
            if (auxContext == null) {
                return null;
            }
            callableMixin.glowroot$setAuxContext(null);
            return auxContext.start();
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter @Nullable Span span) {
            if (span != null) {
                span.end();
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable Span span) {
            if (span != null) {
                span.endWithError(t);
            }
        }
    }

    @Advice.Pointcut(className="java.lang.Runnable", methodName="run", methodParameterTypes={}, nestingGroup="executor-run")
    public static class RunnableAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This Runnable runnable) {
            if (!(runnable instanceof RunnableEtcMixin)) {
                return false;
            }
            RunnableEtcMixin runnableMixin = (RunnableEtcMixin)((Object)runnable);
            return runnableMixin.glowroot$getAuxContext() != null;
        }

        @Advice.OnMethodBefore
        @Nullable
        public static Span onBefore(@Bind.This Runnable runnable) {
            RunnableEtcMixin runnableMixin = (RunnableEtcMixin)((Object)runnable);
            AuxThreadContext auxContext = runnableMixin.glowroot$getAuxContext();
            if (auxContext == null) {
                return null;
            }
            runnableMixin.glowroot$setAuxContext(null);
            return auxContext.start();
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter @Nullable Span span) {
            if (span != null) {
                span.end();
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable Span span) {
            if (span != null) {
                span.endWithError(t);
            }
        }
    }

    @Advice.Pointcut(className="java.util.concurrent.Future", methodName="get", methodParameterTypes={".."}, suppressibleUsingKey="wait-on-future")
    public static class FutureGetAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This Future<?> future, @Bind.ClassMeta FutureClassMeta futureClassMeta) {
            if (futureClassMeta.isNonStandardFuture()) {
                return false;
            }
            try {
                return !future.isDone();
            }
            catch (Exception e) {
                if (isDoneExceptionLogged.getAndSet(true)) {
                    logger.debug(e.getMessage(), e);
                } else {
                    logger.info("encountered a non-standard java.util.concurrent.Future implementation, please report this stack trace to https://github.com/glowroot/instrumentation:", e);
                }
                return false;
            }
        }

        @Advice.OnMethodBefore
        public static Timer onBefore(ThreadContext context) {
            return context.startTimer(FUTURE_TIMER_NAME);
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter Timer timer) {
            timer.stop();
        }
    }

    @Advice.Pointcut(className="javax.servlet.AsyncContext", methodName="start", methodParameterTypes={"java.lang.Runnable"})
    public static class StartAdvice {
        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=0) ParameterHolder<Runnable> runnableHolder, ThreadContext context) {
            ExecutorInstrumentation.onBeforeWithRunnableHolder(runnableHolder, context);
        }
    }

    @Advice.Pointcut(className="org.eclipse.jetty.io.SelectorManager|org.eclipse.jetty.server.AbstractConnector|wiremock.org.eclipse.jetty.io.SelectorManager|wiremock.org.eclipse.jetty.server.AbstractConnector", methodName="doStart", methodParameterTypes={}, nestingGroup="executor-execute")
    public static class JettyDoStartAdvice {
    }

    @Advice.Pointcut(className="net.sf.ehcache.store.disk.DiskStorageFactory", methodName="schedule", methodParameterTypes={"java.util.concurrent.Callable"}, nestingGroup="executor-execute")
    public static class EhcacheDiskStorageScheduleAdvice {
    }

    @Advice.Pointcut(className="java.util.Timer", methodName="schedule", methodParameterTypes={"java.util.TimerTask", ".."}, nestingGroup="executor-execute")
    public static class TimerScheduleAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.Argument(value=0) Object runnableEtc) {
            return runnableEtc instanceof RunnableEtcMixin;
        }

        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=0) TimerTask timerTask, ThreadContext context) {
            ExecutorInstrumentation.onBeforeCommon((RunnableEtcMixin)((Object)timerTask), context);
        }
    }

    @Advice.Pointcut(className="akka.actor.Scheduler", methodName="scheduleOnce", methodParameterTypes={"scala.concurrent.duration.FiniteDuration", "java.lang.Runnable", ".."}, nestingGroup="executor-execute")
    public static class ScheduleOnceAdvice {
        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=1) ParameterHolder<Runnable> runnableHolder, ThreadContext context) {
            ExecutorInstrumentation.onBeforeWithRunnableHolder(runnableHolder, context);
        }
    }

    @Advice.Pointcut(className="java.util.concurrent.ScheduledExecutorService", methodName="schedule", methodParameterTypes={"java.util.concurrent.Callable", ".."}, nestingGroup="executor-execute")
    public static class ScheduleCallableAdvice {
        @Advice.OnMethodBefore
        public static <T> void onBefore(@Bind.Argument(value=0) ParameterHolder<Callable<T>> callableHolder, ThreadContext context) {
            ExecutorInstrumentation.onBeforeWithCallableHolder(callableHolder, context);
        }
    }

    @Advice.Pointcut(className="java.util.concurrent.ScheduledExecutorService", methodName="schedule", methodParameterTypes={"java.lang.Runnable", ".."}, nestingGroup="executor-execute")
    public static class ScheduleRunnableAdvice {
        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=0) ParameterHolder<Runnable> runnableHolder, ThreadContext context) {
            ExecutorInstrumentation.onBeforeWithRunnableHolder(runnableHolder, context);
        }
    }

    @Advice.Pointcut(className="java.util.concurrent.ExecutorService|java.util.concurrent.ForkJoinPool|akka.jsr166y.ForkJoinPool|scala.concurrent.forkjoin.ForkJoinPool", methodName="invokeAll|invokeAny", methodParameterTypes={"java.util.Collection", ".."}, nestingGroup="executor-execute")
    public static class InvokeAnyAllAdvice {
        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=0) Collection<?> callables, ThreadContext context) {
            if (callables == null) {
                return;
            }
            for (Object callable : callables) {
                if (!(callable instanceof RunnableEtcMixin)) continue;
                RunnableEtcMixin callableMixin = (RunnableEtcMixin)callable;
                AuxThreadContext auxContext = context.createAuxThreadContext();
                callableMixin.glowroot$setAuxContext(auxContext);
            }
        }
    }

    @Advice.Pointcut(className="com.google.common.util.concurrent.ListenableFuture", methodName="addListener", methodParameterTypes={"java.lang.Runnable", "java.util.concurrent.Executor"}, nestingGroup="executor-add-listener")
    public static class AddListenerAdvice {
        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=0) ParameterHolder<Runnable> runnableHolder, ThreadContext context) {
            ExecutorInstrumentation.onBeforeWithRunnableHolder(runnableHolder, context);
        }
    }

    @Advice.Pointcut(className="java.lang.Thread", methodName="<init>", methodParameterTypes={"java.lang.ThreadGroup", "java.lang.Runnable", ".."}, nestingGroup="executor-execute")
    public static class ThreadInitWithThreadGroupAdvice {
        @Advice.OnMethodBefore
        public static boolean onBefore(@Bind.Special boolean enabled, @Bind.Argument(value=1) ParameterHolder<Runnable> runnableHolder, ThreadContext context) {
            if (enabled) {
                return ExecutorInstrumentation.onThreadInitCommon(runnableHolder, context);
            }
            return false;
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter boolean alreadyHandled, @Bind.This Thread thread, ThreadContext context) {
            if (!alreadyHandled && thread instanceof RunnableEtcMixin) {
                ExecutorInstrumentation.onBeforeCommon((RunnableEtcMixin)((Object)thread), context);
            }
        }
    }

    @Advice.Pointcut(className="java.lang.Thread", methodName="<init>", methodParameterTypes={"java.lang.Runnable", ".."}, nestingGroup="executor-execute")
    public static class ThreadInitWithRunnableAdvice {
        @Advice.OnMethodBefore
        public static boolean onBefore(@Bind.Special boolean enabled, @Bind.Argument(value=0) ParameterHolder<Runnable> runnableHolder, ThreadContext context) {
            if (enabled) {
                return ExecutorInstrumentation.onThreadInitCommon(runnableHolder, context);
            }
            return false;
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter boolean alreadyHandled, @Bind.This Thread thread, ThreadContext context) {
            if (!alreadyHandled && thread instanceof RunnableEtcMixin) {
                ExecutorInstrumentation.onBeforeCommon((RunnableEtcMixin)((Object)thread), context);
            }
        }
    }

    @Advice.Pointcut(className="java.lang.Thread", methodName="<init>", methodParameterTypes={"java.lang.ThreadGroup", "java.lang.String"}, nestingGroup="executor-execute")
    public static class ThreadInitWithStringAndThreadGroupAdvice {
        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This Thread thread, ThreadContext context) {
            ExecutorInstrumentation.onThreadInitCommon(thread, context);
        }
    }

    @Advice.Pointcut(className="java.lang.Thread", methodName="<init>", methodParameterTypes={"java.lang.String"}, nestingGroup="executor-execute")
    public static class ThreadInitWithStringAdvice {
        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This Thread thread, ThreadContext context) {
            ExecutorInstrumentation.onThreadInitCommon(thread, context);
        }
    }

    @Advice.Pointcut(className="java.lang.Thread", methodName="<init>", methodParameterTypes={}, nestingGroup="executor-execute")
    public static class ThreadInitAdvice {
        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This Thread thread, ThreadContext context) {
            ExecutorInstrumentation.onThreadInitCommon(thread, context);
        }
    }

    @Advice.Pointcut(className="scala.concurrent.forkjoin.ForkJoinPool", methodName="execute|submit|invoke", methodParameterTypes={"scala.concurrent.forkjoin.ForkJoinTask", ".."}, nestingGroup="executor-execute")
    public static class ScalaForkJoinPoolAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.Argument(value=0) Object forkJoinTask) {
            return forkJoinTask instanceof RunnableEtcMixin;
        }

        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=0) Object forkJoinTask, ThreadContext context) {
            ExecutorInstrumentation.onBeforeCommon((RunnableEtcMixin)forkJoinTask, context);
        }
    }

    @Advice.Pointcut(className="akka.jsr166y.ForkJoinPool", methodName="execute|submit|invoke", methodParameterTypes={"akka.jsr166y.ForkJoinTask", ".."}, nestingGroup="executor-execute")
    public static class AkkaJsr166yForkJoinPoolAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.Argument(value=0) Object forkJoinTask) {
            return forkJoinTask instanceof RunnableEtcMixin;
        }

        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=0) Object forkJoinTask, ThreadContext context) {
            ExecutorInstrumentation.onBeforeCommon((RunnableEtcMixin)forkJoinTask, context);
        }
    }

    @Advice.Pointcut(className="java.util.concurrent.ForkJoinPool", methodName="execute|submit|invoke", methodParameterTypes={"java.util.concurrent.ForkJoinTask", ".."}, nestingGroup="executor-execute")
    public static class ForkJoinPoolAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.Argument(value=0) Object forkJoinTask) {
            return forkJoinTask instanceof RunnableEtcMixin;
        }

        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=0) Object forkJoinTask, ThreadContext context) {
            ExecutorInstrumentation.onBeforeCommon((RunnableEtcMixin)forkJoinTask, context);
        }
    }

    @Advice.Pointcut(className="java.util.concurrent.Executor|java.util.concurrent.ExecutorService|org.springframework.core.task.AsyncTaskExecutor|org.springframework.core.task.AsyncListenableTaskExecutor", methodName="execute|submit|submitListenable", methodParameterTypes={"java.util.concurrent.Callable", ".."}, nestingGroup="executor-execute")
    public static class ExecuteCallableAdvice {
        @Advice.OnMethodBefore
        public static <T> void onBefore(@Bind.Argument(value=0) ParameterHolder<Callable<T>> callableHolder, ThreadContext context) {
            ExecutorInstrumentation.onBeforeWithCallableHolder(callableHolder, context);
        }
    }

    @Advice.Pointcut(className="java.util.concurrent.Executor|java.util.concurrent.ExecutorService|org.springframework.core.task.AsyncTaskExecutor|org.springframework.core.task.AsyncListenableTaskExecutor", methodName="execute|submit|submitListenable", methodParameterTypes={"java.lang.Runnable", ".."}, nestingGroup="executor-execute")
    public static class ExecuteRunnableAdvice {
        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=0) ParameterHolder<Runnable> runnableHolder, ThreadContext context) {
            ExecutorInstrumentation.onBeforeWithRunnableHolder(runnableHolder, context);
        }
    }

    public static interface SuppressedRunnableMixin {
    }

    public static interface RunnableEtcMixin {
        @Nullable
        public AuxThreadContext glowroot$getAuxContext();

        public void glowroot$setAuxContext(@Nullable AuxThreadContext var1);
    }

    @Mixin(value={"org.apache.tomcat.util.net.JIoEndpoint$SocketProcessor", "org.apache.http.impl.nio.client.CloseableHttpAsyncClientBase$1", "java.util.TimerThread"})
    public static class SuppressedRunnableImpl
    implements SuppressedRunnableMixin {
    }

    @Mixin(value={"java.lang.Runnable", "java.util.concurrent.Callable", "java.util.concurrent.ForkJoinTask", "akka.jsr166y.ForkJoinTask", "scala.concurrent.forkjoin.ForkJoinTask"})
    public static abstract class RunnableEtcImpl
    implements RunnableEtcMixin {
        @Nullable
        private volatile transient AuxThreadContext glowroot$auxContext;

        @Override
        @Nullable
        public AuxThreadContext glowroot$getAuxContext() {
            return this.glowroot$auxContext;
        }

        @Override
        public void glowroot$setAuxContext(@Nullable AuxThreadContext auxContext) {
            this.glowroot$auxContext = auxContext;
        }
    }
}

