/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.executor;

import org.glowroot.instrumentation.api.AuxThreadContext;
import org.glowroot.instrumentation.api.Span;

class RunnableWrapper
implements Runnable {
    private final Runnable delegate;
    private final AuxThreadContext auxContext;

    RunnableWrapper(Runnable delegate, AuxThreadContext auxContext) {
        this.delegate = delegate;
        this.auxContext = auxContext;
    }

    @Override
    public void run() {
        Span span = this.auxContext.start();
        try {
            this.delegate.run();
        }
        catch (Throwable t) {
            span.endWithError(t);
            throw RunnableWrapper.rethrow(t);
        }
        span.end();
    }

    private static RuntimeException rethrow(Throwable t) {
        RunnableWrapper.throwsUnchecked(t);
        throw new AssertionError();
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable t) throws T {
        throw t;
    }
}

