/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.httpurlconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.Logger;
import org.glowroot.instrumentation.api.Setter;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.api.weaving.Mixin;
import org.glowroot.instrumentation.httpurlconnection.boot.HttpRequestMessageSupplier;

public class HttpURLConnectionInstrumentation {
    private static final Logger logger = Logger.getLogger(HttpURLConnectionInstrumentation.class);
    private static final TimerName TIMER_NAME = Agent.getTimerName("http client");
    private static final Setter<HttpURLConnection> SETTER = new SetterImpl();
    private static final AtomicBoolean inputStreamIssueLogged = new AtomicBoolean();
    private static final AtomicBoolean outputStreamIssueAlreadyLogged = new AtomicBoolean();
    private static final AtomicBoolean addRequestPropertyIssueLogged = new AtomicBoolean();

    @Nullable
    private static SpanOrTimer onBeforeCommon(HttpURLConnection httpURLConnection, boolean overrideGetWithPost, ThreadContext context) {
        if (!(httpURLConnection instanceof HasSpanMixin)) {
            return null;
        }
        HasSpanMixin hasSpanMixin = (HasSpanMixin)((Object)httpURLConnection);
        Span span = hasSpanMixin.glowroot$getSpan();
        if (span != null) {
            return new SpanOrTimer(span.extend());
        }
        String method = httpURLConnection.getRequestMethod();
        if (method == null) {
            method = "";
        } else if (overrideGetWithPost && method.equals("GET")) {
            method = "POST";
        }
        URL urlObj = httpURLConnection.getURL();
        String url = urlObj == null ? "" : urlObj.toString();
        span = HttpURLConnectionInstrumentation.startOutgoingSpan(context, method, url, SETTER, httpURLConnection, TIMER_NAME);
        hasSpanMixin.glowroot$setSpan(span);
        return new SpanOrTimer(span);
    }

    private static void onReturnCommon(@Nullable SpanOrTimer spanOrTimer) {
        if (spanOrTimer != null) {
            spanOrTimer.onReturn();
        }
    }

    private static void onReturnCaptureResponseCode(HttpURLConnection httpURLConnection) {
        if (!(httpURLConnection instanceof HasSpanMixin)) {
            return;
        }
        Span span = ((HasSpanMixin)((Object)httpURLConnection)).glowroot$getSpan();
        if (span == null) {
            return;
        }
        HttpRequestMessageSupplier messageSupplier = (HttpRequestMessageSupplier)span.getMessageSupplier();
        if (messageSupplier == null) {
            return;
        }
        try {
            messageSupplier.setStatusCode(httpURLConnection.getResponseCode());
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), e);
        }
    }

    private static void onThrowCommon(@Nullable SpanOrTimer spanOrTimer, Throwable t) {
        if (spanOrTimer != null) {
            spanOrTimer.onThrow(t);
        }
    }

    public static <C> Span startOutgoingSpan(ThreadContext context, @Nullable String httpMethod, @Nullable String uri, Setter<C> setter, C carrier, TimerName timerName) {
        int maxLength = 0;
        if (httpMethod != null) {
            maxLength += httpMethod.length();
        }
        if (uri != null) {
            maxLength += uri.length() + 1;
        }
        StringBuilder sb = new StringBuilder(maxLength);
        if (httpMethod != null) {
            sb.append(httpMethod);
        }
        if (uri != null) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(HttpURLConnectionInstrumentation.stripQueryString(uri));
        }
        HttpRequestMessageSupplier messageSupplier = new HttpRequestMessageSupplier(httpMethod, uri);
        return context.startOutgoingSpan("HTTP", sb.toString(), setter, carrier, messageSupplier, timerName);
    }

    private static String stripQueryString(String uri) {
        int index = uri.indexOf(63);
        return index == -1 ? uri : uri.substring(0, index);
    }

    private static class SetterImpl
    implements Setter<HttpURLConnection> {
        private SetterImpl() {
        }

        @Override
        public void put(HttpURLConnection carrier, String key, String value) {
            block2: {
                try {
                    carrier.addRequestProperty(key, value);
                }
                catch (RuntimeException e) {
                    if (addRequestPropertyIssueLogged.getAndSet(true)) break block2;
                    logger.error("could not add http request header '{}': {}", (Object)key, (Object)e.toString());
                }
            }
        }
    }

    @Advice.Pointcut(className="java.io.OutputStream", subTypeRestriction="sun.net.www.protocol.http.HttpURLConnection$StreamingOutputStream|sun.net.www.http.PosterOutputStream|weblogic.utils.io.UnsyncByteArrayOutputStream", methodName="*", methodParameterTypes={".."})
    public static class StreamingOutputStreamAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static Timer onBefore(@Bind.This OutputStream outputStream) {
            if (!(outputStream instanceof HasSpanMixin)) {
                return null;
            }
            Span span = ((HasSpanMixin)((Object)outputStream)).glowroot$getSpan();
            if (span == null) {
                return null;
            }
            return span.extend();
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter @Nullable Timer timer) {
            if (timer != null) {
                timer.stop();
            }
        }
    }

    @Advice.Pointcut(className="java.io.InputStream", subTypeRestriction="sun.net.www.protocol.http.HttpURLConnection$HttpInputStream|weblogic.net.http.KeepAliveStream", methodName="*", methodParameterTypes={".."})
    public static class HttpInputStreamAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static Timer onBefore(@Bind.This InputStream inputStream) {
            if (!(inputStream instanceof HasSpanMixin)) {
                return null;
            }
            Span span = ((HasSpanMixin)((Object)inputStream)).glowroot$getSpan();
            if (span == null) {
                return null;
            }
            return span.extend();
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter @Nullable Timer timer) {
            if (timer != null) {
                timer.stop();
            }
        }
    }

    @Advice.Pointcut(className="java.net.URLConnection", subTypeRestriction="java.net.HttpURLConnection", methodName="getHeaderField*|getContent*|getDate|getExpiration|getLastModified", methodParameterTypes={".."}, nestingGroup="http-client")
    public static class GetHeaderFieldAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static SpanOrTimer onBefore(@Bind.This HttpURLConnection httpURLConnection, ThreadContext context) {
            return HttpURLConnectionInstrumentation.onBeforeCommon(httpURLConnection, false, context);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This HttpURLConnection httpURLConnection, @Bind.Enter @Nullable SpanOrTimer spanOrTimer) {
            HttpURLConnectionInstrumentation.onReturnCaptureResponseCode(httpURLConnection);
            HttpURLConnectionInstrumentation.onReturnCommon(spanOrTimer);
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable SpanOrTimer spanOrTimer) {
            HttpURLConnectionInstrumentation.onThrowCommon(spanOrTimer, t);
        }
    }

    @Advice.Pointcut(className="java.net.HttpURLConnection", methodName="getResponseCode|getResponseMessage", methodParameterTypes={}, nestingGroup="http-client")
    public static class GetResponseAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static SpanOrTimer onBefore(@Bind.This HttpURLConnection httpURLConnection, ThreadContext context) {
            return HttpURLConnectionInstrumentation.onBeforeCommon(httpURLConnection, false, context);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This HttpURLConnection httpURLConnection, @Bind.Enter @Nullable SpanOrTimer spanOrTimer) {
            HttpURLConnectionInstrumentation.onReturnCaptureResponseCode(httpURLConnection);
            HttpURLConnectionInstrumentation.onReturnCommon(spanOrTimer);
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable SpanOrTimer spanOrTimer) {
            HttpURLConnectionInstrumentation.onThrowCommon(spanOrTimer, t);
        }
    }

    @Advice.Pointcut(className="java.net.URLConnection", subTypeRestriction="java.net.HttpURLConnection", methodName="getOutputStream", methodParameterTypes={}, nestingGroup="http-client")
    public static class GetOutputStreamAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static SpanOrTimer onBefore(@Bind.This HttpURLConnection httpURLConnection, ThreadContext context) {
            return HttpURLConnectionInstrumentation.onBeforeCommon(httpURLConnection, true, context);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return @Nullable OutputStream returnValue, @Bind.This HttpURLConnection httpURLConnection, @Bind.Enter @Nullable SpanOrTimer spanOrTimer) {
            if (httpURLConnection instanceof HasSpanMixin) {
                if (returnValue instanceof HasSpanMixin) {
                    Span span = ((HasSpanMixin)((Object)httpURLConnection)).glowroot$getSpan();
                    ((HasSpanMixin)((Object)returnValue)).glowroot$setSpan(span);
                } else if (returnValue != null && !outputStreamIssueAlreadyLogged.getAndSet(true)) {
                    logger.info("found non-instrumented http url connection output stream, please report to https://github.com/glowroot/instrumentation: {}", (Object)returnValue.getClass().getName());
                }
            }
            HttpURLConnectionInstrumentation.onReturnCommon(spanOrTimer);
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable SpanOrTimer spanOrTimer) {
            HttpURLConnectionInstrumentation.onThrowCommon(spanOrTimer, t);
        }
    }

    @Advice.Pointcut(className="java.net.URLConnection", subTypeRestriction="java.net.HttpURLConnection", methodName="getInputStream", methodParameterTypes={}, nestingGroup="http-client")
    public static class GetInputStreamAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static SpanOrTimer onBefore(@Bind.This HttpURLConnection httpURLConnection, ThreadContext context) {
            return HttpURLConnectionInstrumentation.onBeforeCommon(httpURLConnection, false, context);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return @Nullable InputStream returnValue, @Bind.This HttpURLConnection httpURLConnection, @Bind.Enter @Nullable SpanOrTimer spanOrTimer) {
            if (httpURLConnection instanceof HasSpanMixin) {
                if (returnValue instanceof HasSpanMixin) {
                    Span span = ((HasSpanMixin)((Object)httpURLConnection)).glowroot$getSpan();
                    ((HasSpanMixin)((Object)returnValue)).glowroot$setSpan(span);
                } else if (returnValue != null && !inputStreamIssueLogged.getAndSet(true)) {
                    logger.info("found non-instrumented http url connection input stream, please report to https://github.com/glowroot/instrumentation: {}", (Object)returnValue.getClass().getName());
                }
            }
            HttpURLConnectionInstrumentation.onReturnCaptureResponseCode(httpURLConnection);
            HttpURLConnectionInstrumentation.onReturnCommon(spanOrTimer);
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable SpanOrTimer spanOrTimer) {
            HttpURLConnectionInstrumentation.onThrowCommon(spanOrTimer, t);
        }
    }

    @Advice.Pointcut(className="java.net.URLConnection", subTypeRestriction="java.net.HttpURLConnection", methodName="connect", methodParameterTypes={}, nestingGroup="http-client")
    public static class ConnectAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static SpanOrTimer onBefore(@Bind.This HttpURLConnection httpURLConnection, ThreadContext context) {
            return HttpURLConnectionInstrumentation.onBeforeCommon(httpURLConnection, false, context);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter @Nullable SpanOrTimer spanOrTimer) {
            HttpURLConnectionInstrumentation.onReturnCommon(spanOrTimer);
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable SpanOrTimer spanOrTimer) {
            HttpURLConnectionInstrumentation.onThrowCommon(spanOrTimer, t);
        }
    }

    private static class SpanOrTimer {
        @Nullable
        private final Span span;
        @Nullable
        private final Timer timer;

        private SpanOrTimer(Span span) {
            this.span = span;
            this.timer = null;
        }

        private SpanOrTimer(Timer timer) {
            this.timer = timer;
            this.span = null;
        }

        private void onReturn() {
            if (this.span != null) {
                this.span.end();
            } else if (this.timer != null) {
                this.timer.stop();
            }
        }

        private void onThrow(Throwable t) {
            if (this.span != null) {
                this.span.endWithError(t);
            } else if (this.timer != null) {
                this.timer.stop();
            }
        }
    }

    public static interface HasSpanMixin {
        @Nullable
        public Span glowroot$getSpan();

        public void glowroot$setSpan(@Nullable Span var1);

        public boolean glowroot$hasSpan();
    }

    @Mixin(value={"java.net.HttpURLConnection", "sun.net.www.protocol.http.HttpURLConnection$HttpInputStream", "sun.net.www.protocol.http.HttpURLConnection$StreamingOutputStream", "sun.net.www.http.PosterOutputStream", "weblogic.net.http.KeepAliveStream", "weblogic.utils.io.UnsyncByteArrayOutputStream"})
    public static class HasSpanImpl
    implements HasSpanMixin {
        @Nullable
        private transient Span glowroot$span;

        @Override
        @Nullable
        public Span glowroot$getSpan() {
            return this.glowroot$span;
        }

        @Override
        public void glowroot$setSpan(@Nullable Span span) {
            this.glowroot$span = span;
        }

        @Override
        public boolean glowroot$hasSpan() {
            return this.glowroot$span != null;
        }
    }
}

