/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.jdbc;

import java.sql.Connection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.Logger;
import org.glowroot.instrumentation.api.Message;
import org.glowroot.instrumentation.api.MessageSupplier;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.MonotonicNonNull;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.config.BooleanProperty;
import org.glowroot.instrumentation.api.config.ConfigService;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.jdbc.boot.JdbcInstrumentationProperties;

public class DataSourceInstrumentation {
    private static final Logger logger = Logger.getLogger(DataSourceInstrumentation.class);
    private static final TimerName TIMER_NAME = Agent.getTimerName("jdbc get connection");
    private static final ConfigService configService = Agent.getConfigService("jdbc");
    private static final BooleanProperty captureGetConnection = configService.getBooleanProperty("captureGetConnection");
    private static final BooleanProperty captureConnectionLifecycleTraceEntries = configService.getBooleanProperty("captureConnectionLifecycleTraceEntries");
    private static final BooleanProperty captureTransactionLifecycleTraceEntries = configService.getBooleanProperty("captureTransactionLifecycleTraceEntries");
    private static final AtomicBoolean getAutoCommitExceptionLogged = new AtomicBoolean();

    private static void onReturnSpan(@Nullable Connection connection, Span span) {
        GetConnectionMessageSupplier messageSupplier;
        if (captureTransactionLifecycleTraceEntries.value() && connection != null && (messageSupplier = (GetConnectionMessageSupplier)span.getMessageSupplier()) != null) {
            String autoCommit;
            try {
                autoCommit = Boolean.toString(connection.getAutoCommit());
            }
            catch (Exception e) {
                if (getAutoCommitExceptionLogged.getAndSet(true)) {
                    logger.debug(e.getMessage(), e);
                } else {
                    logger.warn(e.getMessage(), e);
                }
                autoCommit = "<error occurred: " + e.toString() + ">";
            }
            messageSupplier.setAutoCommit(autoCommit);
        }
        span.endWithLocationStackTrace(JdbcInstrumentationProperties.stackTraceThresholdNanos());
    }

    private static class GetConnectionMessageSupplier
    extends MessageSupplier {
        @MonotonicNonNull
        private volatile String autoCommit;

        private GetConnectionMessageSupplier() {
        }

        @Override
        public Message get() {
            if (this.autoCommit == null) {
                return Message.create("jdbc get connection");
            }
            return Message.create("jdbc get connection (autocommit: {})", this.autoCommit);
        }

        private void setAutoCommit(String autoCommit) {
            this.autoCommit = autoCommit;
        }
    }

    @Advice.Pointcut(className="javax.sql.DataSource", methodName="getConnection", methodParameterTypes={".."}, nestingGroup="jdbc")
    public static class GetConnectionAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled() {
            return captureGetConnection.value() || captureConnectionLifecycleTraceEntries.value();
        }

        @Advice.OnMethodBefore
        public static Object onBefore(ThreadContext context) {
            if (captureConnectionLifecycleTraceEntries.value()) {
                return context.startLocalSpan(new GetConnectionMessageSupplier(), TIMER_NAME);
            }
            return context.startTimer(TIMER_NAME);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return @Nullable Connection connection, @Bind.Enter Object spanOrTimer) {
            if (spanOrTimer instanceof Span) {
                DataSourceInstrumentation.onReturnSpan(connection, (Span)spanOrTimer);
            } else {
                ((Timer)spanOrTimer).stop();
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter Object spanOrTimer) {
            if (spanOrTimer instanceof Span) {
                ((Span)spanOrTimer).endWithError(t);
            } else {
                ((Timer)spanOrTimer).stop();
            }
        }
    }
}

