/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.jdbc;

import java.sql.ResultSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.Logger;
import org.glowroot.instrumentation.api.QuerySpan;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.api.config.BooleanProperty;
import org.glowroot.instrumentation.api.config.ConfigService;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.jdbc.StatementInstrumentation;
import org.glowroot.instrumentation.jdbc.boot.StatementMirror;

public class ResultSetInstrumentation {
    private static final Logger logger = Logger.getLogger(ResultSetInstrumentation.class);
    private static final ConfigService configService = Agent.getConfigService("jdbc");
    private static final BooleanProperty captureResultSetNavigate = configService.getBooleanProperty("captureResultSetNavigate");
    private static final BooleanProperty captureResultSetGet = configService.getBooleanProperty("captureResultSetGet");
    private static final AtomicBoolean getRowExceptionLogged = new AtomicBoolean();

    private static boolean isEnabledCommon(StatementInstrumentation.HasStatementMirrorMixin resultSet) {
        StatementMirror mirror = resultSet.glowroot$getStatementMirror();
        return mirror != null && mirror.getLastQuerySpan() != null;
    }

    private static Timer onBeforeCommon(StatementInstrumentation.HasStatementMirrorMixin resultSet) {
        StatementMirror mirror = resultSet.glowroot$getStatementMirror();
        QuerySpan lastQuerySpan = mirror.getLastQuerySpan();
        return lastQuerySpan.extend();
    }

    @Advice.Pointcut(className="java.sql.ResultSet", methodName="get*", methodParameterTypes={"java.lang.String", ".."}, nestingGroup="jdbc")
    public static class ValueAdvice2 {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This StatementInstrumentation.HasStatementMirrorMixin resultSet) {
            return captureResultSetGet.value() && ResultSetInstrumentation.isEnabledCommon(resultSet);
        }

        @Advice.OnMethodBefore
        public static Timer onBefore(@Bind.This StatementInstrumentation.HasStatementMirrorMixin resultSet) {
            return ResultSetInstrumentation.onBeforeCommon(resultSet);
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter Timer timer) {
            timer.stop();
        }
    }

    @Advice.Pointcut(className="java.sql.ResultSet", methodName="get*", methodParameterTypes={"int", ".."}, nestingGroup="jdbc")
    public static class ValueAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This StatementInstrumentation.HasStatementMirrorMixin resultSet) {
            return captureResultSetGet.value() && ResultSetInstrumentation.isEnabledCommon(resultSet);
        }

        @Advice.OnMethodBefore
        public static Timer onBefore(@Bind.This StatementInstrumentation.HasStatementMirrorMixin resultSet) {
            return ResultSetInstrumentation.onBeforeCommon(resultSet);
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter Timer timer) {
            timer.stop();
        }
    }

    @Advice.Pointcut(className="java.sql.ResultSet", methodName="previous|relative|absolute|first|last", methodParameterTypes={".."}, nestingGroup="jdbc")
    public static class NavigateAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This StatementInstrumentation.HasStatementMirrorMixin resultSet) {
            return captureResultSetNavigate.value() && ResultSetInstrumentation.isEnabledCommon(resultSet);
        }

        @Advice.OnMethodBefore
        public static Timer onBefore(@Bind.This StatementInstrumentation.HasStatementMirrorMixin resultSet) {
            return ResultSetInstrumentation.onBeforeCommon(resultSet);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This StatementInstrumentation.HasStatementMirrorMixin resultSet) {
            StatementMirror mirror = resultSet.glowroot$getStatementMirror();
            if (mirror == null) {
                return;
            }
            QuerySpan lastQuerySpan = mirror.getLastQuerySpan();
            if (lastQuerySpan == null) {
                return;
            }
            try {
                lastQuerySpan.setCurrRow(((ResultSet)((Object)resultSet)).getRow());
            }
            catch (Exception e) {
                if (getRowExceptionLogged.getAndSet(true)) {
                    logger.debug(e.getMessage(), e);
                }
                logger.warn(e.getMessage(), e);
            }
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter Timer timer) {
            timer.stop();
        }
    }

    @Advice.Pointcut(className="java.sql.ResultSet", methodName="next", methodParameterTypes={}, nestingGroup="jdbc")
    public static class NextAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.This StatementInstrumentation.HasStatementMirrorMixin resultSet) {
            return captureResultSetNavigate.value() && ResultSetInstrumentation.isEnabledCommon(resultSet);
        }

        @Advice.OnMethodBefore
        public static Timer onBefore(@Bind.This StatementInstrumentation.HasStatementMirrorMixin resultSet) {
            return ResultSetInstrumentation.onBeforeCommon(resultSet);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return boolean currentRowValid, @Bind.This StatementInstrumentation.HasStatementMirrorMixin resultSet) {
            StatementMirror mirror = resultSet.glowroot$getStatementMirror();
            if (mirror == null) {
                return;
            }
            QuerySpan lastQuerySpan = mirror.getLastQuerySpan();
            if (lastQuerySpan == null) {
                return;
            }
            if (currentRowValid) {
                lastQuerySpan.incrementCurrRow();
            } else {
                lastQuerySpan.rowNavigationAttempted();
            }
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter Timer timer) {
            timer.stop();
        }
    }
}

