/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.jdbc.boot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.glowroot.instrumentation.api.checker.Nullable;

public class BindParameterList {
    @Nullable
    private Object[] parameters;
    private int size;

    public static BindParameterList copyOf(BindParameterList bindParameterList) {
        return new BindParameterList(bindParameterList.parameters, bindParameterList.size);
    }

    public BindParameterList(int capacity) {
        this.parameters = new Object[capacity];
    }

    private BindParameterList(@Nullable Object[] parameters, int size) {
        if (parameters.length == size) {
            this.parameters = (Object[])parameters.clone();
        } else {
            this.parameters = new Object[size];
            System.arraycopy(parameters, 0, this.parameters, 0, size);
        }
        this.size = size;
    }

    public void set(int i, @Nullable Object parameter) {
        int capacity = this.parameters.length;
        if (i >= capacity) {
            if (i >= (capacity += capacity >> 1)) {
                capacity = i + 1;
            }
            this.parameters = Arrays.copyOf(this.parameters, capacity);
        }
        this.parameters[i] = parameter;
        int newSize = i + 1;
        if (newSize > this.size) {
            this.size = newSize;
        }
    }

    public int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    List<Object> toDetailList() {
        ArrayList<Object> detailList = new ArrayList<Object>();
        for (int i = 0; i < this.size; ++i) {
            Object parameter = this.parameters[i];
            if (parameter instanceof String) {
                detailList.add(parameter);
                continue;
            }
            if (parameter instanceof Number) {
                detailList.add(parameter);
                continue;
            }
            if (parameter == null) {
                detailList.add(null);
                continue;
            }
            detailList.add(String.valueOf(parameter));
        }
        return detailList;
    }

    public void clear() {
        Arrays.fill(this.parameters, null);
        this.size = 0;
    }
}

