/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.jdbc.boot;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.config.ConfigListener;
import org.glowroot.instrumentation.api.config.ConfigService;
import org.glowroot.instrumentation.api.util.ImmutableMap;

public class JdbcInstrumentationProperties {
    private static final ConfigService configService = Agent.getConfigService("jdbc");
    private static long stackTraceThresholdNanos;
    private static long explainPlanThresholdNanos;
    private static volatile Map<String, Set<Integer>> displayBinaryParameterAsHex;

    private JdbcInstrumentationProperties() {
    }

    public static void setDisplayBinaryParameterAsHex(String sql, int parameterIndex) {
        HashMap<String, Set<Integer>> mutableMap = new HashMap<String, Set<Integer>>(displayBinaryParameterAsHex);
        HashSet<Integer> set = (HashSet<Integer>)mutableMap.get(sql);
        set = set == null ? new HashSet<Integer>() : new HashSet(set);
        set.add(parameterIndex);
        mutableMap.put(sql, set);
        displayBinaryParameterAsHex = ImmutableMap.copyOf(mutableMap);
    }

    public static long stackTraceThresholdNanos() {
        return stackTraceThresholdNanos;
    }

    public static long explainPlanThresholdNanos() {
        return explainPlanThresholdNanos;
    }

    public static boolean displayBinaryParameterAsHex(String sql, int parameterIndex) {
        Set<Integer> set = displayBinaryParameterAsHex.get(sql);
        return set != null && set.contains(parameterIndex);
    }

    private static long getThresholdNanos(String name) {
        Double value = configService.getDoubleProperty(name).value();
        return value == null ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toNanos(value.intValue());
    }

    static {
        displayBinaryParameterAsHex = Collections.emptyMap();
        configService.registerConfigListener(new ConfigListener(){

            @Override
            public void onChange() {
                stackTraceThresholdNanos = JdbcInstrumentationProperties.getThresholdNanos("stackTraceThresholdMillis");
                explainPlanThresholdNanos = JdbcInstrumentationProperties.getThresholdNanos("explainPlanThresholdMillis");
            }
        });
    }
}

