/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.jdbc.boot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.Logger;
import org.glowroot.instrumentation.api.QueryMessageSupplier;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.config.ConfigListener;
import org.glowroot.instrumentation.api.config.ConfigService;
import org.glowroot.instrumentation.api.util.ImmutableList;
import org.glowroot.instrumentation.jdbc.boot.BindParameterList;

public class PreparedStatementMessageSupplier
extends QueryMessageSupplier {
    private static final Logger logger = Logger.getLogger(PreparedStatementMessageSupplier.class);
    private static final ConfigService configService = Agent.getConfigService("jdbc");
    private static List<Pattern> captureBindParametersIncludePatterns = Collections.emptyList();
    private static List<Pattern> captureBindParametersExcludePatterns = Collections.emptyList();
    @Nullable
    private final BindParameterList parameters;
    private final String queryText;

    public PreparedStatementMessageSupplier(@Nullable BindParameterList parameters, String queryText) {
        this.parameters = parameters;
        this.queryText = queryText;
    }

    public Map<String, List<Object>> get() {
        if (this.parameters != null && !this.parameters.isEmpty() && this.captureBindParameters()) {
            return Collections.singletonMap("parameters", this.parameters.toDetailList());
        }
        return Collections.emptyMap();
    }

    private boolean captureBindParameters() {
        String queryTextTrimmed = this.queryText.trim();
        boolean include = false;
        for (Pattern includePattern : captureBindParametersIncludePatterns) {
            if (!includePattern.matcher(queryTextTrimmed).matches()) continue;
            include = true;
            break;
        }
        if (!include) {
            return false;
        }
        for (Pattern excludePattern : captureBindParametersExcludePatterns) {
            if (!excludePattern.matcher(queryTextTrimmed).matches()) continue;
            return false;
        }
        return true;
    }

    static {
        configService.registerConfigListener(new ConfigListener(){

            @Override
            public void onChange() {
                captureBindParametersIncludePatterns = this.buildPatternList("captureBindParametersIncludes");
                captureBindParametersExcludePatterns = this.buildPatternList("captureBindParametersExcludes");
            }

            private List<Pattern> buildPatternList(String propertyName) {
                List<String> values = configService.getListProperty(propertyName).value();
                ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                for (String value : values) {
                    try {
                        patterns.add(Pattern.compile(value.trim(), 32));
                    }
                    catch (PatternSyntaxException e) {
                        logger.warn("the jdbc instrumentation configuration property {} contains an invalid regular expression: {}\n{}", propertyName, value.trim(), e.getMessage());
                    }
                }
                return ImmutableList.copyOf(patterns);
            }
        });
    }
}

