/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.log4j.boot;

import java.util.Locale;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.Logger;
import org.glowroot.instrumentation.api.config.BooleanProperty;
import org.glowroot.instrumentation.api.config.ConfigListener;
import org.glowroot.instrumentation.api.config.ConfigService;

public class LoggerInstrumentationProperties {
    private static final Logger logger = Logger.getLogger(LoggerInstrumentationProperties.class);
    private static final ConfigService configService = Agent.getConfigService("log4j");
    private static int log4j1xThreshold;
    private static int log4j2xThreshold;
    private static final BooleanProperty traceErrorOnWarningWithThrowable;
    private static final BooleanProperty traceErrorOnWarningWithoutThrowable;
    private static final BooleanProperty traceErrorOnErrorWithThrowable;
    private static final BooleanProperty traceErrorOnErrorWithoutThrowable;

    private LoggerInstrumentationProperties() {
    }

    public static boolean captureLog4j1xLevel(int level) {
        return level >= log4j1xThreshold;
    }

    public static boolean captureLog4j2xLevel(int level) {
        return level <= log4j2xThreshold;
    }

    public static boolean markTraceAsError(boolean isErrorOrHigher, boolean isWarnOrHigher, boolean throwable) {
        if (isErrorOrHigher) {
            return throwable ? traceErrorOnErrorWithThrowable.value() : traceErrorOnErrorWithoutThrowable.value();
        }
        if (isWarnOrHigher) {
            return throwable ? traceErrorOnWarningWithThrowable.value() : traceErrorOnWarningWithoutThrowable.value();
        }
        return false;
    }

    static {
        traceErrorOnWarningWithThrowable = configService.getBooleanProperty("traceErrorOnWarningWithThrowable");
        traceErrorOnWarningWithoutThrowable = configService.getBooleanProperty("traceErrorOnWarningWithoutThrowable");
        traceErrorOnErrorWithThrowable = configService.getBooleanProperty("traceErrorOnErrorWithThrowable");
        traceErrorOnErrorWithoutThrowable = configService.getBooleanProperty("traceErrorOnErrorWithoutThrowable");
        configService.registerConfigListener(new ConfigListenerImpl());
    }

    private static class ConfigListenerImpl
    implements ConfigListener {
        private ConfigListenerImpl() {
        }

        @Override
        public void onChange() {
            String thresholdStr = configService.getStringProperty("threshold").value().toLowerCase(Locale.ENGLISH);
            if (thresholdStr.equals("")) {
                log4j1xThreshold = Integer.MIN_VALUE;
                log4j2xThreshold = Integer.MAX_VALUE;
            } else if (thresholdStr.equals("fatal")) {
                log4j1xThreshold = 50000;
                log4j2xThreshold = 100;
            } else if (thresholdStr.equals("error")) {
                log4j1xThreshold = 40000;
                log4j2xThreshold = 200;
            } else if (thresholdStr.equals("warn")) {
                log4j1xThreshold = 30000;
                log4j2xThreshold = 300;
            } else if (thresholdStr.equals("info")) {
                log4j1xThreshold = 20000;
                log4j2xThreshold = 400;
            } else if (thresholdStr.equals("debug")) {
                log4j1xThreshold = 10000;
                log4j2xThreshold = 500;
            } else if (thresholdStr.equals("trace")) {
                log4j1xThreshold = 10000;
                log4j2xThreshold = 600;
            } else {
                logger.warn("unexpected configuration for threshold: {}", (Object)thresholdStr);
                log4j1xThreshold = Integer.MIN_VALUE;
                log4j2xThreshold = Integer.MAX_VALUE;
            }
        }
    }
}

