/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.OptionalThreadContext;
import org.glowroot.instrumentation.api.Timer;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.logback.boot.LogMessageSupplier;
import org.glowroot.instrumentation.logback.boot.LoggerInstrumentationProperties;
import org.glowroot.instrumentation.logback.boot.LoggingEventInvoker;

public class LogbackInstrumentation {
    private static final TimerName TIMER_NAME = Agent.getTimerName("logging");

    private static String nullToEmpty(@Nullable String s) {
        return s == null ? "" : s;
    }

    @Advice.Pointcut(className="ch.qos.logback.classic.Logger", methodName="callAppenders", methodParameterTypes={"ch.qos.logback.classic.spi.LoggingEvent"}, nestingGroup="logging")
    public static class CallAppenders0xAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.Argument(value=0) @Nullable LoggingEvent loggingEvent) {
            if (loggingEvent == null) {
                return false;
            }
            Level level = loggingEvent.getLevel();
            return level != null && LoggerInstrumentationProperties.captureLevel(level.toInt());
        }

        @Advice.OnMethodBefore
        @Nullable
        public static Timer onBefore(@Bind.This Object logger, @Bind.Argument(value=0) LoggingEvent loggingEvent, @Bind.ClassMeta LoggingEventInvoker invoker, OptionalThreadContext context) {
            Throwable t;
            String formattedMessage = invoker.getFormattedMessage(loggingEvent);
            Level level = loggingEvent.getLevel();
            int lvl = level == null ? 0 : level.toInt();
            if (LoggerInstrumentationProperties.markTraceAsError(lvl >= 40000, lvl >= 30000, (t = invoker.getThrowable(loggingEvent)) != null)) {
                context.setTransactionError(formattedMessage, t);
            }
            String levelStr = level == null ? null : level.toString();
            context.captureLoggerSpan(new LogMessageSupplier(formattedMessage, levelStr, invoker.getLoggerName(logger)), t);
            return context.startTimer(TIMER_NAME);
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter @Nullable Timer timer) {
            if (timer != null) {
                timer.stop();
            }
        }
    }

    @Advice.Pointcut(className="ch.qos.logback.classic.Logger", methodName="callAppenders", methodParameterTypes={"ch.qos.logback.classic.spi.ILoggingEvent"}, nestingGroup="logging")
    public static class CallAppendersAdvice {
        @Advice.IsEnabled
        public static boolean isEnabled(@Bind.Argument(value=0) @Nullable ILoggingEvent loggingEvent) {
            if (loggingEvent == null) {
                return false;
            }
            Level level = loggingEvent.getLevel();
            return level != null && LoggerInstrumentationProperties.captureLevel(level.toInt());
        }

        @Advice.OnMethodBefore
        @Nullable
        public static Timer onBefore(@Bind.Argument(value=0) ILoggingEvent loggingEvent, OptionalThreadContext context) {
            String formattedMessage = LogbackInstrumentation.nullToEmpty(loggingEvent.getFormattedMessage());
            Level level = loggingEvent.getLevel();
            int lvl = level == null ? 0 : level.toInt();
            IThrowableProxy throwableProxy = loggingEvent.getThrowableProxy();
            Throwable t = null;
            if (throwableProxy instanceof ThrowableProxy) {
                t = ((ThrowableProxy)throwableProxy).getThrowable();
            }
            if (LoggerInstrumentationProperties.markTraceAsError(lvl >= 40000, lvl >= 30000, t != null)) {
                context.setTransactionError(formattedMessage, t);
            }
            String levelStr = level == null ? null : level.toString();
            context.captureLoggerSpan(new LogMessageSupplier(formattedMessage, levelStr, loggingEvent.getLoggerName()), t);
            return context.startTimer(TIMER_NAME);
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter @Nullable Timer timer) {
            if (timer != null) {
                timer.stop();
            }
        }
    }
}

