/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.mongodb;

import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.QueryMessageSupplier;
import org.glowroot.instrumentation.api.QuerySpan;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.config.ConfigListener;
import org.glowroot.instrumentation.api.config.ConfigService;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;

public class MongoDbInstrumentation {
    private static final TimerName TIMER_NAME = Agent.getTimerName("mongodb query");
    private static final String QUERY_TYPE = "MongoDB";
    private static final ConfigService configService = Agent.getConfigService("mongodb");
    private static long stackTraceThresholdNanos;

    static {
        configService.registerConfigListener(new ConfigListener(){

            @Override
            public void onChange() {
                Double value = configService.getDoubleProperty("stackTraceThresholdMillis").value();
                stackTraceThresholdNanos = value == null ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toNanos(value.intValue());
            }
        });
    }

    public static class InstrumentationCommandListener
    implements CommandListener {
        private static final BsonString MASK_VALUE = new BsonString("?");
        private final Map<Integer, QuerySpan> querySpans = new ConcurrentHashMap<Integer, QuerySpan>();

        public void commandStarted(CommandStartedEvent event) {
            ThreadContext context;
            BsonValue filter;
            String commandName = event.getCommandName();
            BsonDocument command = event.getCommand();
            StringBuilder text = new StringBuilder();
            text.append(commandName);
            String collectionAttrName = commandName.equals("getMore") ? "collection" : commandName;
            BsonValue collectionAttr = command.get((Object)collectionAttrName);
            if (collectionAttr != null && collectionAttr.isString()) {
                text.append(' ');
                text.append(event.getDatabaseName());
                text.append('.');
                text.append(collectionAttr.asString().getValue());
            }
            if (commandName.equals("find") && (filter = command.get((Object)"filter")) != null && filter instanceof BsonDocument && !((BsonDocument)filter).isEmpty()) {
                text.append(' ');
                BsonValue maskedFilter = InstrumentationCommandListener.maskFilter(filter);
                text.append(maskedFilter.toString());
            }
            if ((context = Agent.getThreadContext()) != null) {
                QuerySpan querySpan = context.startQuerySpan(MongoDbInstrumentation.QUERY_TYPE, "", text.toString(), QueryMessageSupplier.create(), TIMER_NAME);
                this.querySpans.put(event.getRequestId(), querySpan);
            }
        }

        public void commandSucceeded(CommandSucceededEvent event) {
            QuerySpan querySpan = this.querySpans.remove(event.getRequestId());
            if (querySpan != null) {
                querySpan.endWithLocationStackTrace(stackTraceThresholdNanos);
            }
        }

        public void commandFailed(CommandFailedEvent event) {
            QuerySpan querySpan = this.querySpans.remove(event.getRequestId());
            if (querySpan != null) {
                querySpan.endWithError(event.getThrowable());
            }
        }

        private static BsonValue maskFilter(BsonValue value) {
            if (value instanceof BsonDocument) {
                BsonDocument dest = new BsonDocument();
                for (Map.Entry entry : ((BsonDocument)value).entrySet()) {
                    dest.append((String)entry.getKey(), InstrumentationCommandListener.maskFilter((BsonValue)entry.getValue()));
                }
                return dest;
            }
            if (value instanceof BsonArray) {
                BsonArray dest = new BsonArray();
                for (BsonValue val : (BsonArray)value) {
                    dest.add(InstrumentationCommandListener.maskFilter(val));
                }
                return dest;
            }
            return MASK_VALUE;
        }
    }

    @Advice.Pointcut(className="com.mongodb.MongoClientOptions|com.mongodb.MongoClientSettings", methodName="getCommandListeners", methodParameterTypes={}, nestingGroup="mongodb")
    public static class MongoCollectionAdvice {
        @Advice.OnMethodReturn
        @Nullable
        public static List<CommandListener> onReturn(@Bind.Return List<CommandListener> commandListeners) {
            ArrayList<CommandListener> newCommandListeners = new ArrayList<CommandListener>(commandListeners);
            newCommandListeners.add(new InstrumentationCommandListener());
            return newCommandListeners;
        }
    }
}

