/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.okhttp;

import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import org.glowroot.instrumentation.api.AsyncSpan;
import org.glowroot.instrumentation.okhttp.OkHttp2xResponseGetter;
import org.glowroot.instrumentation.okhttp.boot.HttpRequestMessageSupplier;

class OkHttp2xCallbackWrapperForNullDelegate
implements Callback {
    private final AsyncSpan span;

    OkHttp2xCallbackWrapperForNullDelegate(AsyncSpan span) {
        this.span = span;
    }

    public void onFailure(Request request, IOException exception) {
        this.span.endWithError(exception);
    }

    public void onResponse(Response response) throws IOException {
        HttpRequestMessageSupplier supplier = (HttpRequestMessageSupplier)this.span.getMessageSupplier();
        if (supplier != null) {
            supplier.setStatusCode(response.code());
        }
        this.span.extractFromResponse(response, OkHttp2xResponseGetter.INSTANCE);
        this.span.end();
    }
}

