/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.redis;

import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.MessageSupplier;
import org.glowroot.instrumentation.api.Setter;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import redis.clients.jedis.Connection;

public class RedisInstrumentation {
    private static final TimerName TIMER_NAME = Agent.getTimerName("redis");
    private static final Setter<Object> SETTER = new NopSetter();
    private static final Object CARRIER = new Object();

    private static String nullToEmpty(@Nullable String string) {
        return string == null ? "" : string;
    }

    private static class NopSetter
    implements Setter<Object> {
        private NopSetter() {
        }

        @Override
        public void put(Object carrier, String key, String value) {
        }
    }

    @Advice.Pointcut(className="redis.clients.jedis.Connection", methodName="connect", methodParameterTypes={}, nestingGroup="redis")
    public static class ConnectAdvice {
        @Advice.OnMethodBefore
        public static Span onBefore(@Bind.This Connection connection, ThreadContext context) {
            return context.startOutgoingSpan("Redis", "CONNECT", SETTER, CARRIER, MessageSupplier.create("redis {}:{} CONNECT", connection.getHost(), Integer.toString(connection.getPort())), TIMER_NAME);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter Span span) {
            span.end();
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter Span span) {
            span.endWithError(t);
        }
    }

    @Advice.Pointcut(className="redis.clients.jedis.Connection", methodName="sendCommand", methodParameterTypes={"*", ".."}, nestingGroup="redis")
    public static class SendCommandAdvice {
        @Advice.OnMethodBefore
        public static Span onBefore(@Bind.This Connection connection, @Bind.Argument(value=0) Object command, ThreadContext context) {
            String cmd = RedisInstrumentation.nullToEmpty(command.toString());
            return context.startOutgoingSpan("Redis", cmd, SETTER, CARRIER, MessageSupplier.create("redis {}:{} {}", connection.getHost(), Integer.toString(connection.getPort()), cmd), TIMER_NAME);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter Span span) {
            span.end();
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter Span span) {
            span.endWithError(t);
        }
    }
}

