/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.spring;

import java.net.URI;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.Getter;
import org.glowroot.instrumentation.api.MessageSupplier;
import org.glowroot.instrumentation.api.OptionalThreadContext;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.config.BooleanProperty;
import org.glowroot.instrumentation.api.util.FastThreadLocal;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.api.weaving.Mixin;
import org.glowroot.instrumentation.api.weaving.Shim;
import org.glowroot.instrumentation.spring.ControllerMethodMeta;

public class WebInstrumentation {
    private static final TimerName TIMER_NAME = Agent.getTimerName("spring controller");
    private static final TimerName WEBSOCKET_TIMER_NAME = Agent.getTimerName("spring websocket controller");
    private static final BooleanProperty useAltTransactionNaming = Agent.getConfigService("spring").getBooleanProperty("useAltTransactionNaming");
    private static final ConcurrentMap<String, String> normalizedPatterns = new ConcurrentHashMap<String, String>();
    private static final FastThreadLocal<URI> webSocketUri = new FastThreadLocal();
    private static final FastThreadLocal<String> webSocketTransactionName = new FastThreadLocal();
    private static final Getter<Object> GETTER = new NopGetter();
    private static final Object REQUEST = new Object();

    private static String getServletPath(@Nullable ThreadContext.ServletRequestInfo servletRequestInfo) {
        if (servletRequestInfo == null) {
            return "";
        }
        String httpMethod = servletRequestInfo.getMethod();
        StringBuilder sb = new StringBuilder();
        if (httpMethod != null && !httpMethod.isEmpty()) {
            sb.append(httpMethod);
            sb.append(' ');
        }
        sb.append(servletRequestInfo.getContextPath());
        if (servletRequestInfo.getPathInfo() != null) {
            sb.append(servletRequestInfo.getServletPath());
        }
        return sb.toString();
    }

    private static class NopGetter
    implements Getter<Object> {
        private NopGetter() {
        }

        @Override
        @Nullable
        public String get(Object carrier, String key) {
            return null;
        }
    }

    @Advice.Pointcut(classAnnotation="org.springframework.stereotype.Controller", methodAnnotation="org.springframework.messaging.handler.annotation.MessageMapping", methodParameterTypes={".."})
    public static class MessageMappingAdvice {
        @Advice.OnMethodBefore
        public static Span onBefore(@Bind.MethodMeta ControllerMethodMeta controllerMethodMeta, OptionalThreadContext context) {
            String transactionName;
            if (useAltTransactionNaming.value()) {
                transactionName = controllerMethodMeta.getAltTransactionName();
            } else {
                transactionName = (String)webSocketTransactionName.get();
                if (transactionName == null) {
                    transactionName = "<unknown>";
                }
            }
            return context.startIncomingSpan("Web", transactionName, GETTER, REQUEST, MessageSupplier.create("spring websocket controller: {}.{}()", controllerMethodMeta.getControllerClassName(), controllerMethodMeta.getMethodName()), WEBSOCKET_TIMER_NAME, OptionalThreadContext.AlreadyInTransactionBehavior.CAPTURE_LOCAL_SPAN);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter Span span) {
            span.end();
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter Span span) {
            span.endWithError(t);
        }
    }

    @Advice.Pointcut(className="org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler", methodName="handleMatch", methodParameterTypes={"java.lang.Object", "org.springframework.messaging.handler.HandlerMethod", "java.lang.String", "org.springframework.messaging.Message"})
    public static class WebSocketMappingAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static FastThreadLocal.Holder<String> onBefore(@Bind.Argument(value=0) @Nullable Object mapping, @Bind.Argument(value=2) @Nullable String lookupDestination, @Bind.Argument(value=3) @Nullable Object message, @Bind.This AbstractMethodMessageHandler messageHandler) {
            String destination;
            if (useAltTransactionNaming.value()) {
                return null;
            }
            if (!(mapping instanceof SimpMessageMappingInfo)) {
                return null;
            }
            DestinationPatternsMessageCondition patternCondition = ((SimpMessageMappingInfo)mapping).glowroot$getDestinationConditions();
            if (patternCondition == null) {
                return null;
            }
            Set<String> patterns = patternCondition.getPatterns();
            if (patterns == null || patterns.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            URI uri = (URI)webSocketUri.get();
            if (uri != null) {
                sb.append(uri);
            }
            if (lookupDestination != null && message != null && (destination = messageHandler.glowroot$getDestination(message)) != null) {
                sb.append(destination.substring(0, destination.length() - lookupDestination.length()));
            }
            String pattern = patterns.iterator().next();
            FastThreadLocal.Holder<String> holder = webSocketTransactionName.getHolder();
            if (pattern == null || pattern.isEmpty()) {
                holder.set(sb.toString());
                return holder;
            }
            String normalizedPattern = (String)normalizedPatterns.get(pattern);
            if (normalizedPattern == null) {
                normalizedPattern = pattern.replaceAll("\\{[^}]*\\}", "*");
                normalizedPatterns.put(pattern, normalizedPattern);
            }
            sb.append(normalizedPattern);
            holder.set(sb.toString());
            return holder;
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter @Nullable FastThreadLocal.Holder<String> holder) {
            if (holder != null) {
                holder.set(null);
            }
        }
    }

    @Advice.Pointcut(className="org.springframework.messaging.support.ExecutorSubscribableChannel$*", superTypeRestriction="java.lang.Runnable", methodName="run", methodParameterTypes={})
    public static class SendTaskRunAdvice {
        @Advice.OnMethodBefore
        public static FastThreadLocal.Holder<URI> onBefore(@Bind.This WithWebSocketUriMixin withWebSocketUri) {
            FastThreadLocal.Holder<URI> holder = webSocketUri.getHolder();
            holder.set(withWebSocketUri.glowroot$getWebSocketUri());
            return holder;
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter FastThreadLocal.Holder<URI> holder) {
            holder.set(null);
        }
    }

    @Advice.Pointcut(className="org.springframework.messaging.support.ExecutorSubscribableChannel$*", superTypeRestriction="java.lang.Runnable", methodName="<init>", methodParameterTypes={".."})
    public static class SendTaskInitAdvice {
        @Advice.OnMethodReturn
        public static void onReturn(@Bind.This WithWebSocketUriMixin withWebSocketUri) {
            withWebSocketUri.glowroot$setWebSocketUri((URI)webSocketUri.get());
        }
    }

    @Advice.Pointcut(className="org.springframework.web.socket.WebSocketHandler", methodName="handleMessage", methodParameterTypes={"org.springframework.web.socket.WebSocketSession", ".."})
    public static class HandleMessageAdvice {
        @Advice.OnMethodBefore
        public static FastThreadLocal.Holder<URI> onBefore(@Bind.Argument(value=0) WebSocketSession session) {
            FastThreadLocal.Holder<URI> holder = webSocketUri.getHolder();
            holder.set(session.getUri());
            return holder;
        }

        @Advice.OnMethodAfter
        public static void onAfter(@Bind.Enter FastThreadLocal.Holder<URI> holder) {
            holder.set(null);
        }
    }

    @Advice.Pointcut(classAnnotation="org.springframework.stereotype.Controller|org.springframework.web.bind.annotation.RestController", methodAnnotation="/org.springframework.web.bind.annotation.(Request|Delete|Get|Patch|Post|Put)Mapping/", methodParameterTypes={".."})
    public static class ControllerAdvice {
        @Advice.OnMethodBefore
        public static Span onBefore(@Bind.MethodMeta ControllerMethodMeta controllerMethodMeta, ThreadContext context) {
            if (useAltTransactionNaming.value()) {
                ThreadContext.ServletRequestInfo servletRequestInfo = context.getServletRequestInfo();
                if (servletRequestInfo == null) {
                    context.setTransactionName(controllerMethodMeta.getAltTransactionName(), -100);
                } else {
                    String httpMethod = servletRequestInfo.getMethod();
                    if (httpMethod == null || httpMethod.isEmpty()) {
                        context.setTransactionName(controllerMethodMeta.getAltTransactionName(), -100);
                    } else {
                        context.setTransactionName(httpMethod + " " + controllerMethodMeta.getAltTransactionName(), -100);
                    }
                }
            }
            return context.startLocalSpan(MessageSupplier.create("spring controller: {}.{}()", controllerMethodMeta.getControllerClassName(), controllerMethodMeta.getMethodName()), TIMER_NAME);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter Span span) {
            span.end();
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter Span span) {
            span.endWithError(t);
        }
    }

    @Advice.Pointcut(className="org.springframework.web.servlet.handler.AbstractUrlHandlerMapping", methodName="exposePathWithinMapping", methodParameterTypes={"java.lang.String", "java.lang.String", "javax.servlet.http.HttpServletRequest"})
    public static class UrlHandlerMappingAdvice {
        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=0) @Nullable String bestMatchingPattern, ThreadContext context) {
            if (useAltTransactionNaming.value()) {
                return;
            }
            String prefix = WebInstrumentation.getServletPath(context.getServletRequestInfo());
            if (bestMatchingPattern == null || bestMatchingPattern.isEmpty()) {
                context.setTransactionName(prefix, -100);
                return;
            }
            String normalizedPattern = (String)normalizedPatterns.get(bestMatchingPattern);
            if (normalizedPattern == null) {
                normalizedPattern = bestMatchingPattern.replaceAll("\\{[^}]*\\}", "*");
                normalizedPatterns.put(bestMatchingPattern, normalizedPattern);
            }
            context.setTransactionName(prefix + normalizedPattern, -100);
        }
    }

    @Advice.Pointcut(className="org.springframework.web.servlet.handler.AbstractHandlerMethodMapping", methodName="handleMatch", methodParameterTypes={"java.lang.Object", "java.lang.String", "javax.servlet.http.HttpServletRequest"})
    public static class HandlerMethodMappingAdvice {
        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=0) @Nullable Object mapping, ThreadContext context) {
            if (useAltTransactionNaming.value()) {
                return;
            }
            if (!(mapping instanceof RequestMappingInfo)) {
                return;
            }
            PatternsRequestCondition patternCondition = ((RequestMappingInfo)mapping).glowroot$getPatternsCondition();
            if (patternCondition == null) {
                return;
            }
            Set<String> patterns = patternCondition.getPatterns();
            if (patterns == null || patterns.isEmpty()) {
                return;
            }
            String prefix = WebInstrumentation.getServletPath(context.getServletRequestInfo());
            String pattern = patterns.iterator().next();
            if (pattern == null || pattern.isEmpty()) {
                context.setTransactionName(prefix, -100);
                return;
            }
            String normalizedPattern = (String)normalizedPatterns.get(pattern);
            if (normalizedPattern == null) {
                normalizedPattern = pattern.replaceAll("\\{[^}]*\\}", "*");
                normalizedPatterns.put(pattern, normalizedPattern);
            }
            context.setTransactionName(prefix + normalizedPattern, -100);
        }
    }

    public static interface WithWebSocketUriMixin {
        @Nullable
        public URI glowroot$getWebSocketUri();

        public void glowroot$setWebSocketUri(@Nullable URI var1);
    }

    @Mixin(value={"org.springframework.messaging.support.ExecutorSubscribableChannel$SendTask", "org.springframework.messaging.support.ExecutorSubscribableChannel$1"})
    public static class WithWebSocketUriImpl
    implements WithWebSocketUriMixin {
        @Nullable
        private transient URI glowroot$webSocketUri;

        @Override
        @Nullable
        public URI glowroot$getWebSocketUri() {
            return this.glowroot$webSocketUri;
        }

        @Override
        public void glowroot$setWebSocketUri(@Nullable URI uri) {
            this.glowroot$webSocketUri = uri;
        }
    }

    @Shim(value={"org.springframework.messaging.handler.DestinationPatternsMessageCondition"})
    public static interface DestinationPatternsMessageCondition {
        @Nullable
        public Set<String> getPatterns();
    }

    @Shim(value={"org.springframework.messaging.simp.SimpMessageMappingInfo"})
    public static interface SimpMessageMappingInfo {
        @Shim(value={"org.springframework.messaging.handler.DestinationPatternsMessageCondition getDestinationConditions()"})
        @Nullable
        public DestinationPatternsMessageCondition glowroot$getDestinationConditions();
    }

    @Shim(value={"org.springframework.messaging.handler.invocation.AbstractMethodMessageHandler"})
    public static interface AbstractMethodMessageHandler {
        @Shim(value={"java.lang.String getDestination(org.springframework.messaging.Message)"})
        @Nullable
        public String glowroot$getDestination(Object var1);
    }

    @Shim(value={"org.springframework.web.socket.WebSocketSession"})
    public static interface WebSocketSession {
        @Nullable
        public URI getUri();
    }

    @Shim(value={"org.springframework.web.servlet.mvc.condition.PatternsRequestCondition"})
    public static interface PatternsRequestCondition {
        @Nullable
        public Set<String> getPatterns();
    }

    @Shim(value={"org.springframework.web.servlet.mvc.method.RequestMappingInfo"})
    public static interface RequestMappingInfo {
        @Shim(value={"org.springframework.web.servlet.mvc.condition.PatternsRequestCondition getPatternsCondition()"})
        @Nullable
        public PatternsRequestCondition glowroot$getPatternsCondition();
    }
}

